/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jpackage.internal.model;

import java.nio.file.Path;
import java.util.Optional;

public interface AppImageSigningConfig {

    SigningIdentity identity();

    String identifierPrefix();

    Optional<Path> entitlements();

    String entitlementsResourceName();

    Optional<String> keychain();

    record Stub(SigningIdentity identity, String identifierPrefix, Optional<Path> entitlements,
            Optional<String> keychain, String entitlementsResourceName) implements AppImageSigningConfig {
    }
}
