/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public interface MacDmgPackageMixin {

    Optional<Path> icon();

    /**
     * Returns additional top=level content for DMG package.
     * <p>
     * Each item in the list can be a directory or a file.
     *
     * @return the additional top=level content for DMG package
     */
    List<Path> content();

    record Stub(Optional<Path> icon, List<Path> content) implements MacDmgPackageMixin {
    }
}
