// Relative Strength Volatility Adjusted EMA /////////////
// Traders Tips 3/2
////////////////////////////////////////////////////

//#define DO_TRADE

var RSEMA(int Periods,int PdsEMA,var Mltp)
{
	asset("VIX");
	var VolatC = priceC();
	asset(AssetPrev);
	vars VolatUpDays = series(ifelse(RET(1)>0,VolatC,0)),
		VolatDnDays = series(ifelse(RET(1)<0,VolatC,0));
	var EMAUp = EMA(VolatUpDays,PdsEMA),
		EMADn = EMA(VolatDnDays,PdsEMA);
	var RS = abs(EMAUp-EMADn)/(EMAUp+EMADn+0.00001)*Mltp; 
	var Rate = (2./(Periods+1))*(RS+1);
	vars RSEMAs = series(0,2);
	return RSEMAs[0] = RSEMAs[1]+Rate*(priceC()-RSEMAs[1]); 
}

function run()
{
	if(!require(2.45)) return;
	set(PLOTNOW,LOGFILE);
	setf(PlotMode,PL_ALL|PL_HLOC);
	BarPeriod = 1440; 
	assetList("AssetsIB");
#ifdef DO_TRADE
	StartDate = 2015; 
	EndDate = 2021;
	asset("SPY");	
	Interest = 2;
	vars RSEMAs = series(RSEMA(10,10,10));
	vars EMAs = series(EMA(seriesC(),10));
	if(crossOver(RSEMAs,EMAs)) enterLong();
	if(crossUnder(RSEMAs,EMAs)) exitLong();
//	if(valley(EMAs)) enterLong(); // simple EMA
//	if(peak(EMAs)) exitLong();
//	if(!NumOpenLong) enterLong(); // buy and hold
#else
	StartDate = 20200801; 
	EndDate = 20201231;
	asset("SPX500");
	assetSelect();
	plot("RS_EMA",RSEMA(10,10,10),LINE,BLUE);
	plot("EMA",EMA(seriesC(),10),LINE,RED);
	asset("VIX");
	plot("VIX",priceC(),NEW,BLACK);
#endif	
}
