// Relative Strength Volatility Adjusted EMA /////////////
// Traders Tips 5/2022
////////////////////////////////////////////////////

//#define DO_TRADE

var RSEMA1(int Periods,int Pds,var Mltp)
{
	var Cup = max(RET(1),0), Cdn = max(-RET(1),0);
	var EMAUp = EMA(Cup,Pds), EMADn = EMA(Cdn,Pds);
	var RS = abs(EMAUp-EMADn)/(EMAUp+EMADn+0.00001)*Mltp; 
	var Rate = 2./(Periods+1)*(1+RS);
	return EMA(priceC(),Rate); 
}

void _plotBuyHold(string BenchMark,int Color)
{
	setf(PlotMode,PL_BENCHMARK);
	if(is(LOOKBACK)) return;
	if(BenchMark)
		asset(BenchMark);
	static var PriceBuy = 0;
	if(PriceBuy == 0) PriceBuy = priceClose();
	var Hold = Leverage*(priceClose()-PriceBuy);
	plot("Benchmark",Hold,LINE|AXIS2,Color);
	if(BenchMark)
		asset(AssetPrev);
}

function run()
{
	if(!require(2.46)) return;
	set(PLOTNOW,LOGFILE);
	BarPeriod = 1440; 
	LookBack = 250;
	assetList("AssetsIB");
#ifdef DO_TRADE
	StartDate = 2009; 
	EndDate = 2021;
	asset("SPY");	
	//Leverage = 1; // simulate cash account
	vars RSEMAs = series(RSEMA1(200,200,10));
	vars EMAs = series(EMA(priceC(),200));
	if(crossOver(RSEMAs,EMAs)) enterLong();
	if(crossUnder(RSEMAs,EMAs)) exitLong();
	_plotBuyHold(0,GREY);
#else
	StartDate = 2009; 
	EndDate = 2021;
	asset("SPX500");
	plot("RS_EMA",RSEMA1(200,200,10),0,BLUE);
	plot("EMA",EMA(seriesC(),200),0,RED);
#endif	
}
