// Seasonality  Strategy ////////////////////////////
// Traders Tips 4/22
////////////////////////////////////////////////////

//#define SEASONAL // sell in August, buy in October

// User definitions ////////////////////////////////

#define STARTDATE	20140101  // Backtest start 
#define ENDDATE	20161231  // Backtest end 

var priceAvg(int Offset) { 
	return (priceC(Offset)+priceH(Offset)+priceL(Offset))/3;
}

var VFI(var Period,var Coef, var VCoef)
{
	vars Inters = series(log(priceAvg(0))-log(priceAvg(1)));
	var Vinter = StdDev(Inters,30);
	var Cutoff = Coef * Vinter * priceC();
	vars Volumes = series(marketVol());
	var Vave = SMA(Volumes+1,Period);
	var Vmax = Vave * VCoef;
	var VC = min(Volumes[0],Vmax);
	var MF = priceAvg(0)-priceAvg(1);
	vars VCPs = series(ifelse(MF > Cutoff,VC,ifelse(MF < -Cutoff,-VC,0)));
	var VFI1 = Sum(VCPs,Period)/Vave;
	return EMA(VFI1,3);
}

function run()
{
	if(!require(2.465)) return;
	StartDate = 2000; 
	EndDate = 2022;
	BarPeriod = 1440; // 1 day
	LookBack = 150;
	PlotScale = 8;

	assetList("AssetsIB");
	MaxLong = 1;
	Capital = -100000;
	Margin = Equity;
	Leverage = 1;
	BarZone = EST;
	Fill = 3; // enter/exit at next day open

	if(Init) assetHistory("SPY",FROM_STOOQ|UNADJUSTED);

#ifdef SEASONAL
	set(LOGFILE,PLOTNOW);
	asset("SPY");
	if(month() == 8 && tdm() == 1) // sell 1st trading day of August, 
		exitLong();
	else if(month() == 10 && tdm() == 1) // buy 1st trading day of October
		enterLong();
#else
	set(PARAMETERS,TESTNOW,PLOTNOW);

	asset("VIX");
	var VIXdn = (priceC(0)/HH(25,0)-1)*100;
	var VIXup = (priceC(0)/LL(25,0)-1)*100;

	asset("SPY");
	int SellMonth = optimize(8,5,8,1);
	var VIXupMax = optimize(60,50,60,10);
	var Crit = -optimize(20,15,20,5); //VFI SELL
	var K = optimize(1.5,1.3,1.7,.2); // ATR/VIX RATIO

	vars ATRs = series(ATR(15));
	var ATRDn = (ATRs[0]/MaxVal(ATRs,25)-1)*100;
	var ATRUp = (ATRs[0]/MinVal(ATRs,25)-1)*100;

	vars VFIs = series(VFI(130,0.2,2.5));
	vars SMAVFIs = series(SMA(VFIs,10));
	bool VolCondition = (VIXup < VIXupMax || ATRUp < K*VIXupMax ) && VFIs[0] > Crit;
	bool Buy = (month() >= 10 || month() < SellMonth) && ref(VolCondition,1) != 0;
	bool SellSeasonal = month() == SellMonth ; //SEASONAL
	bool SellVolatility = VIXup > 2*VIXupMax ; //VOLATILITY EXIT
	bool SellMF = crossUnder(VFIs,Crit) && SMAVFIs[0] < SMAVFIs[1] ;
	bool Sell = SellSeasonal || ref(SellVolatility,1) != 0 || ref(SellMF,1) != 0;

	if(Sell)
		exitLong();
	else if(Buy)
		enterLong();
#endif
}
