// trend follower 

function run()
{
	set(PARAMETERS,TESTNOW,PLOTNOW,LOGFILE);
	BarPeriod = 1440;
	LookBack = 100;
	StartDate = 2012;
	EndDate = 20220325; // current date

	NumWFOCycles = 10;
	NumCores = -1;

	assetList("AssetsIB"); // simulate IB margin account...
	History = "?.t6";
	assetAdd("SPY","STOOQ:*"); // ...but get price history from STOOQ
	asset("SPY");

	int Period = optimize(10,2,20,2);
	vars Signals = series(LowPass(seriesC(),Period));
	Period = optimize(50,40,60,5);
	vars MMIFast = series(MMI(seriesC(),Period));
	vars MMISlow = series(LowPass(MMIFast,100));
	//plot("MMI",MMISlow,NEW,RED);
	
	MaxLong = 1;
	if(falling(MMISlow)) {
		if(valley(Signals))
			enterLong();
		else if(peak(Signals))
			exitLong();
	}
}