// Ehlers' Precision Trend Indicator ///////////////////////
// Traders Tips 9/2024
////////////////////////////////////////////////////
var TROC = 0;

var HighPass3(vars Data,int Length)
{
	var f = 1.414*PI/Length;
	var a1 = exp(-f);
	var c2 = 2*a1*cos(f);
	var c3 = -a1*a1;
	var c1 = (1+c2-c3)/4;
	vars HP = series(0,4);
	return HP[0] = c1*(Data[0] - 2*Data[1] + Data[2])
		+ c2*HP[1] + c3*HP[2];
}

var Trend(vars Data,int Length1,int Length2)
{
	var HP1 = HighPass3(Data,Length1);
	var HP2 = HighPass3(Data,Length2);
	vars Trends = series(HP1-HP2,2);
	TROC = (Length2/6.28)*(Trends[0]-Trends[1]);
	return Trends[0];
}

function run()
{
	set(PLOTNOW);
	BarPeriod = 1440; 
	StartDate = 20221001; 
	EndDate = 20240401;
	LookBack = 252;
	PlotHeight2 = PlotHeight1/2;
	assetAdd("ES","YAHOO:ES=F");
	asset("ES");
	plot("HP",HighPass3(seriesC(),250),NEW,RED);
	plot("Trend",Trend(seriesC(),250,40),NEW,RED);
	plot("ROC",TROC,0,BLUE);
}

