// Ehlers' Ultimate Strength Index ///////////////////////
// Traders Tips 11/2024
////////////////////////////////////////////////////

var UltimateSmooth(var *Data,int Length)
{
	var f = (1.414*PI) / Length;
	var a1 = exp(-f);
	var c2 = 2*a1*cos(f);
	var c3 = -a1*a1;
	var c1 = (1+c2-c3)/4;
	vars US = series(*Data,4);
	return US[0] = (1-c1)*Data[0] + (2*c1-c2)*Data[1] - (c1+c3)*Data[2]
		+ c2*US[1] + c3*US[2];
}

var UltimateStrength(int Length)
{
	vars SU = series(max(0,priceC(0) - priceC(1)));
	var USU = UltimateSmooth(series(SMA(SU,4)),Length);
	vars SD = series(max(0,priceC(1) - priceC(0)));
	var USD = UltimateSmooth(series(SMA(SD,4)),Length);
	return (USU-USD)/fix0(USU+USD);
}

function run()
{
	set(PLOTNOW);
	Verbose = 3;
	BarPeriod = 1440; 
	StartDate = 20230801; 
	EndDate = 20240801;
	PlotHeight2 = PlotHeight1;
	assetAdd("SPX","STOOQ:^SPX");
	asset("SPX");
	plot("USI(112)",UltimateStrength(112),NEW|LINE,BLUE);
	plot("USI(28)",UltimateStrength(28),NEW|LINE,BLUE);
}

