// Kaufman: Trading the Channels ///////////////////
// Traders Tips 5/2024
////////////////////////////////////////////////////

#define DO_PLOT
//#define DO_TRADE
//#define ONLY_LONG
//#define DO_OPTIMIZE

int i,Period = 40;
var Factor = 0.2;

function run()
{
	set(TESTNOW,PLOTNOW,LOGFILE);
	BarPeriod = 1440; 
#ifdef DO_PLOT
	setf(PlotMode,PL_LONG);
	StartDate = 2025; 
	LookBack = Period;
#else
	StartDate = 20100101; 
	LookBack = 150;
#endif
	History = "?.t6";
	assetList("AssetsIB");
	asset("SPY");
	
#ifdef DO_OPTIMIZE
	set(PARAMETERS);
	NumWFOCycles = 5;
	Period = optimize(40,20,150,10);
	Factor = optimize(0.2,0.05,0.5,0.05);
#endif

	if(is(LOOKBACK)) return;
	var Slope = LinearRegSlope(seriesC(),Period);
	var Intercept = LinearRegIntercept(seriesC(),Period);
	var LinVal, HighDev = 0, LowDev = 0;
	for(i=Period; i>0; i--) { 
		LinVal = Intercept + Slope*(Period-i);
		HighDev = max(HighDev,priceC(i)-LinVal);
		LowDev = min(LowDev,priceC(i)-LinVal);
	}
#ifdef DO_PLOT
	for(i=Period; i>0; i--) { 
		LinVal = Intercept + Slope*(Period-i);
		plotGraph("Linreg",i,LinVal,LINE,RED);
		plotGraph("Upper",i,LinVal+HighDev,LINE,DARKGREEN);
		plotGraph("Lower",i,LinVal+LowDev,LINE,DARKBLUE);
	}
	printf("\nSlope %.2f",Slope);
	return quit("Done!");
#endif
#ifdef DO_TRADE
	var Zone = Factor*(HighDev+LowDev);
	if(!NumOpenLong && priceC() < LinVal+LowDev+Zone)
		enterLong();
	if(!NumOpenShort && priceC() > LinVal+HighDev-Zone)
#ifdef ONLY_LONG
		exitLong();
#else
		enterShort();
#endif
#endif
}

