// Ehlers' Cybernetic Oscillator ///////////////////////
// Traders Tips 6/2025
////////////////////////////////////////////////////

#define DO_TRADE

var CyberOsc(vars Data,int HPLength,int LPLength)
{
	vars HP = series(HighPass3(Data,HPLength));
	vars LP = series(Smooth(HP,LPLength));
	var RMS = sqrt(SumSq(LP,100)/100);
	return LP[0]/fix0(RMS);
}

function run()
{
	set(PLOTNOW);
	PlotHeight2 = 0.66*PlotHeight1;
	BarPeriod = 1440; 
#ifndef DO_TRADE
	LookBack = 250;
	StartDate = 20240301; 
	EndDate = 20250407;
	asset("SPX500");
	plot("CyberOsc1",CyberOsc(seriesC(),30,20),NEW|LINE,RED);
	plot("CyberOsc2",CyberOsc(seriesC(),250,20),NEW|LINE,BLUE);
#else
	LookBack = 250;
	StartDate = 2008; 
	EndDate = 2025;
	Fill = 2; // enter at next open
	History = "?.t6";
	assetList("AssetsIB");
	asset("SPY");
	//Slippage = Spread = Commission = 0; // no trading cost
	vars LP = series(Smooth(seriesC(),20));
	vars BP1 = series(HighPass3(LP,55));
	var ROC1 = BP1[0] - BP1[2];
	vars BP2 = series(HighPass3(LP,156));
	var ROC2 = BP2[0] - BP2[2];
	if(!NumOpenLong && ROC1 > 0 && ROC2 > 0)
		enterLong();
	if(NumOpenLong && (ROC1 < 0 || ROC2 < 0))
		exitLong();
#endif

}

