// Ehlers' Predictive Moving Average ///////////////
// Traders Tips 3/2025
////////////////////////////////////////////////////

var PMA(vars Data,int Length)
{
	var Sx = 0, Sy = 0, Sxx = 0, Syy = 0, Sxy = 0;
	int i;
	for(i=1; i<=Length; i++) {
		Sx += i;
		Sy += Data[i-1];
		Sxx += i*i;
		Syy += Data[i-1]*Data[i-1];
		Sxy += i*Data[i-1];
	}
	var Slope = -(Length*Sxy - Sx*Sy) / (Length*Sxx - Sx*Sx);
	return Sy/Length + Slope*Length/2;
}

function run()
{
	set(PLOTNOW);
	BarPeriod = 1440; 
	StartDate = 20231001; 
	EndDate = 20241001;
	LookBack = 30;
	ColorUp = WHITE;
	ColorDn = GREY;
	assetAdd("SPX","STOOQ:^SPX");
	asset("SPX");
	plot("PMA",PMA(seriesC(),LookBack),LINE,BLUE);
	plot("SMA",SMA(seriesC(),LookBack),LINE,RED);
}

/*
var Predict;
var PMA(vars Data,int Length)
{
	var Sx = 0, Sy = 0, Sxx = 0, Syy = 0, Sxy = 0;
	int i;
	for(i=1; i<=Length; i++) {
		var Data0 = Data[i-1];
		Sx += i;
		Sy += Data0;
		Sxx += i*i;
		Syy += Data0*Data0;
		Sxy += i*Data0;
	}
	vars Slopes = series(-(Length*Sxy - Sx*Sy) / (Length*Sxx - Sx*Sx),2);
	var Pma = Sy/Length + Slopes[0]*Length/2;
	Predict = Pma + (Slopes[0]-Slopes[2])*Length/2;
	return Pma;
}

function run()
{
	set(PLOTNOW);
	BarPeriod = 1440; 
	StartDate = 20231001; 
	EndDate = 20241001;
	assetAdd("SPX","STOOQ:^SPX");
	asset("SPX");
	int Length = 30;
	plot("PMA",PMA(seriesC(),Length),LINE,BLUE);
	//plot("SMA",SMA(seriesC(),Length),LINE,RED);
	plot("Predict",Predict,LINE,RED);
}
*/