//////////////////////////////////////////////////////////
// PointsLine.c — Zorro C port of "Points & Line" chart
// Ashraf & Meregy, TASC Traders' Tips 
// Conversion P. Volkova & ChatGPT 5.0
//////////////////////////////////////////////////////////
// Modes
#define SCALE_DEFAULT   0
#define SCALE_ATR       1
#define SCALE_PERCENT   2
#define M_POINTSIZE     0
#define M_HIGHLOW       1
#define M_CLOSE         2

// User parameters 
int  gReverse = 3;         // boxes needed to reverse
int  gScale = SCALE_DEFAULT; // 0=Default, 1=ATR(14), 2=Percent
int  gMethod = M_CLOSE;      // 0=PointSize, 1=HighLow, 2=Close
var  gPercent = 1.0;         // % for SCALE_PERCENT

// Compute "box size"
var box(var Price)
{
	if(gScale == SCALE_DEFAULT) {
#define RNG(X,Y) if(Price < X) return Y
		RNG(0.25,0.025);
		RNG(0.5,0.05);
		RNG(1,0.1);
		RNG(5,0.25);
		RNG(20,0.5);
		RNG(100,1);
		RNG(200,2);
		RNG(500,5);
		RNG(1000,10);
		RNG(2000,20);
		RNG(5000,50);
		RNG(10000,100);
		RNG(20000,200);
		return 500;
	} 
	if(gScale = SCALE_ATR)
		return ATR(14);
	else // SCALE_PERCENT
		return Price*gPercent/100;
}

// User-defined bars
function bar(var *Open, var *High, var *Low, var *Close)
{
	var O = Open[0], C = Close[0], H = High[0], L = Low[0];
	static int gDir = -1; // initially down
	static var gCF = C, gCR = C, gLF = C, gHR = C;

// box size
	var Box = fix0(box(C));
	var CF = ceil(C/Box)*Box,
		CR = floor(C/Box)*Box,
		LF = ceil(L/Box)*Box,
		HR = floor(H/Box)*Box;
	
// 
	switch(gMethod) 
	{
		case M_POINTSIZE:
			if(CF < gCF && gDir < 0) { // continue down, new box
				gCR = CF - Box; gCF = CF;
				Close[0] = CF; return 1;
			} 
			if(gCF + Box*gReverse <= CR && gDir < 0) {
				gCR = CR; gCF = CR + Box; 
				Close[0] = CR; gDir = 1; return 1; // swap direction 
			}
			if(gCR < CR && gDir > 0) { // continue up
				gCR = CR; gCF = CR + Box; Close[0] = CR; return 1;
			}
			if(gCR - Box*gReverse >= CF && gDir > 0) {
				gCF = CF; gCR = CF - Box; Close[0] = CF;
				gDir = -1; return 1;
			}
			break;
			
		case M_HIGHLOW:
			if(LF < gLF && gDir < 0) {
				gHR = LF - Box; gLF = LF; 
				Close[0] = L; return 1;
			} 
			if(gLF + Box*gReverse <= HR && gDir < 0) {
				gHR = HR; gLF = HR + Box; 
				Close[0] = H; gDir = 1; return 1;
			}
			if(gHR < HR && gDir > 0) {
				gHR = HR; gLF = HR + Box; 
				Close[0] = H; return 1;
			} 
			if(gHR - Box*gReverse >= LF && gDir > 0) {
				gLF = LF; gHR = LF - Box; 
				Close[0] = L; gDir = -1; return 1;
			}
			break;
	
		case M_CLOSE:
			if(CF < gCF && gDir < 0) { // continue down
				gCR = CF-Box; gCF = CF; 
				return 1;
			} 
			if(gCF+Box*gReverse <= CR && gDir < 0) { // go up
				gCR = CR; gCF = CR+Box; 
				gDir = 1; return 1;
			}
			if(gCR < CR && gDir > 0) {
				gCR = CR; gCF = CR+Box; 
				return 1;
			} 
			if(gCR-Box*gReverse >= CF && gDir > 0) {
				gCF = CF; gCR = CF-Box; 
				gDir = -1; return 1;
			}
			break;
	}
	return 4; // keep bar open, call again on next tick  
}

function run()
{
	set(PLOTNOW,TICKS);
	Slippage = 0;
	BarPeriod = 1440;
	LookBack  = 120;
	StartDate = 20120101;
	EndDate = 20241231;
	BarZone = EST;

	assetAdd("DJIA","STOOQ:^DJI");
	asset("DJIA");

	setf(PlotMode,PL_FINE|PL_LINE);
	PlotHeight2 = 2./3*PlotHeight1;
	plot("MACD",MACDFix(seriesC(),14),NEW,RED);
	plot("Signal",rMACDSignal,0,GREY);
}