// Portfolio rotation system /////////////
// TASC 8/25
//////////////////////////////////////////

var Score[1000],Weights[1000];

void rotate(int Buy)
{
	for(listed_assets) {
		asset(Asset);
		int NewLots = ifelse(Train,Capital,Equity)
			*Weights[Itor]/MarginCost;
		if(NewLots < LotsPool)
			exitLong(0,0,LotsPool-NewLots);
		else if(Buy && NewLots > LotsPool)
			enterLong(NewLots-LotsPool);
	}
}

void run() 
{
	if(!require(2.67)) return;
	set(TESTNOW,PLOTNOW,LOGFILE);
	StartDate = 2012; 
	EndDate = 2025;
	BarPeriod = 1440;
	LookBack = 252;
	History = "?.t6";
	TradesPerBar = 20;
	Capital = slider(1,10000,0,20000,"Capital","");
	
	assetList("AssetsNASDAQ");
	assetAdd("QQQ","STOOQ:QQQ");
	asset(Asset);
	assetSelect();
	
// global optimization /////////////////////
	set(PARAMETERS);
	setf(TrainMode,TRADES|GENETIC); // size matters

	int ROCBars = optimize(100,50,250,50);
	int ExitBars = optimize(20,10,50,5);
	int MAPeriod = optimize(300,100,1000,100);
	int MaxOpenPositions = optimize(15,5,30,5);
	int ExcludeTopN = optimize(2,1,5,1);
/////////////////////////////////////////////

// bear market filter
	var MAQQQ = ZMA(seriesC(),MAPeriod);
	int Bear = MAQQQ < ref(MAQQQ,1);
	plot("Volume",MarginTotal,NEW|LINE,BLUE);
	plot("QQQ",MAQQQ,NEW|LINE,GREEN);
	if(Bear) plot("Bear",MAQQQ,LINE,RED);

	if(Day%ExitBars == 0)
	{
// assign a score to any asset
		for(listed_assets) { 
			asset(Asset);
			if(Asset == "QQQ" || Bear)
				Score[Itor] = 0; // don't trade the index
			else
				Score[Itor] = ROC(seriesC(),ROCBars);
		}
// exclude the N top scores
		int i;
		for(i=0; i<ExcludeTopN; i++) {
			//printf("\n%.3f",Score[MaxIndex(Score,NumAssetsListed)]); 
			Score[MaxIndex(Score,NumAssetsListed)] = 0;
		}
		
// rotate positions
		distribute(Weights,Score,NumAssetsListed,MaxOpenPositions,0.5); 
		rotate(0);	// exit old positions
		rotate(1);	// enter new positions
	}
}
