# Copyright 2016 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Sample app that uses the Google App Engine Remote API to make calls to the
live App Engine APIs."""

# [START gae_remoteapi_client_app]
import argparse

try:
    import dev_appserver

    dev_appserver.fix_sys_path()
except ImportError:
    print("Please make sure the App Engine SDK is in your PYTHONPATH.")
    raise

from google.appengine.ext import ndb
from google.appengine.ext.remote_api import remote_api_stub


def main(project_id):
    remote_api_stub.ConfigureRemoteApiForOAuth(
        "{}.appspot.com".format(project_id), "/_ah/remote_api"
    )

    # List the first 10 keys in the datastore.
    keys = ndb.Query().fetch(10, keys_only=True)

    for key in keys:
        print(key)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=__doc__, formatter_class=argparse.RawDescriptionHelpFormatter
    )
    parser.add_argument("project_id", help="Your Project ID.")

    args = parser.parse_args()

    main(args.project_id)
# [END gae_remoteapi_client_app]
