# Visual Data Analysis

Visual data analysis presents datasets through visual representations
that include graphs, charts, plots and even animations. Typically they
provide an understanding of how the values of a variable are
distributed &mdash; the **distribution** of the data. You will identify
patterns in the data that in themselves can provide insights, and even
actionable understandings, from the data.

Rattle provides some of the visualisations commonly used by data
scientists to gain initial insights into the data. The R code used to
generate the examples here is captured and can be reviewed and saved
to file via the **Script** tab. This will allow the code to be
edited and extended to suit the data and to present the visualisations
more creatively and expressively for your particular dataset.  The
Data Visualisation chapter of the [Data Science Desktop Survival
Guide](https://survivor.togaware.com/datascience/data-visualisation.html)
provides a detailed exploration of what is possible.

For **numeric** data Rattle supports [Box
Plots](https://survivor.togaware.com/datascience/box-plot.html),
[Density
Plots](https://survivor.togaware.com/datascience/density-plot.html),
[Cumulative
Plots](https://survivor.togaware.com/datascience/cumulative-plot.html),
and the [Benford's
Plot](https://survivor.togaware.com/datascience/benford-plot.html).

For **categoric** data Rattle supports [Bar
Charts](https://survivor.togaware.com/datascience/bar-chart.html),
[Dot Plots](https://survivor.togaware.com/datascience/dot-plot.html),
and the [Mosaic
Plot](https://survivor.togaware.com/datascience/mosaic-plot.html).

Different themes (colour and style) for your plots can be chosen for
all of the *ggplot2* based plots. See the [Data Science Desktop
Survival
Guide](https://survivor.togaware.com/datascience/themes-in-rattle.html)
for details.
