<?php

/**
 * User: Evstafev Kirill
 * Date: 02.08.2016
 * Version: 2.0
 */
class Check
{
    private $lang = 'en';
    private $t = [];
    private $t_ru = array(
        'check' => 'Проверка',
        'settings' => 'Настройки',
        'modules' => 'Модули',
        'minimum' => 'Минимальное',
        'recommended' => 'Рекомендуемое',
        'value' => 'Значение',
        'check_text_file' => 'Проверка на запись, чтение файлов',
        'check_other' => 'Другие проверки',
        'check_session' => 'Проверка сессии',
        'check_uploaded_file' => 'Проверка загрузки файлов',
        'result' => 'Результат',
        'error_uploaded_file' => 'Некоторая отладочная информация',
        'send_file' => 'Отправить этот файл',
        'upload' => 'Загрузить',
        'check_db' => 'Проверка базы',
        'exit' => 'Войти',
        'error_file' => array(
            0 => 'Ошибок не возникло, файл был успешно загружен на сервер',
            1 => 'Размер принятого файла превысил максимально допустимый размер, который задан директивой upload_max_filesize конфигурационного файла php.ini',
            2 => 'Размер загружаемого файла превысил значение MAX_FILE_SIZE, указанное в HTML-форме',
            3 => 'Загружаемый файл был получен только частично',
            4 => 'Файл не был загружен',
            6 => 'Отсутствует временная папка',
            7 => 'Не удалось записать файл на диск',
            8 => 'PHP-расширение остановило загрузку файла'
        )
    );

    private $t_en = array(
        'check' => 'Check',
        'settings' => 'Settings',
        'modules' => 'Modules',
        'minimum' => 'Minimum',
        'recommended' => 'Recommended',
        'value' => 'Value',
        'check_text_file' => 'Check for the entry, reading files',
        'check_other' => 'Other checks',
        'check_session' => 'Check session',
        'check_uploaded_file' => 'Checking download files',
        'result' => 'Result',
        'error_uploaded_file' => 'Some more debugging info',
        'send_file' => 'Send this file',
        'upload' => 'Download',
        'check_db' => 'Check database',
        'exit' => 'Enter',
        'error_file' => array(
            0 => 'There is no error, the file uploaded with success',
            1 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
            2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
            3 => 'The uploaded file was only partially uploaded',
            4 => 'No file was uploaded',
            6 => 'Missing a temporary folder',
            7 => 'Failed to write file to disk',
            8 => 'A PHP extension stopped the file upload'
        )
    );

    private $parameters = array(
        'max_execution_time' => array(
            'type' => 'integer',
            'minimum' => '240',
            'recommended' => '360'
        ),
        'max_input_time' => array(
            'type' => 'integer',
            'minimum' => '60',
            'recommended' => '120'
        ),
        'memory_limit' => array(
            'type' => 'integer',
            'minimum' => '256M',
            'recommended' => '512M',
        ),
        'post_max_size' => array(
            'type' => 'integer',
            'minimum' => '256M',
            'recommended' => '512M',
            'maximum' => 'memory_limit'
        ),
        'upload_max_filesize' => array(
            'type' => 'integer',
            'minimum' => '256M',
            'recommended' => '512M',
            'maximum' => 'post_max_size'
        )
    );

    public function __construct()
    {
        $this->t = ($this->lang === 'ru') ? $this->t_ru : $this->t_en;
    }

    public function set_lang($lang)
    {
        $this->lang = $lang;
        $this->t = ($this->lang === 'ru') ? $this->t_ru : $this->t_en;
    }

    public function get_lang()
    {
        return $this->lang;
    }

    public function t($message)
    {
        $args = func_get_args();
        $t = $this->t;
        foreach ($args as $arg) {
            $t = $t[$arg];
        }
        return $t;
    }

    private function get_parameters($type, $parameter_name)
    {
        if ($type === 'maximum') {
            return $this->get_ini_get($this->parameters[$parameter_name][$type]);
        }

        return $this->parameters[$parameter_name][$type];
    }

    public function get_parameters_min($parameter_name)
    {
        return $this->get_parameters('minimum', $parameter_name);
    }

    public function get_parameters_rec($parameter_name)
    {
        return $this->get_parameters('recommended', $parameter_name);
    }

    public function get_parameters_max($parameter_name)
    {
        return $this->get_parameters('maximum', $parameter_name);
    }

    public function get_parameters_type($parameter_name)
    {
        return $this->get_parameters('type', $parameter_name);
    }

    public function check_upload_file()
    {
        if (isset($_FILES['user_file']['name'])) {
            $upload_file = basename($_FILES['user_file']['name']);

            if (move_uploaded_file($_FILES['user_file']['tmp_name'], $upload_file)) {
                $result_check = $this->t('result') . ': ' . $this->check_status(1);
                unlink($upload_file);
            } else {
                $result_check = $this->t('result') . ': ' . $this->check_status(0);
                $result_check .= ' - ' . $this->t('error_file', $_FILES['user_file']['error']);
            }
        } else {
            $result_check = $this->t('error_file', 4);
        }

        return $result_check;
    }

    public function get_ini_get($parameter_name)
    {
        return ini_get($parameter_name);
    }

    public function check_ini_get($parameter_name)
    {
        $type = $this->get_parameters_type($parameter_name);
        switch ($type) {
            case 'integer':
                $value = $this->get_ini_get($parameter_name);
                if ($this->parameters[$parameter_name]['maximum'] && ((int)$value > (int)$this->get_parameters_max($parameter_name))) {
                    return $this->check_status(0) . " - $parameter_name ($value) > " .
                        $this->parameters[$parameter_name]['maximum'] . ' (' . $this->get_parameters_max($parameter_name) . ')';
                }

                if ((int)$value >= (int)$this->get_parameters_rec($parameter_name)) {
                    return $this->check_status(1);
                }

                if ((int)$value >= (int)$this->get_parameters_min($parameter_name)) {
                    return $this->check_status(2);
                }

                return $this->check_status(0);
                break;
            default:
                return $this->check_status(-2);
                break;
        }

    }

    public function check_loaded_extensions($name, $type)
    {
        $array_loaded_extensions = get_loaded_extensions();
        foreach ($array_loaded_extensions as $val) {
            if (strripos($val, $name) !== false) {
                return $this->check_status(1);
            }
        }

        if ($type === 'loader') {
            return $this->check_status(-1);
        }

        return $this->check_status(0);
    }

    public function check_str()
    {
        mb_internal_encoding('UTF-8');
        if ((strlen('Счет MWE_самострой с регсбором.rtf') != 57) || (mb_strlen('Счет MWE_самострой с регсбором.rtf') != 34)) {
            return $this->check_status(0);
        }

        return $this->check_status(1);
    }

    public function get_php_version()
    {
        $rev_file_info = @file_get_contents('revision');
        if ($rev_file_info) {
            $lns = explode("\n", $rev_file_info);
            $coder_inf = explode(': ', $lns[2]);
            $config['coded_by'] = $coder = $coder_inf[1];
        }
        $value = explode('.', PHP_VERSION);
        $value = $value[0] . '.' . $value[1];
        return $value;
    }

    public function check_php_version()
    {
        $value = (string)$this->get_php_version();
        if ($value === '5.5' OR $value === '5.6') {
            return $this->check_status(2);
        }

        if ($value === '7.0') {
            return $this->check_status(1);
        }

        return $this->check_status(0);
    }

    // Проверяем error_reporting
    public function check_error_reporting()
    {
        $errLvl = error_reporting();

        // должно быть
        $array_error_reporting = array();
        $array_error_reporting['E_ERROR'] = 1;
        $array_error_reporting['E_WARNING'] = 1;
        $array_error_reporting['E_PARSE'] = 1;
        $array_error_reporting['E_NOTICE'] = 0;
        $array_error_reporting['E_CORE_ERROR'] = 1;
        $array_error_reporting['E_CORE_WARNING'] = 1;
        $array_error_reporting['E_COMPILE_ERROR'] = 1;
        $array_error_reporting['E_COMPILE_WARNING'] = 1;
        $array_error_reporting['E_USER_ERROR'] = 1;
        $array_error_reporting['E_USER_WARNING'] = 1;
        $array_error_reporting['E_USER_NOTICE'] = 1;
        $array_error_reporting['E_STRICT'] = 0;
        $array_error_reporting['E_RECOVERABLE_ERROR'] = 1;
        $array_error_reporting['E_DEPRECATED'] = 0;
        $array_error_reporting['E_USER_DEPRECATED'] = 1;

        // Обнуляем и смотрим как у хостера выставленно
        $array_error_reporting_check = $array_error_reporting;
        foreach ($array_error_reporting_check as $key => $val) {
            $array_error_reporting_check[$key] = 0;
        }
        for ($i = 0; $i < 15; $i++) {
            $nameErrorType = $this->FriendlyErrorType($errLvl & pow(2, $i));
            if ($nameErrorType) {
                $array_error_reporting_check[$nameErrorType] = 1;
            }
        }

        return $this->check_status(($array_error_reporting == $array_error_reporting_check) ? 1 : 0);
    }

    public function FriendlyErrorType($type)
    {
        switch ($type) {
            case E_ERROR: // 1 //
                return 'E_ERROR';
            case E_WARNING: // 2 //
                return 'E_WARNING';
            case E_PARSE: // 4 //
                return 'E_PARSE';
            case E_NOTICE: // 8 //
                return 'E_NOTICE';
            case E_CORE_ERROR: // 16 //
                return 'E_CORE_ERROR';
            case E_CORE_WARNING: // 32 //
                return 'E_CORE_WARNING';
            case E_COMPILE_ERROR: // 64 //
                return 'E_COMPILE_ERROR';
            case E_COMPILE_WARNING: // 128 //
                return 'E_COMPILE_WARNING';
            case E_USER_ERROR: // 256 //
                return 'E_USER_ERROR';
            case E_USER_WARNING: // 512 //
                return 'E_USER_WARNING';
            case E_USER_NOTICE: // 1024 //
                return 'E_USER_NOTICE';
            case E_STRICT: // 2048 //
                return 'E_STRICT';
            case E_RECOVERABLE_ERROR: // 4096 //
                return 'E_RECOVERABLE_ERROR';
            case E_DEPRECATED: // 8192 //
                return 'E_DEPRECATED';
            case E_USER_DEPRECATED: // 16384 //
                return 'E_USER_DEPRECATED';
        }
        return '';
    }

    public function check_status($status)
    {
        $text = 'ERROR!';
        $color = '#BB0000';
        switch ($status) {
            case 2:
                $text = 'NORM!';
                $color = '#DDDD00';
                break;
            case 1:
                $text = 'OK!';
                $color = '#00BB00';
                break;
            case 0:
                $text = 'ERROR!';
                $color = '#BB0000';
                break;
            case -1:
                $text = 'NO!';
                $color = '#DDDD00';
                break;
            case -2:
                $text = 'ERROR - type!';
                $color = '#BB0000';
                break;
        }
        return "<br /><span style='color: $color'><b>$text</b></span>";
    }

    public function check_session()
    {
        $rand = mt_rand(0, 999999);
        $_SESSION['test'] = $rand;
        $txt = $_SESSION['test'];
        if ($txt !== $rand) {
            return $this->check_status(0);
        }

        return $this->check_status(1);
    }

    public function check_file()
    {
        $f = fopen('test_write.txt', 'wb');
        if (!$f) {
            return $this->check_status(0);
        }

        $rand = mt_rand(0, 999999);
        $err_rights = 0;
        if (!@fwrite($f, $rand)) {
            $err_rights = 1;
        } else {
            if (!fclose($f)) {
                $err_rights = 1;
            } else {
                $txt = file_get_contents('test_write.txt');
                if ($txt != $rand) {
                    $err_rights = 1;
                } else {
                    if (!unlink('test_write.txt')) {
                        $err_rights = 1;
                    }
                }
            }
        }
        if ($err_rights) {
            return $this->check_status(0);
        }

        return $this->check_status(1);
    }

    public function check_open_basedir()
    {
        echo 'Basedir: ' . ini_get('open_basedir') . '<br />';
        echo 'Upload dir: ' . ini_get('upload_tmp_dir') . '<br />';
        echo 'Temp dir: ' . sys_get_temp_dir();
        $b_dir = @ini_get('open_basedir');
        if ($b_dir) {  // Установлен basedir, проверяем входят ли временные каталоги в список разрешенных
            // Раскладываем basedir в виде массива каталогов
            if (strpos($b_dir, ';')) { // Windows style
                $b_dirs = explode(';', $b_dir);
            } else {
                if (strpos($b_dir, ':') > 2) { // Linux style
                    $b_dirs = explode(':', $b_dir);
                } else {
                    $b_dirs = array($b_dir);
                }
            }
            $invalid_upload = 1;
            $invalid_temp = 1;
            foreach ($b_dirs as $one_dir) {
                if ($one_dir[strlen($one_dir) - 1] === '/') {
                    $one_dir = substr($one_dir, 0, -1);
                }
                $u_dir = @ini_get('upload_tmp_dir');
                if ($u_dir) {
                    if (substr($u_dir, 0, strlen($one_dir)) === $one_dir) {
                        $invalid_upload = 0;
                    }
                }
                $t_dir = @sys_get_temp_dir();
                if ($t_dir) {
                    if (substr($t_dir, 0, strlen($one_dir)) === $one_dir) {
                        $invalid_temp = 0;
                    }
                }
            }
            if ($invalid_upload || $invalid_temp) {
                return $this->check_status(0);
            }

            return $this->check_status(1);
        }

        return $this->check_status(2);
    }

    public function check_db_connect()
    {
        $link = mysqli_connect($_REQUEST['db_host'], $_REQUEST['db_user'], $_REQUEST['db_pass'], $_REQUEST['db_name']);

        if ($link) {
            mysqli_query($link, 'SET NAMES utf8');
            return $this->check_status(1);
        }

        return $this->check_status(0);
    }

    public function check_db_crud()
    {
        $link = mysqli_connect($_REQUEST['db_host'], $_REQUEST['db_user'], $_REQUEST['db_pass'], $_REQUEST['db_name']);

        if ($link) {
            mysqli_query($link, 'SET NAMES utf8');
        }

        mysqli_query($link, 'CREATE TABLE IF NOT EXISTS dfdsef435f3_tmp_benchmark (
                       id int(11) NOT NULL AUTO_INCREMENT,
                       test_text text NOT NULL,
                       PRIMARY KEY (id)) ENGINE = innodb');
        $rand = mt_rand(0, 999999);
        // INSERT
        mysqli_query($link, "INSERT INTO dfdsef435f3_tmp_benchmark (id, test_text) VALUES ('1', 'fgdf')");
        // UPDATE
        mysqli_query($link,"UPDATE dfdsef435f3_tmp_benchmark SET test_text = '$rand' WHERE id = 1");
        // SELECT
        $result = mysqli_query($link, 'SELECT test_text FROM dfdsef435f3_tmp_benchmark WHERE id = 1');
        $row = mysqli_fetch_assoc($result);
        // Удаляем временные таблицы
        mysqli_query($link, 'DROP TABLE dfdsef435f3_tmp_benchmark');
        if ((int)$row['test_text'] === $rand) {
            return $this->check_status(1);
        }

        return $this->check_status(0);
    }
}

header('Content-Type: text/html; charset=utf-8');
session_start();

$check = new Check;
$check->set_lang(strtolower(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2)));
?>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8">
    <title><?= $check->t('check'); ?></title>
</head>
<body>
<?php
if (isset($_FILES['user_file']['name'], $_REQUEST['db_host'], $_REQUEST['db_user'], $_REQUEST['db_pass'], $_REQUEST['db_name'])) { ?>
    <h2><?= $check->t('check'); ?></h2>
    <h3><?= $check->t('settings'); ?> php</h3>
    <ul>
        <li>
            PHP version <?= $check->check_php_version(); ?>
            <br/> <?= $check->t('recommended'); ?> - 5.5, 5.6, 7.0
            <br/> <?= $check->t('value'); ?> - <?= $check->get_php_version(); ?>
        </li>
        <li>
            error_reporting: <?= $check->check_error_reporting(); ?>
            <br/> <?= $check->t('recommended'); ?> - (E_ALL & ~E_DEPRECATED & ~E_NOTICE & ~E_STRICT)";
        </li>
        <?php
        $check_array = array(
            'max_execution_time',
            'max_input_time',
            'memory_limit',
            'post_max_size',
            'upload_max_filesize'
        );
        foreach ($check_array as $parameter_name) {
            ?>
            <li>
                <?= $parameter_name; ?>: <?= $check->check_ini_get($parameter_name); ?>
                <br/> <?= $check->t('minimum'); ?> - <?= $check->get_parameters_min($parameter_name); ?>
                <br/> <?= $check->t('recommended'); ?> - <?= $check->get_parameters_rec($parameter_name); ?>
                <br/> <?= $check->t('value'); ?> - <?= $check->get_ini_get($parameter_name); ?>
            </li>
        <?php } ?>
    </ul>
    <h3><?= $check->t('modules'); ?> php</h3>
    <ul>
        <li>gd <?= $check->check_loaded_extensions('gd', 'extension'); ?></li>
        <li>
            mbstring <?= $check->check_loaded_extensions('mbstring', 'extension'); ?>
            <br/>mbstring test <?= $check->check_str(); ?>
        </li>
        <li>iconv <?= $check->check_loaded_extensions('iconv', 'extension'); ?></li>
        <li>zip <?= $check->check_loaded_extensions('zip', 'extension'); ?></li>
        <li>openssl <?= $check->check_loaded_extensions('openssl', 'extension'); ?></li>
        <li>imap <?= $check->check_loaded_extensions('imap', 'extension'); ?></li>
        <li>curl <?= $check->check_loaded_extensions('curl', 'extension'); ?></li>
    </ul>
    <h3>Zend Guard / IonCube</h3>
    <ul>
        <li>Zend Guard <?= $check->check_loaded_extensions('Zend Guard Loader', 'loader'); ?></li>
        <li>IonCube <?= $check->check_loaded_extensions('ionCube Loader', 'loader'); ?></li>
    </ul>
    <h3><?= $check->t('settings'); ?> dir</h3>
    <ul>
        <li><?= $check->check_open_basedir(); ?></li>
        <li><?= $check->t('check_text_file'); ?>: <?= $check->check_file(); ?></li>
    </ul>
    <h3><?= $check->t('check_other'); ?></h3>
    <ul>
        <li><?= $check->t('check_session'); ?> <?= $check->check_session(); ?></li>
    </ul>
    <h3><?= $check->t('check_uploaded_file'); ?></h3>
    <ul>
        <li><?= $check->check_upload_file(); ?></li>
    </ul>
    <h3><?= $check->t('check_db'); ?></h3>
    <?php
    if (isset($_REQUEST['db_host'], $_REQUEST['db_user'], $_REQUEST['db_pass'], $_REQUEST['db_name'])) { ?>
        <ul>
            <li>mysql_connect: <?= $check->check_db_connect(); ?></li>
            <li>check CREATE,INSERT,UPDATE,DROP: <?= $check->check_db_crud(); ?></li>
        </ul>
    <?php } ?>
<?php } else { ?>
    <form enctype="multipart/form-data" method="POST" name="uploaded_file">
        <h3><?= $check->t('check_uploaded_file'); ?></h3>
        <?= $check->t('send_file'); ?>: <input name="user_file" type="file"/>

        <h3><?= $check->t('check_db'); ?></h3>
        <label for="db_host">db_host: </label><input id="db_host" name="db_host" type="text" value="localhost"/><br/>
        <label for="db_user">db_user: </label><input id="db_user" name="db_user" type="text" value="root"/><br/>
        <label for="db_pass">db_pass: </label><input id="db_pass" name="db_pass" type="text"/><br/>
        <label for="db_name">db_name: </label><input id="db_name" name="db_name" type="text"/><br/>
        <br/><br/>
        <input type="submit" value="<?= $check->t('check'); ?>" style="padding: 5px;"/>
    </form>
<?php } ?>
</body>
</html>