# Document Automation Library for Java

GroupDocs.Assembly for Java is designed to [Generate Documents based on Templates](https://products.groupdocs.com/assembly/java). It can generate documents in Microsoft Word, Excel, PowerPoint, Outlook, OpenOffice & [50+ other formats](https://docs.groupdocs.com/assembly/java/supported-document-formats/) by merging data from various sources including databases, XML, JSON, OData and more. 

<p align="center">

  <a title="Download complete GroupDocs.Assembly for Java source code" href="https://github.com/groupdocs-assembly/GroupDocs.Assembly-for-Java/archive/master.zip">
	<img src="https://raw.github.com/AsposeExamples/java-examples-dashboard/master/images/downloadZip-Button-Large.png" />
  </a>
</p>

Directory | Description
--------- | -----------
[Examples](https://github.com/groupdocs-assembly/GroupDocs.Assembly-for-Java/tree/master/Examples)  | Contains the package of all Java examples and sample files that will help you learn how to use product features. 

## Document Automation & Reporting Solution

- Support for multiple data formats including OData, XML, spreadsheets & Word tables.
- Use formulae & perform sequential data operations.
- Apply upper, lower, capital, firstcap formatting to strings in template syntax.
- Template syntax support formatting of ordinal, cardinal, alphabetic numeric nature.
- Support for template documents with custom variables & text comments within template syntax tags.
- Dynamically insert document content & configure background color of html documents.
- Dynamically insert hyperlinks in reports & apply attributes to email message body as well as generate barcodes.
- Dynamically attach email attachments.
- Support of next field analogue of Microsoft Word.
- Update fields during word processing document assembly.
- Apply formula during spreadsheet assembly.
- Template formatting for numeric, text, image, date-time, chart elements.
- Conditional formatting of template text elements.
- Support for LINQ-based template syntax.
- Auto-removal of empty paragraphs.
- Generate various report types, e.g., charts, image, tables, lists and more.
- Inline template syntax errors in generated documents instead of exception throwing.
- Load template documents from html with resources and save assembled Word, Excel, PowerPoint & emails to html with resources.

## Get Started with GroupDocs.Assembly for Java

GroupDocs.Assembly for Java requires J2SE 7.0 (1.7), J2SE 8.0 (1.8) or above. Please install Java first if you do not have it already. 

GroupDocs hosts all Java APIs on [GroupDocs Artifact Repository](https://artifact.groupdocs.com/webapp/#/artifacts/browse/tree/General/repo/com/groupdocs/groupdocs-assembly), so simply [configure](https://docs.groupdocs.com/assembly/java/installation/) your Maven project to fetch the dependencies automatically.


[Home](https://www.groupdocs.com/) | [Product Page](https://products.groupdocs.com/assembly/java) | [Documentation](https://docs.groupdocs.com/assembly/java/) | [Demos](https://products.groupdocs.app/assembly/family) | [API Reference](https://apireference.groupdocs.com/java/assembly) | [Examples](https://github.com/groupdocs-assembly/GroupDocs.assembly-for-Java/tree/master/Examples) | [Blog](https://blog.groupdocs.com/category/assembly/) | [Search](https://search.groupdocs.com/) | [Free Support](https://forum.groupdocs.com/c/assembly) | [Temporary License](https://purchase.groupdocs.com/temporary-license)
