var app = app || {};

var spBreak = 767.98;

app.init = function () {
  app.navigationMobile();
  app.tabletViewport();
  app.smoothScroll();
  app.initWow();
  app.googleMap();
};

app.isMobile = function () {
  return window.matchMedia('(max-width: ' + spBreak + 'px)').matches;
};

app.smoothScroll = function () {
  if (window.location.hash) scroll(0, 0);
  setTimeout(function () {
    scroll(0, 0);
  }, 1);
  if (window.location.hash) {
    var replaceHash = window.location.hash.replace('#', '');
    if ($('[data-id="' + replaceHash + '"]').length) {
      setTimeout(function () {
        $('html, body').animate(
          {
            scrollTop: $('[data-id="' + replaceHash + '"]').offset().top,
          },
          500
        );
      }, 800);
    }
  }
  $('.js-smooth').click(function () {
    var that = $(this);
    $('.js-button-menu').click();
    setTimeout(function () {
      var speed = 500,
        href = that.attr('href').split('#')[1],
        target = $(href == '' ? 'html' : '[data-id="' + href + '"]'),
        position = target.offset().top;
      $('body,html').animate(
        {
          scrollTop: position,
        },
        speed,
        'swing'
      );
      return false;
    }, 100);
  });
};

app.tabletViewport = function () {
  var viewport = document.getElementById('viewport');

  var viewportSet = function () {
    if (screen.width >= 768 && screen.width <= 1440) {
      viewport.setAttribute('content', 'width=1440, user-scalable=0');
      $('html').addClass('is-tablet');
    } else {
      viewport.setAttribute('content', 'width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=0');
      $('html').removeClass('is-tablet');
    }
  };

  viewportSet();

  window.onload = function () {
    viewportSet();
  };

  window.onresize = function () {
    viewportSet();
  };
};

app.closeMenu = function () {
  $('body').css({
    position: 'static',
    top: 'auto',
  });
  $(window).scrollTop(offsetY);
};

app.navigationMobile = function () {
  var navigation = $('.js-navigation');
  $('.js-button-menu').click(function () {
    $('header').toggleClass('is-active');
    navigation.addClass('is-show');
    $(this).toggleClass('is-active');
    if ($(this).hasClass('is-active')) {
      offsetY = window.pageYOffset;
      if (!app.isMobile()) {
        $('body').css({
          position: 'static',
        });
      } else {
        $('body').css({
          position: 'fixed',
        });
      }
      $('body').css({
        top: -offsetY + 'px',
        width: '100%',
      });
      $('.js-overlay').addClass('is-show');
      navigation.stop().fadeIn();
    } else {
      navigation.removeClass('is-show');
      navigation.stop().fadeOut();
      $('.js-overlay').removeClass('is-show');
      app.closeMenu();
    }
    return false;
  });
  $('.js-overlay').click(function () {
    $('.js-overlay').removeClass('is-show');
    navigation.stop().fadeOut();
    app.closeMenu();
    $('.js-button-menu').removeClass('is-active');
  });
};

app.initWow = function () {
  if ($('.wow').length) {
    new WOW().init();
  }
  if ($('.js-offset').length) {
    $('.js-offset').each(function () {
      $(this).attr('data-wow-offset', $(this).innerHeight() / 2);
    });
  }
};

app.googleMap = function () {
  if ($('#js-map').length) {
    var mapLatitude = 33.770261,
      mapLongitude = -118.194432,
      mapZoom = 13;

    var markerUrl = '/' + window.location.pathname.split('/')[1] + '/img/common/map_maker.png';

    var style = [
      {
        elementType: 'geometry.stroke',
        stylers: [
          {
            visibility: 'off',
          },
        ],
      },
      {
        featureType: 'landscape.natural',
        stylers: [
          {
            saturation: -100,
          },
        ],
      },
      {
        featureType: 'poi',
        stylers: [
          {
            saturation: -100,
          },
        ],
      },
      {
        featureType: 'road',
        elementType: 'geometry.fill',
        stylers: [
          {
            color: '#c0c0c0',
          },
        ],
      },
      {
        featureType: 'road',
        elementType: 'labels',
        stylers: [
          {
            saturation: -100,
          },
        ],
      },
      {
        featureType: 'road',
        elementType: 'labels.text.fill',
        stylers: [
          {
            color: '#c0c0c0',
          },
          {
            visibility: 'off',
          },
        ],
      },
      {
        featureType: 'road',
        elementType: 'labels.text.stroke',
        stylers: [
          {
            visibility: 'off',
          },
        ],
      },
      {
        featureType: 'transit',
        elementType: 'labels.icon',
        stylers: [
          {
            saturation: -100,
          },
        ],
      },
      {
        featureType: 'transit',
        elementType: 'labels.text',
        stylers: [
          {
            visibility: 'off',
          },
        ],
      },
      {
        featureType: 'water',
        stylers: [
          {
            saturation: -100,
          },
        ],
      },
    ];

    var mapOptions = {
      center: new google.maps.LatLng(mapLatitude, mapLongitude),
      zoom: mapZoom,
      panControl: false,
      zoomControl: false,
      mapTypeControl: false,
      streetViewControl: false,
      mapTypeId: google.maps.MapTypeId.ROADMAP,
      scrollwheel: false,
      styles: style,
    };
    var map = new google.maps.Map(document.getElementById('js-map'), mapOptions);
    if (app.isMobile()) {
      var marker = new google.maps.Marker({
        position: new google.maps.LatLng(mapLatitude, mapLongitude),
        map: map,
        visible: true,
        icon: {
          url: markerUrl,
          scaledSize: new google.maps.Size(26, 36),
          origin: new google.maps.Point(0, 0),
          anchor: new google.maps.Point(15, 30),
          labelOrigin: new google.maps.Point(0, 45),
        },
      });
    } else {
      var marker = new google.maps.Marker({
        position: new google.maps.LatLng(mapLatitude, mapLongitude),
        map: map,
        visible: true,
        icon: {
          url: markerUrl,
          scaledSize: new google.maps.Size(47, 62),
          origin: new google.maps.Point(0, 0),
          anchor: new google.maps.Point(10, 30),
          labelOrigin: new google.maps.Point(0, 45),
        },
      });
    }
  }
};

$(function () {
  app.init();
});
