# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import mock
import webtest

import main


def test_app(testbed):
    app = webtest.TestApp(main.app)

    with mock.patch("main.urlfetch.fetch") as fetch_mock:
        result_mock = mock.Mock()
        result_mock.status_code = 200
        result_mock.content = "{}"
        fetch_mock.return_value = result_mock

        response = app.get("/")
        assert response.status_int == 200
        assert fetch_mock.called
