-- Copyright 2021 Google LLC
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

#standardSQL
CREATE OR REPLACE TABLE `{0}.wide_games` AS
SELECT
  team.game_id AS game_id,
  team.season AS season,
  team.scheduled_date AS scheduled_date,
  team.team_id AS team_id,
  opponent.team_id AS opponent_id,
  team.three_points_made + opponent.three_points_made as total_three_points_made,
  team.three_points_att + opponent.three_points_att as total_three_points_att,
  team.points_avg_last_1 AS	team_points_avg_last_1,
  team.points_avg_last_5 AS	team_points_avg_last_5,
  team.points_avg_last_10 AS	team_points_avg_last_10,
  team.fast_break_pts_avg_last_1 AS	team_fast_break_pts_avg_last_1,
  team.fast_break_pts_avg_last_5 AS	team_fast_break_pts_avg_last_5,
  team.fast_break_pts_avg_last_10 AS	team_fast_break_pts_avg_last_10,
  team.second_chance_pts_avg_last_1 AS	team_second_chance_pts_avg_last_1,
  team.second_chance_pts_avg_last_5 AS	team_second_chance_pts_avg_last_5,
  team.second_chance_pts_avg_last_10 AS	team_second_chance_pts_avg_last_10,
  team.field_goals_made_avg_last_1 AS	team_field_goals_made_avg_last_1,
  team.field_goals_made_avg_last_5 AS	team_field_goals_made_avg_last_5,
  team.field_goals_made_avg_last_10 AS	team_field_goals_made_avg_last_10,
  team.field_goals_att_avg_last_1 AS	team_field_goals_att_avg_last_1,
  team.field_goals_att_avg_last_5 AS	team_field_goals_att_avg_last_5,
  team.field_goals_att_avg_last_10 AS	team_field_goals_att_avg_last_10,
  team.field_goals_pct_avg_last_1 AS	team_field_goals_pct_avg_last_1,
  team.field_goals_pct_avg_last_5 AS	team_field_goals_pct_avg_last_5,
  team.field_goals_pct_avg_last_10 AS	team_field_goals_pct_avg_last_10,
  team.three_points_made_avg_last_1 AS	team_three_points_made_avg_last_1,
  team.three_points_made_avg_last_5 AS	team_three_points_made_avg_last_5,
  team.three_points_made_avg_last_10 AS	team_three_points_made_avg_last_10,
  team.three_points_att_avg_last_1 AS	team_three_points_att_avg_last_1,
  team.three_points_att_avg_last_5 AS	team_three_points_att_avg_last_5,
  team.three_points_att_avg_last_10 AS	team_three_points_att_avg_last_10,
  team.three_points_pct_avg_last_1 AS	team_three_points_pct_avg_last_1,
  team.three_points_pct_avg_last_5 AS	team_three_points_pct_avg_last_5,
  team.three_points_pct_avg_last_10 AS	team_three_points_pct_avg_last_10,
  team.two_points_made_avg_last_1 AS	team_two_points_made_avg_last_1,
  team.two_points_made_avg_last_5 AS	team_two_points_made_avg_last_5,
  team.two_points_made_avg_last_10 AS	team_two_points_made_avg_last_10,
  team.two_points_att_avg_last_1 AS	team_two_points_att_avg_last_1,
  team.two_points_att_avg_last_5 AS	team_two_points_att_avg_last_5,
  team.two_points_att_avg_last_10 AS	team_two_points_att_avg_last_10,
  team.two_points_pct_avg_last_1 AS	team_two_points_pct_avg_last_1,
  team.two_points_pct_avg_last_5 AS	team_two_points_pct_avg_last_5,
  team.two_points_pct_avg_last_10 AS	team_two_points_pct_avg_last_10,
  team.free_throws_made_avg_last_1 AS	team_free_throws_made_avg_last_1,
  team.free_throws_made_avg_last_5 AS	team_free_throws_made_avg_last_5,
  team.free_throws_made_avg_last_10 AS	team_free_throws_made_avg_last_10,
  team.free_throws_att_avg_last_1 AS	team_free_throws_att_avg_last_1,
  team.free_throws_att_avg_last_5 AS	team_free_throws_att_avg_last_5,
  team.free_throws_att_avg_last_10 AS	team_free_throws_att_avg_last_10,
  team.free_throws_pct_avg_last_1 AS	team_free_throws_pct_avg_last_1,
  team.free_throws_pct_avg_last_5 AS	team_free_throws_pct_avg_last_5,
  team.free_throws_pct_avg_last_10 AS	team_free_throws_pct_avg_last_10,
  team.ts_pct_avg_last_1 AS	team_ts_pct_avg_last_1,
  team.ts_pct_avg_last_5 AS	team_ts_pct_avg_last_5,
  team.ts_pct_avg_last_10 AS	team_ts_pct_avg_last_10,
  team.efg_pct_avg_last_1 AS	team_efg_pct_avg_last_1,
  team.efg_pct_avg_last_5 AS	team_efg_pct_avg_last_5,
  team.efg_pct_avg_last_10 AS	team_efg_pct_avg_last_10,
  team.rebounds_avg_last_1 AS	team_rebounds_avg_last_1,
  team.rebounds_avg_last_5 AS	team_rebounds_avg_last_5,
  team.rebounds_avg_last_10 AS	team_rebounds_avg_last_10,
  team.offensive_rebounds_avg_last_1 AS	team_offensive_rebounds_avg_last_1,
  team.offensive_rebounds_avg_last_5 AS	team_offensive_rebounds_avg_last_5,
  team.offensive_rebounds_avg_last_10 AS	team_offensive_rebounds_avg_last_10,
  team.defensive_rebounds_avg_last_1 AS	team_defensive_rebounds_avg_last_1,
  team.defensive_rebounds_avg_last_5 AS	team_defensive_rebounds_avg_last_5,
  team.defensive_rebounds_avg_last_10 AS	team_defensive_rebounds_avg_last_10,
  team.dreb_pct_avg_last_1 AS	team_dreb_pct_avg_last_1,
  team.dreb_pct_avg_last_5 AS	team_dreb_pct_avg_last_5,
  team.dreb_pct_avg_last_10 AS	team_dreb_pct_avg_last_10,
  team.oreb_pct_avg_last_1 AS	team_oreb_pct_avg_last_1,
  team.oreb_pct_avg_last_5 AS	team_oreb_pct_avg_last_5,
  team.oreb_pct_avg_last_10 AS	team_oreb_pct_avg_last_10,
  team.steals_avg_last_1 AS	team_steals_avg_last_1,
  team.steals_avg_last_5 AS	team_steals_avg_last_5,
  team.steals_avg_last_10 AS	team_steals_avg_last_10,
  team.blocks_avg_last_1 AS	team_blocks_avg_last_1,
  team.blocks_avg_last_5 AS	team_blocks_avg_last_5,
  team.blocks_avg_last_10 AS	team_blocks_avg_last_10,
  team.assists_avg_last_1 AS	team_assists_avg_last_1,
  team.assists_avg_last_5 AS	team_assists_avg_last_5,
  team.assists_avg_last_10 AS	team_assists_avg_last_10,
  team.turnovers_avg_last_1 AS	team_turnovers_avg_last_1,
  team.turnovers_avg_last_5 AS	team_turnovers_avg_last_5,
  team.turnovers_avg_last_10 AS	team_turnovers_avg_last_10,
  team.team_turnovers_avg_last_1 AS	team_team_turnovers_avg_last_1,
  team.team_turnovers_avg_last_5 AS	team_team_turnovers_avg_last_5,
  team.team_turnovers_avg_last_10 AS	team_team_turnovers_avg_last_10,
  team.points_off_turnovers_avg_last_1 AS	team_points_off_turnovers_avg_last_1,
  team.points_off_turnovers_avg_last_5 AS	team_points_off_turnovers_avg_last_5,
  team.points_off_turnovers_avg_last_10 AS	team_points_off_turnovers_avg_last_10,
  team.assists_turnover_ratio_avg_last_1 AS	team_assists_turnover_ratio_avg_last_1,
  team.assists_turnover_ratio_avg_last_5 AS	team_assists_turnover_ratio_avg_last_5,
  team.assists_turnover_ratio_avg_last_10 AS	team_assists_turnover_ratio_avg_last_10,
  team.ast_fgm_pct_avg_last_1 AS	team_ast_fgm_pct_avg_last_1,
  team.ast_fgm_pct_avg_last_5 AS	team_ast_fgm_pct_avg_last_5,
  team.ast_fgm_pct_avg_last_10 AS	team_ast_fgm_pct_avg_last_10,
  team.personal_fouls_avg_last_1 AS	team_personal_fouls_avg_last_1,
  team.personal_fouls_avg_last_5 AS	team_personal_fouls_avg_last_5,
  team.personal_fouls_avg_last_10 AS	team_personal_fouls_avg_last_10,
  team.flagrant_fouls_avg_last_1 AS	team_flagrant_fouls_avg_last_1,
  team.flagrant_fouls_avg_last_5 AS	team_flagrant_fouls_avg_last_5,
  team.flagrant_fouls_avg_last_10 AS	team_flagrant_fouls_avg_last_10,
  team.player_tech_fouls_avg_last_1 AS	team_player_tech_fouls_avg_last_1,
  team.player_tech_fouls_avg_last_5 AS	team_player_tech_fouls_avg_last_5,
  team.player_tech_fouls_avg_last_10 AS	team_player_tech_fouls_avg_last_10,
  team.team_tech_fouls_avg_last_1 AS	team_team_tech_fouls_avg_last_1,
  team.team_tech_fouls_avg_last_5 AS	team_team_tech_fouls_avg_last_5,
  team.team_tech_fouls_avg_last_10 AS	team_team_tech_fouls_avg_last_10,
  team.coach_tech_fouls_avg_last_1 AS	team_coach_tech_fouls_avg_last_1,
  team.coach_tech_fouls_avg_last_5 AS	team_coach_tech_fouls_avg_last_5,
  team.coach_tech_fouls_avg_last_10 AS	team_coach_tech_fouls_avg_last_10,
  team.foulouts_avg_last_1 AS	team_foulouts_avg_last_1,
  team.foulouts_avg_last_5 AS	team_foulouts_avg_last_5,
  team.foulouts_avg_last_10 AS	team_foulouts_avg_last_10,
  team.score_delta_avg_last_1 AS	team_score_delta_avg_last_1,
  team.score_delta_avg_last_5 AS	team_score_delta_avg_last_5,
  team.score_delta_avg_last_10 AS	team_score_delta_avg_last_10,
  team.possessions_avg_last_1 AS	team_possessions_avg_last_1,
  team.possessions_avg_last_5 AS	team_possessions_avg_last_5,
  team.possessions_avg_last_10 AS	team_possessions_avg_last_10,
  team.opp_points_avg_last_1 AS	team_opp_points_avg_last_1,
  team.opp_points_avg_last_5 AS	team_opp_points_avg_last_5,
  team.opp_points_avg_last_10 AS	team_opp_points_avg_last_10,
  team.opp_fast_break_pts_avg_last_1 AS	team_opp_fast_break_pts_avg_last_1,
  team.opp_fast_break_pts_avg_last_5 AS	team_opp_fast_break_pts_avg_last_5,
  team.opp_fast_break_pts_avg_last_10 AS	team_opp_fast_break_pts_avg_last_10,
  team.opp_second_chance_pts_avg_last_1 AS	team_opp_second_chance_pts_avg_last_1,
  team.opp_second_chance_pts_avg_last_5 AS	team_opp_second_chance_pts_avg_last_5,
  team.opp_second_chance_pts_avg_last_10 AS	team_opp_second_chance_pts_avg_last_10,
  team.opp_field_goals_made_avg_last_1 AS	team_opp_field_goals_made_avg_last_1,
  team.opp_field_goals_made_avg_last_5 AS	team_opp_field_goals_made_avg_last_5,
  team.opp_field_goals_made_avg_last_10 AS	team_opp_field_goals_made_avg_last_10,
  team.opp_field_goals_att_avg_last_1 AS	team_opp_field_goals_att_avg_last_1,
  team.opp_field_goals_att_avg_last_5 AS	team_opp_field_goals_att_avg_last_5,
  team.opp_field_goals_att_avg_last_10 AS	team_opp_field_goals_att_avg_last_10,
  team.opp_field_goals_pct_avg_last_1 AS	team_opp_field_goals_pct_avg_last_1,
  team.opp_field_goals_pct_avg_last_5 AS	team_opp_field_goals_pct_avg_last_5,
  team.opp_field_goals_pct_avg_last_10 AS	team_opp_field_goals_pct_avg_last_10,
  team.opp_three_points_made_avg_last_1 AS	team_opp_three_points_made_avg_last_1,
  team.opp_three_points_made_avg_last_5 AS	team_opp_three_points_made_avg_last_5,
  team.opp_three_points_made_avg_last_10 AS	team_opp_three_points_made_avg_last_10,
  team.opp_three_points_att_avg_last_1 AS	team_opp_three_points_att_avg_last_1,
  team.opp_three_points_att_avg_last_5 AS	team_opp_three_points_att_avg_last_5,
  team.opp_three_points_att_avg_last_10 AS	team_opp_three_points_att_avg_last_10,
  team.opp_three_points_pct_avg_last_1 AS	team_opp_three_points_pct_avg_last_1,
  team.opp_three_points_pct_avg_last_5 AS	team_opp_three_points_pct_avg_last_5,
  team.opp_three_points_pct_avg_last_10 AS	team_opp_three_points_pct_avg_last_10,
  team.opp_two_points_made_avg_last_1 AS	team_opp_two_points_made_avg_last_1,
  team.opp_two_points_made_avg_last_5 AS	team_opp_two_points_made_avg_last_5,
  team.opp_two_points_made_avg_last_10 AS	team_opp_two_points_made_avg_last_10,
  team.opp_two_points_att_avg_last_1 AS	team_opp_two_points_att_avg_last_1,
  team.opp_two_points_att_avg_last_5 AS	team_opp_two_points_att_avg_last_5,
  team.opp_two_points_att_avg_last_10 AS	team_opp_two_points_att_avg_last_10,
  team.opp_two_points_pct_avg_last_1 AS	team_opp_two_points_pct_avg_last_1,
  team.opp_two_points_pct_avg_last_5 AS	team_opp_two_points_pct_avg_last_5,
  team.opp_two_points_pct_avg_last_10 AS	team_opp_two_points_pct_avg_last_10,
  team.opp_free_throws_made_avg_last_1 AS	team_opp_free_throws_made_avg_last_1,
  team.opp_free_throws_made_avg_last_5 AS	team_opp_free_throws_made_avg_last_5,
  team.opp_free_throws_made_avg_last_10 AS	team_opp_free_throws_made_avg_last_10,
  team.opp_free_throws_att_avg_last_1 AS	team_opp_free_throws_att_avg_last_1,
  team.opp_free_throws_att_avg_last_5 AS	team_opp_free_throws_att_avg_last_5,
  team.opp_free_throws_att_avg_last_10 AS	team_opp_free_throws_att_avg_last_10,
  team.opp_free_throws_pct_avg_last_1 AS	team_opp_free_throws_pct_avg_last_1,
  team.opp_free_throws_pct_avg_last_5 AS	team_opp_free_throws_pct_avg_last_5,
  team.opp_free_throws_pct_avg_last_10 AS	team_opp_free_throws_pct_avg_last_10,
  team.opp_ts_pct_avg_last_1 AS	team_opp_ts_pct_avg_last_1,
  team.opp_ts_pct_avg_last_5 AS	team_opp_ts_pct_avg_last_5,
  team.opp_ts_pct_avg_last_10 AS	team_opp_ts_pct_avg_last_10,
  team.opp_efg_pct_avg_last_1 AS	team_opp_efg_pct_avg_last_1,
  team.opp_efg_pct_avg_last_5 AS	team_opp_efg_pct_avg_last_5,
  team.opp_efg_pct_avg_last_10 AS	team_opp_efg_pct_avg_last_10,
  team.opp_rebounds_avg_last_1 AS	team_opp_rebounds_avg_last_1,
  team.opp_rebounds_avg_last_5 AS	team_opp_rebounds_avg_last_5,
  team.opp_rebounds_avg_last_10 AS	team_opp_rebounds_avg_last_10,
  team.opp_offensive_rebounds_avg_last_1 AS	team_opp_offensive_rebounds_avg_last_1,
  team.opp_offensive_rebounds_avg_last_5 AS	team_opp_offensive_rebounds_avg_last_5,
  team.opp_offensive_rebounds_avg_last_10 AS	team_opp_offensive_rebounds_avg_last_10,
  team.opp_defensive_rebounds_avg_last_1 AS	team_opp_defensive_rebounds_avg_last_1,
  team.opp_defensive_rebounds_avg_last_5 AS	team_opp_defensive_rebounds_avg_last_5,
  team.opp_defensive_rebounds_avg_last_10 AS	team_opp_defensive_rebounds_avg_last_10,
  team.opp_dreb_pct_avg_last_1 AS	team_opp_dreb_pct_avg_last_1,
  team.opp_dreb_pct_avg_last_5 AS	team_opp_dreb_pct_avg_last_5,
  team.opp_dreb_pct_avg_last_10 AS	team_opp_dreb_pct_avg_last_10,
  team.opp_oreb_pct_avg_last_1 AS	team_opp_oreb_pct_avg_last_1,
  team.opp_oreb_pct_avg_last_5 AS	team_opp_oreb_pct_avg_last_5,
  team.opp_oreb_pct_avg_last_10 AS	team_opp_oreb_pct_avg_last_10,
  team.opp_steals_avg_last_1 AS	team_opp_steals_avg_last_1,
  team.opp_steals_avg_last_5 AS	team_opp_steals_avg_last_5,
  team.opp_steals_avg_last_10 AS	team_opp_steals_avg_last_10,
  team.opp_blocks_avg_last_1 AS	team_opp_blocks_avg_last_1,
  team.opp_blocks_avg_last_5 AS	team_opp_blocks_avg_last_5,
  team.opp_blocks_avg_last_10 AS	team_opp_blocks_avg_last_10,
  team.opp_assists_avg_last_1 AS	team_opp_assists_avg_last_1,
  team.opp_assists_avg_last_5 AS	team_opp_assists_avg_last_5,
  team.opp_assists_avg_last_10 AS	team_opp_assists_avg_last_10,
  team.opp_turnovers_avg_last_1 AS	team_opp_turnovers_avg_last_1,
  team.opp_turnovers_avg_last_5 AS	team_opp_turnovers_avg_last_5,
  team.opp_turnovers_avg_last_10 AS	team_opp_turnovers_avg_last_10,
  team.opp_team_turnovers_avg_last_1 AS	team_opp_team_turnovers_avg_last_1,
  team.opp_team_turnovers_avg_last_5 AS	team_opp_team_turnovers_avg_last_5,
  team.opp_team_turnovers_avg_last_10 AS	team_opp_team_turnovers_avg_last_10,
  team.opp_points_off_turnovers_avg_last_1 AS	team_opp_points_off_turnovers_avg_last_1,
  team.opp_points_off_turnovers_avg_last_5 AS	team_opp_points_off_turnovers_avg_last_5,
  team.opp_points_off_turnovers_avg_last_10 AS	team_opp_points_off_turnovers_avg_last_10,
  team.opp_assists_turnover_ratio_avg_last_1 AS	team_opp_assists_turnover_ratio_avg_last_1,
  team.opp_assists_turnover_ratio_avg_last_5 AS	team_opp_assists_turnover_ratio_avg_last_5,
  team.opp_assists_turnover_ratio_avg_last_10 AS	team_opp_assists_turnover_ratio_avg_last_10,
  team.opp_ast_fgm_pct_avg_last_1 AS	team_opp_ast_fgm_pct_avg_last_1,
  team.opp_ast_fgm_pct_avg_last_5 AS	team_opp_ast_fgm_pct_avg_last_5,
  team.opp_ast_fgm_pct_avg_last_10 AS	team_opp_ast_fgm_pct_avg_last_10,
  team.opp_personal_fouls_avg_last_1 AS	team_opp_personal_fouls_avg_last_1,
  team.opp_personal_fouls_avg_last_5 AS	team_opp_personal_fouls_avg_last_5,
  team.opp_personal_fouls_avg_last_10 AS	team_opp_personal_fouls_avg_last_10,
  team.opp_flagrant_fouls_avg_last_1 AS	team_opp_flagrant_fouls_avg_last_1,
  team.opp_flagrant_fouls_avg_last_5 AS	team_opp_flagrant_fouls_avg_last_5,
  team.opp_flagrant_fouls_avg_last_10 AS	team_opp_flagrant_fouls_avg_last_10,
  team.opp_player_tech_fouls_avg_last_1 AS	team_opp_player_tech_fouls_avg_last_1,
  team.opp_player_tech_fouls_avg_last_5 AS	team_opp_player_tech_fouls_avg_last_5,
  team.opp_player_tech_fouls_avg_last_10 AS	team_opp_player_tech_fouls_avg_last_10,
  team.opp_team_tech_fouls_avg_last_1 AS	team_opp_team_tech_fouls_avg_last_1,
  team.opp_team_tech_fouls_avg_last_5 AS	team_opp_team_tech_fouls_avg_last_5,
  team.opp_team_tech_fouls_avg_last_10 AS	team_opp_team_tech_fouls_avg_last_10,
  team.opp_coach_tech_fouls_avg_last_1 AS	team_opp_coach_tech_fouls_avg_last_1,
  team.opp_coach_tech_fouls_avg_last_5 AS	team_opp_coach_tech_fouls_avg_last_5,
  team.opp_coach_tech_fouls_avg_last_10 AS	team_opp_coach_tech_fouls_avg_last_10,
  team.opp_foulouts_avg_last_1 AS	team_opp_foulouts_avg_last_1,
  team.opp_foulouts_avg_last_5 AS	team_opp_foulouts_avg_last_5,
  team.opp_foulouts_avg_last_10 AS	team_opp_foulouts_avg_last_10,
  team.opp_score_delta_avg_last_1 AS	team_opp_score_delta_avg_last_1,
  team.opp_score_delta_avg_last_5 AS	team_opp_score_delta_avg_last_5,
  team.opp_score_delta_avg_last_10 AS	team_opp_score_delta_avg_last_10,
  team.opp_possessions_avg_last_1 AS	team_opp_possessions_avg_last_1,
  team.opp_possessions_avg_last_5 AS	team_opp_possessions_avg_last_5,
  team.opp_possessions_avg_last_10 AS	team_opp_possessions_avg_last_10,
  team.points_std_last_5 AS	team_points_std_last_5,
  team.points_std_last_10 AS	team_points_std_last_10,
  team.fast_break_pts_std_last_5 AS	team_fast_break_pts_std_last_5,
  team.fast_break_pts_std_last_10 AS	team_fast_break_pts_std_last_10,
  team.second_chance_pts_std_last_5 AS	team_second_chance_pts_std_last_5,
  team.second_chance_pts_std_last_10 AS	team_second_chance_pts_std_last_10,
  team.field_goals_made_std_last_5 AS	team_field_goals_made_std_last_5,
  team.field_goals_made_std_last_10 AS	team_field_goals_made_std_last_10,
  team.field_goals_att_std_last_5 AS	team_field_goals_att_std_last_5,
  team.field_goals_att_std_last_10 AS	team_field_goals_att_std_last_10,
  team.field_goals_pct_std_last_5 AS	team_field_goals_pct_std_last_5,
  team.field_goals_pct_std_last_10 AS	team_field_goals_pct_std_last_10,
  team.three_points_made_std_last_5 AS	team_three_points_made_std_last_5,
  team.three_points_made_std_last_10 AS	team_three_points_made_std_last_10,
  team.three_points_att_std_last_5 AS	team_three_points_att_std_last_5,
  team.three_points_att_std_last_10 AS	team_three_points_att_std_last_10,
  team.three_points_pct_std_last_5 AS	team_three_points_pct_std_last_5,
  team.three_points_pct_std_last_10 AS	team_three_points_pct_std_last_10,
  team.two_points_made_std_last_5 AS	team_two_points_made_std_last_5,
  team.two_points_made_std_last_10 AS	team_two_points_made_std_last_10,
  team.two_points_att_std_last_5 AS	team_two_points_att_std_last_5,
  team.two_points_att_std_last_10 AS	team_two_points_att_std_last_10,
  team.two_points_pct_std_last_5 AS	team_two_points_pct_std_last_5,
  team.two_points_pct_std_last_10 AS	team_two_points_pct_std_last_10,
  team.free_throws_made_std_last_5 AS	team_free_throws_made_std_last_5,
  team.free_throws_made_std_last_10 AS	team_free_throws_made_std_last_10,
  team.free_throws_att_std_last_5 AS	team_free_throws_att_std_last_5,
  team.free_throws_att_std_last_10 AS	team_free_throws_att_std_last_10,
  team.free_throws_pct_std_last_5 AS	team_free_throws_pct_std_last_5,
  team.free_throws_pct_std_last_10 AS	team_free_throws_pct_std_last_10,
  team.ts_pct_std_last_5 AS	team_ts_pct_std_last_5,
  team.ts_pct_std_last_10 AS	team_ts_pct_std_last_10,
  team.efg_pct_std_last_5 AS	team_efg_pct_std_last_5,
  team.efg_pct_std_last_10 AS	team_efg_pct_std_last_10,
  team.rebounds_std_last_5 AS	team_rebounds_std_last_5,
  team.rebounds_std_last_10 AS	team_rebounds_std_last_10,
  team.offensive_rebounds_std_last_5 AS	team_offensive_rebounds_std_last_5,
  team.offensive_rebounds_std_last_10 AS	team_offensive_rebounds_std_last_10,
  team.defensive_rebounds_std_last_5 AS	team_defensive_rebounds_std_last_5,
  team.defensive_rebounds_std_last_10 AS	team_defensive_rebounds_std_last_10,
  team.dreb_pct_std_last_5 AS	team_dreb_pct_std_last_5,
  team.dreb_pct_std_last_10 AS	team_dreb_pct_std_last_10,
  team.oreb_pct_std_last_5 AS	team_oreb_pct_std_last_5,
  team.oreb_pct_std_last_10 AS	team_oreb_pct_std_last_10,
  team.steals_std_last_5 AS	team_steals_std_last_5,
  team.steals_std_last_10 AS	team_steals_std_last_10,
  team.blocks_std_last_5 AS	team_blocks_std_last_5,
  team.blocks_std_last_10 AS	team_blocks_std_last_10,
  team.assists_std_last_5 AS	team_assists_std_last_5,
  team.assists_std_last_10 AS	team_assists_std_last_10,
  team.turnovers_std_last_5 AS	team_turnovers_std_last_5,
  team.turnovers_std_last_10 AS	team_turnovers_std_last_10,
  team.team_turnovers_std_last_5 AS	team_team_turnovers_std_last_5,
  team.team_turnovers_std_last_10 AS	team_team_turnovers_std_last_10,
  team.points_off_turnovers_std_last_5 AS	team_points_off_turnovers_std_last_5,
  team.points_off_turnovers_std_last_10 AS	team_points_off_turnovers_std_last_10,
  team.assists_turnover_ratio_std_last_5 AS	team_assists_turnover_ratio_std_last_5,
  team.assists_turnover_ratio_std_last_10 AS	team_assists_turnover_ratio_std_last_10,
  team.ast_fgm_pct_std_last_5 AS	team_ast_fgm_pct_std_last_5,
  team.ast_fgm_pct_std_last_10 AS	team_ast_fgm_pct_std_last_10,
  team.personal_fouls_std_last_5 AS	team_personal_fouls_std_last_5,
  team.personal_fouls_std_last_10 AS	team_personal_fouls_std_last_10,
  team.flagrant_fouls_std_last_5 AS	team_flagrant_fouls_std_last_5,
  team.flagrant_fouls_std_last_10 AS	team_flagrant_fouls_std_last_10,
  team.player_tech_fouls_std_last_5 AS	team_player_tech_fouls_std_last_5,
  team.player_tech_fouls_std_last_10 AS	team_player_tech_fouls_std_last_10,
  team.team_tech_fouls_std_last_5 AS	team_team_tech_fouls_std_last_5,
  team.team_tech_fouls_std_last_10 AS	team_team_tech_fouls_std_last_10,
  team.coach_tech_fouls_std_last_5 AS	team_coach_tech_fouls_std_last_5,
  team.coach_tech_fouls_std_last_10 AS	team_coach_tech_fouls_std_last_10,
  team.foulouts_std_last_5 AS	team_foulouts_std_last_5,
  team.foulouts_std_last_10 AS	team_foulouts_std_last_10,
  team.score_delta_std_last_5 AS	team_score_delta_std_last_5,
  team.score_delta_std_last_10 AS	team_score_delta_std_last_10,
  team.possessions_std_last_5 AS	team_possessions_std_last_5,
  team.possessions_std_last_10 AS	team_possessions_std_last_10,
  team.opp_points_std_last_5 AS	team_opp_points_std_last_5,
  team.opp_points_std_last_10 AS	team_opp_points_std_last_10,
  team.opp_fast_break_pts_std_last_5 AS	team_opp_fast_break_pts_std_last_5,
  team.opp_fast_break_pts_std_last_10 AS	team_opp_fast_break_pts_std_last_10,
  team.opp_second_chance_pts_std_last_5 AS	team_opp_second_chance_pts_std_last_5,
  team.opp_second_chance_pts_std_last_10 AS	team_opp_second_chance_pts_std_last_10,
  team.opp_field_goals_made_std_last_5 AS	team_opp_field_goals_made_std_last_5,
  team.opp_field_goals_made_std_last_10 AS	team_opp_field_goals_made_std_last_10,
  team.opp_field_goals_att_std_last_5 AS	team_opp_field_goals_att_std_last_5,
  team.opp_field_goals_att_std_last_10 AS	team_opp_field_goals_att_std_last_10,
  team.opp_field_goals_pct_std_last_5 AS	team_opp_field_goals_pct_std_last_5,
  team.opp_field_goals_pct_std_last_10 AS	team_opp_field_goals_pct_std_last_10,
  team.opp_three_points_made_std_last_5 AS	team_opp_three_points_made_std_last_5,
  team.opp_three_points_made_std_last_10 AS	team_opp_three_points_made_std_last_10,
  team.opp_three_points_att_std_last_5 AS	team_opp_three_points_att_std_last_5,
  team.opp_three_points_att_std_last_10 AS	team_opp_three_points_att_std_last_10,
  team.opp_three_points_pct_std_last_5 AS	team_opp_three_points_pct_std_last_5,
  team.opp_three_points_pct_std_last_10 AS	team_opp_three_points_pct_std_last_10,
  team.opp_two_points_made_std_last_5 AS	team_opp_two_points_made_std_last_5,
  team.opp_two_points_made_std_last_10 AS	team_opp_two_points_made_std_last_10,
  team.opp_two_points_att_std_last_5 AS	team_opp_two_points_att_std_last_5,
  team.opp_two_points_att_std_last_10 AS	team_opp_two_points_att_std_last_10,
  team.opp_two_points_pct_std_last_5 AS	team_opp_two_points_pct_std_last_5,
  team.opp_two_points_pct_std_last_10 AS	team_opp_two_points_pct_std_last_10,
  team.opp_free_throws_made_std_last_5 AS	team_opp_free_throws_made_std_last_5,
  team.opp_free_throws_made_std_last_10 AS	team_opp_free_throws_made_std_last_10,
  team.opp_free_throws_att_std_last_5 AS	team_opp_free_throws_att_std_last_5,
  team.opp_free_throws_att_std_last_10 AS	team_opp_free_throws_att_std_last_10,
  team.opp_free_throws_pct_std_last_5 AS	team_opp_free_throws_pct_std_last_5,
  team.opp_free_throws_pct_std_last_10 AS	team_opp_free_throws_pct_std_last_10,
  team.opp_ts_pct_std_last_5 AS	team_opp_ts_pct_std_last_5,
  team.opp_ts_pct_std_last_10 AS	team_opp_ts_pct_std_last_10,
  team.opp_efg_pct_std_last_5 AS	team_opp_efg_pct_std_last_5,
  team.opp_efg_pct_std_last_10 AS	team_opp_efg_pct_std_last_10,
  team.opp_rebounds_std_last_5 AS	team_opp_rebounds_std_last_5,
  team.opp_rebounds_std_last_10 AS	team_opp_rebounds_std_last_10,
  team.opp_offensive_rebounds_std_last_5 AS	team_opp_offensive_rebounds_std_last_5,
  team.opp_offensive_rebounds_std_last_10 AS	team_opp_offensive_rebounds_std_last_10,
  team.opp_defensive_rebounds_std_last_5 AS	team_opp_defensive_rebounds_std_last_5,
  team.opp_defensive_rebounds_std_last_10 AS	team_opp_defensive_rebounds_std_last_10,
  team.opp_dreb_pct_std_last_5 AS	team_opp_dreb_pct_std_last_5,
  team.opp_dreb_pct_std_last_10 AS	team_opp_dreb_pct_std_last_10,
  team.opp_oreb_pct_std_last_5 AS	team_opp_oreb_pct_std_last_5,
  team.opp_oreb_pct_std_last_10 AS	team_opp_oreb_pct_std_last_10,
  team.opp_steals_std_last_5 AS	team_opp_steals_std_last_5,
  team.opp_steals_std_last_10 AS	team_opp_steals_std_last_10,
  team.opp_blocks_std_last_5 AS	team_opp_blocks_std_last_5,
  team.opp_blocks_std_last_10 AS	team_opp_blocks_std_last_10,
  team.opp_assists_std_last_5 AS	team_opp_assists_std_last_5,
  team.opp_assists_std_last_10 AS	team_opp_assists_std_last_10,
  team.opp_turnovers_std_last_5 AS	team_opp_turnovers_std_last_5,
  team.opp_turnovers_std_last_10 AS	team_opp_turnovers_std_last_10,
  team.opp_team_turnovers_std_last_5 AS	team_opp_team_turnovers_std_last_5,
  team.opp_team_turnovers_std_last_10 AS	team_opp_team_turnovers_std_last_10,
  team.opp_points_off_turnovers_std_last_5 AS	team_opp_points_off_turnovers_std_last_5,
  team.opp_points_off_turnovers_std_last_10 AS	team_opp_points_off_turnovers_std_last_10,
  team.opp_assists_turnover_ratio_std_last_5 AS	team_opp_assists_turnover_ratio_std_last_5,
  team.opp_assists_turnover_ratio_std_last_10 AS	team_opp_assists_turnover_ratio_std_last_10,
  team.opp_ast_fgm_pct_std_last_5 AS	team_opp_ast_fgm_pct_std_last_5,
  team.opp_ast_fgm_pct_std_last_10 AS	team_opp_ast_fgm_pct_std_last_10,
  team.opp_personal_fouls_std_last_5 AS	team_opp_personal_fouls_std_last_5,
  team.opp_personal_fouls_std_last_10 AS	team_opp_personal_fouls_std_last_10,
  team.opp_flagrant_fouls_std_last_5 AS	team_opp_flagrant_fouls_std_last_5,
  team.opp_flagrant_fouls_std_last_10 AS	team_opp_flagrant_fouls_std_last_10,
  team.opp_player_tech_fouls_std_last_5 AS	team_opp_player_tech_fouls_std_last_5,
  team.opp_player_tech_fouls_std_last_10 AS	team_opp_player_tech_fouls_std_last_10,
  team.opp_team_tech_fouls_std_last_5 AS	team_opp_team_tech_fouls_std_last_5,
  team.opp_team_tech_fouls_std_last_10 AS	team_opp_team_tech_fouls_std_last_10,
  team.opp_coach_tech_fouls_std_last_5 AS	team_opp_coach_tech_fouls_std_last_5,
  team.opp_coach_tech_fouls_std_last_10 AS	team_opp_coach_tech_fouls_std_last_10,
  team.opp_foulouts_std_last_5 AS	team_opp_foulouts_std_last_5,
  team.opp_foulouts_std_last_10 AS	team_opp_foulouts_std_last_10,
  team.opp_score_delta_std_last_5 AS	team_opp_score_delta_std_last_5,
  team.opp_score_delta_std_last_10 AS	team_opp_score_delta_std_last_10,
  team.opp_possessions_std_last_5 AS	team_opp_possessions_std_last_5,
  team.opp_possessions_std_last_10 AS	team_opp_possessions_std_last_10,
  opponent.points_avg_last_1 AS	opponent_points_avg_last_1,
  opponent.points_avg_last_5 AS	opponent_points_avg_last_5,
  opponent.points_avg_last_10 AS	opponent_points_avg_last_10,
  opponent.fast_break_pts_avg_last_1 AS	opponent_fast_break_pts_avg_last_1,
  opponent.fast_break_pts_avg_last_5 AS	opponent_fast_break_pts_avg_last_5,
  opponent.fast_break_pts_avg_last_10 AS	opponent_fast_break_pts_avg_last_10,
  opponent.second_chance_pts_avg_last_1 AS	opponent_second_chance_pts_avg_last_1,
  opponent.second_chance_pts_avg_last_5 AS	opponent_second_chance_pts_avg_last_5,
  opponent.second_chance_pts_avg_last_10 AS	opponent_second_chance_pts_avg_last_10,
  opponent.field_goals_made_avg_last_1 AS	opponent_field_goals_made_avg_last_1,
  opponent.field_goals_made_avg_last_5 AS	opponent_field_goals_made_avg_last_5,
  opponent.field_goals_made_avg_last_10 AS	opponent_field_goals_made_avg_last_10,
  opponent.field_goals_att_avg_last_1 AS	opponent_field_goals_att_avg_last_1,
  opponent.field_goals_att_avg_last_5 AS	opponent_field_goals_att_avg_last_5,
  opponent.field_goals_att_avg_last_10 AS	opponent_field_goals_att_avg_last_10,
  opponent.field_goals_pct_avg_last_1 AS	opponent_field_goals_pct_avg_last_1,
  opponent.field_goals_pct_avg_last_5 AS	opponent_field_goals_pct_avg_last_5,
  opponent.field_goals_pct_avg_last_10 AS	opponent_field_goals_pct_avg_last_10,
  opponent.three_points_made_avg_last_1 AS	opponent_three_points_made_avg_last_1,
  opponent.three_points_made_avg_last_5 AS	opponent_three_points_made_avg_last_5,
  opponent.three_points_made_avg_last_10 AS	opponent_three_points_made_avg_last_10,
  opponent.three_points_att_avg_last_1 AS	opponent_three_points_att_avg_last_1,
  opponent.three_points_att_avg_last_5 AS	opponent_three_points_att_avg_last_5,
  opponent.three_points_att_avg_last_10 AS	opponent_three_points_att_avg_last_10,
  opponent.three_points_pct_avg_last_1 AS	opponent_three_points_pct_avg_last_1,
  opponent.three_points_pct_avg_last_5 AS	opponent_three_points_pct_avg_last_5,
  opponent.three_points_pct_avg_last_10 AS	opponent_three_points_pct_avg_last_10,
  opponent.two_points_made_avg_last_1 AS	opponent_two_points_made_avg_last_1,
  opponent.two_points_made_avg_last_5 AS	opponent_two_points_made_avg_last_5,
  opponent.two_points_made_avg_last_10 AS	opponent_two_points_made_avg_last_10,
  opponent.two_points_att_avg_last_1 AS	opponent_two_points_att_avg_last_1,
  opponent.two_points_att_avg_last_5 AS	opponent_two_points_att_avg_last_5,
  opponent.two_points_att_avg_last_10 AS	opponent_two_points_att_avg_last_10,
  opponent.two_points_pct_avg_last_1 AS	opponent_two_points_pct_avg_last_1,
  opponent.two_points_pct_avg_last_5 AS	opponent_two_points_pct_avg_last_5,
  opponent.two_points_pct_avg_last_10 AS	opponent_two_points_pct_avg_last_10,
  opponent.free_throws_made_avg_last_1 AS	opponent_free_throws_made_avg_last_1,
  opponent.free_throws_made_avg_last_5 AS	opponent_free_throws_made_avg_last_5,
  opponent.free_throws_made_avg_last_10 AS	opponent_free_throws_made_avg_last_10,
  opponent.free_throws_att_avg_last_1 AS	opponent_free_throws_att_avg_last_1,
  opponent.free_throws_att_avg_last_5 AS	opponent_free_throws_att_avg_last_5,
  opponent.free_throws_att_avg_last_10 AS	opponent_free_throws_att_avg_last_10,
  opponent.free_throws_pct_avg_last_1 AS	opponent_free_throws_pct_avg_last_1,
  opponent.free_throws_pct_avg_last_5 AS	opponent_free_throws_pct_avg_last_5,
  opponent.free_throws_pct_avg_last_10 AS	opponent_free_throws_pct_avg_last_10,
  opponent.ts_pct_avg_last_1 AS	opponent_ts_pct_avg_last_1,
  opponent.ts_pct_avg_last_5 AS	opponent_ts_pct_avg_last_5,
  opponent.ts_pct_avg_last_10 AS	opponent_ts_pct_avg_last_10,
  opponent.efg_pct_avg_last_1 AS	opponent_efg_pct_avg_last_1,
  opponent.efg_pct_avg_last_5 AS	opponent_efg_pct_avg_last_5,
  opponent.efg_pct_avg_last_10 AS	opponent_efg_pct_avg_last_10,
  opponent.rebounds_avg_last_1 AS	opponent_rebounds_avg_last_1,
  opponent.rebounds_avg_last_5 AS	opponent_rebounds_avg_last_5,
  opponent.rebounds_avg_last_10 AS	opponent_rebounds_avg_last_10,
  opponent.offensive_rebounds_avg_last_1 AS	opponent_offensive_rebounds_avg_last_1,
  opponent.offensive_rebounds_avg_last_5 AS	opponent_offensive_rebounds_avg_last_5,
  opponent.offensive_rebounds_avg_last_10 AS	opponent_offensive_rebounds_avg_last_10,
  opponent.defensive_rebounds_avg_last_1 AS	opponent_defensive_rebounds_avg_last_1,
  opponent.defensive_rebounds_avg_last_5 AS	opponent_defensive_rebounds_avg_last_5,
  opponent.defensive_rebounds_avg_last_10 AS	opponent_defensive_rebounds_avg_last_10,
  opponent.dreb_pct_avg_last_1 AS	opponent_dreb_pct_avg_last_1,
  opponent.dreb_pct_avg_last_5 AS	opponent_dreb_pct_avg_last_5,
  opponent.dreb_pct_avg_last_10 AS	opponent_dreb_pct_avg_last_10,
  opponent.oreb_pct_avg_last_1 AS	opponent_oreb_pct_avg_last_1,
  opponent.oreb_pct_avg_last_5 AS	opponent_oreb_pct_avg_last_5,
  opponent.oreb_pct_avg_last_10 AS	opponent_oreb_pct_avg_last_10,
  opponent.steals_avg_last_1 AS	opponent_steals_avg_last_1,
  opponent.steals_avg_last_5 AS	opponent_steals_avg_last_5,
  opponent.steals_avg_last_10 AS	opponent_steals_avg_last_10,
  opponent.blocks_avg_last_1 AS	opponent_blocks_avg_last_1,
  opponent.blocks_avg_last_5 AS	opponent_blocks_avg_last_5,
  opponent.blocks_avg_last_10 AS	opponent_blocks_avg_last_10,
  opponent.assists_avg_last_1 AS	opponent_assists_avg_last_1,
  opponent.assists_avg_last_5 AS	opponent_assists_avg_last_5,
  opponent.assists_avg_last_10 AS	opponent_assists_avg_last_10,
  opponent.turnovers_avg_last_1 AS	opponent_turnovers_avg_last_1,
  opponent.turnovers_avg_last_5 AS	opponent_turnovers_avg_last_5,
  opponent.turnovers_avg_last_10 AS	opponent_turnovers_avg_last_10,
  opponent.team_turnovers_avg_last_1 AS	opponent_team_turnovers_avg_last_1,
  opponent.team_turnovers_avg_last_5 AS	opponent_team_turnovers_avg_last_5,
  opponent.team_turnovers_avg_last_10 AS	opponent_team_turnovers_avg_last_10,
  opponent.points_off_turnovers_avg_last_1 AS	opponent_points_off_turnovers_avg_last_1,
  opponent.points_off_turnovers_avg_last_5 AS	opponent_points_off_turnovers_avg_last_5,
  opponent.points_off_turnovers_avg_last_10 AS opponent_points_off_turnovers_avg_last_10,
  opponent.assists_turnover_ratio_avg_last_1 AS opponent_assists_turnover_ratio_avg_last_1,
  opponent.assists_turnover_ratio_avg_last_5 AS opponent_assists_turnover_ratio_avg_last_5,
  opponent.assists_turnover_ratio_avg_last_10 AS opponent_assists_turnover_ratio_avg_last_10,
  opponent.ast_fgm_pct_avg_last_1 AS	opponent_ast_fgm_pct_avg_last_1,
  opponent.ast_fgm_pct_avg_last_5 AS	opponent_ast_fgm_pct_avg_last_5,
  opponent.ast_fgm_pct_avg_last_10 AS	opponent_ast_fgm_pct_avg_last_10,
  opponent.personal_fouls_avg_last_1 AS	opponent_personal_fouls_avg_last_1,
  opponent.personal_fouls_avg_last_5 AS	opponent_personal_fouls_avg_last_5,
  opponent.personal_fouls_avg_last_10 AS	opponent_personal_fouls_avg_last_10,
  opponent.flagrant_fouls_avg_last_1 AS	opponent_flagrant_fouls_avg_last_1,
  opponent.flagrant_fouls_avg_last_5 AS	opponent_flagrant_fouls_avg_last_5,
  opponent.flagrant_fouls_avg_last_10 AS	opponent_flagrant_fouls_avg_last_10,
  opponent.player_tech_fouls_avg_last_1 AS	opponent_player_tech_fouls_avg_last_1,
  opponent.player_tech_fouls_avg_last_5 AS	opponent_player_tech_fouls_avg_last_5,
  opponent.player_tech_fouls_avg_last_10 AS	opponent_player_tech_fouls_avg_last_10,
  opponent.team_tech_fouls_avg_last_1 AS	opponent_team_tech_fouls_avg_last_1,
  opponent.team_tech_fouls_avg_last_5 AS	opponent_team_tech_fouls_avg_last_5,
  opponent.team_tech_fouls_avg_last_10 AS	opponent_team_tech_fouls_avg_last_10,
  opponent.coach_tech_fouls_avg_last_1 AS	opponent_coach_tech_fouls_avg_last_1,
  opponent.coach_tech_fouls_avg_last_5 AS	opponent_coach_tech_fouls_avg_last_5,
  opponent.coach_tech_fouls_avg_last_10 AS	opponent_coach_tech_fouls_avg_last_10,
  opponent.foulouts_avg_last_1 AS	opponent_foulouts_avg_last_1,
  opponent.foulouts_avg_last_5 AS	opponent_foulouts_avg_last_5,
  opponent.foulouts_avg_last_10 AS	opponent_foulouts_avg_last_10,
  opponent.score_delta_avg_last_1 AS	opponent_score_delta_avg_last_1,
  opponent.score_delta_avg_last_5 AS	opponent_score_delta_avg_last_5,
  opponent.score_delta_avg_last_10 AS	opponent_score_delta_avg_last_10,
  opponent.possessions_avg_last_1 AS	opponent_possessions_avg_last_1,
  opponent.possessions_avg_last_5 AS	opponent_possessions_avg_last_5,
  opponent.possessions_avg_last_10 AS	opponent_possessions_avg_last_10,
  opponent.opp_points_avg_last_1 AS	opponent_opp_points_avg_last_1,
  opponent.opp_points_avg_last_5 AS	opponent_opp_points_avg_last_5,
  opponent.opp_points_avg_last_10 AS	opponent_opp_points_avg_last_10,
  opponent.opp_fast_break_pts_avg_last_1 AS	opponent_opp_fast_break_pts_avg_last_1,
  opponent.opp_fast_break_pts_avg_last_5 AS	opponent_opp_fast_break_pts_avg_last_5,
  opponent.opp_fast_break_pts_avg_last_10 AS	opponent_opp_fast_break_pts_avg_last_10,
  opponent.opp_second_chance_pts_avg_last_1 AS	opponent_opp_second_chance_pts_avg_last_1,
  opponent.opp_second_chance_pts_avg_last_5 AS	opponent_opp_second_chance_pts_avg_last_5,
  opponent.opp_second_chance_pts_avg_last_10 AS opponent_opp_second_chance_pts_avg_last_10,
  opponent.opp_field_goals_made_avg_last_1 AS	 opponent_opp_field_goals_made_avg_last_1,
  opponent.opp_field_goals_made_avg_last_5 AS	 opponent_opp_field_goals_made_avg_last_5,
  opponent.opp_field_goals_made_avg_last_10 AS	opponent_opp_field_goals_made_avg_last_10,
  opponent.opp_field_goals_att_avg_last_1 AS	opponent_opp_field_goals_att_avg_last_1,
  opponent.opp_field_goals_att_avg_last_5 AS	opponent_opp_field_goals_att_avg_last_5,
  opponent.opp_field_goals_att_avg_last_10 AS opponent_opp_field_goals_att_avg_last_10,
  opponent.opp_field_goals_pct_avg_last_1 AS	opponent_opp_field_goals_pct_avg_last_1,
  opponent.opp_field_goals_pct_avg_last_5 AS	opponent_opp_field_goals_pct_avg_last_5,
  opponent.opp_field_goals_pct_avg_last_10 AS	opponent_opp_field_goals_pct_avg_last_10,
  opponent.opp_three_points_made_avg_last_1 AS	opponent_opp_three_points_made_avg_last_1,
  opponent.opp_three_points_made_avg_last_5 AS	opponent_opp_three_points_made_avg_last_5,
  opponent.opp_three_points_made_avg_last_10 AS opponent_opp_three_points_made_avg_last_10,
  opponent.opp_three_points_att_avg_last_1 AS	 opponent_opp_three_points_att_avg_last_1,
  opponent.opp_three_points_att_avg_last_5 AS 	opponent_opp_three_points_att_avg_last_5,
  opponent.opp_three_points_att_avg_last_10 AS	opponent_opp_three_points_att_avg_last_10,
  opponent.opp_three_points_pct_avg_last_1 AS	 opponent_opp_three_points_pct_avg_last_1,
  opponent.opp_three_points_pct_avg_last_5 AS	 opponent_opp_three_points_pct_avg_last_5,
  opponent.opp_three_points_pct_avg_last_10 AS	opponent_opp_three_points_pct_avg_last_10,
  opponent.opp_two_points_made_avg_last_1 AS	opponent_opp_two_points_made_avg_last_1,
  opponent.opp_two_points_made_avg_last_5 AS	opponent_opp_two_points_made_avg_last_5,
  opponent.opp_two_points_made_avg_last_10 AS 	opponent_opp_two_points_made_avg_last_10,
  opponent.opp_two_points_att_avg_last_1 AS	opponent_opp_two_points_att_avg_last_1,
  opponent.opp_two_points_att_avg_last_5 AS	opponent_opp_two_points_att_avg_last_5,
  opponent.opp_two_points_att_avg_last_10 AS	opponent_opp_two_points_att_avg_last_10,
  opponent.opp_two_points_pct_avg_last_1 AS	opponent_opp_two_points_pct_avg_last_1,
  opponent.opp_two_points_pct_avg_last_5 AS	opponent_opp_two_points_pct_avg_last_5,
  opponent.opp_two_points_pct_avg_last_10 AS	opponent_opp_two_points_pct_avg_last_10,
  opponent.opp_free_throws_made_avg_last_1 AS	 opponent_opp_free_throws_made_avg_last_1,
  opponent.opp_free_throws_made_avg_last_5 AS	 opponent_opp_free_throws_made_avg_last_5,
  opponent.opp_free_throws_made_avg_last_10 AS	opponent_opp_free_throws_made_avg_last_10,
  opponent.opp_free_throws_att_avg_last_1 AS	opponent_opp_free_throws_att_avg_last_1,
  opponent.opp_free_throws_att_avg_last_5 AS	opponent_opp_free_throws_att_avg_last_5,
  opponent.opp_free_throws_att_avg_last_10 AS	opponent_opp_free_throws_att_avg_last_10,
  opponent.opp_free_throws_pct_avg_last_1 AS	opponent_opp_free_throws_pct_avg_last_1,
  opponent.opp_free_throws_pct_avg_last_5 AS	opponent_opp_free_throws_pct_avg_last_5,
  opponent.opp_free_throws_pct_avg_last_10 AS 	opponent_opp_free_throws_pct_avg_last_10,
  opponent.opp_ts_pct_avg_last_1 AS	opponent_opp_ts_pct_avg_last_1,
  opponent.opp_ts_pct_avg_last_5 AS	opponent_opp_ts_pct_avg_last_5,
  opponent.opp_ts_pct_avg_last_10 AS	opponent_opp_ts_pct_avg_last_10,
  opponent.opp_efg_pct_avg_last_1 AS	opponent_opp_efg_pct_avg_last_1,
  opponent.opp_efg_pct_avg_last_5 AS	opponent_opp_efg_pct_avg_last_5,
  opponent.opp_efg_pct_avg_last_10 AS	 opponent_opp_efg_pct_avg_last_10,
  opponent.opp_rebounds_avg_last_1 AS	opponent_opp_rebounds_avg_last_1,
  opponent.opp_rebounds_avg_last_5 AS	opponent_opp_rebounds_avg_last_5,
  opponent.opp_rebounds_avg_last_10 AS	opponent_opp_rebounds_avg_last_10,
  opponent.opp_offensive_rebounds_avg_last_1 AS opponent_opp_offensive_rebounds_avg_last_1,
  opponent.opp_offensive_rebounds_avg_last_5 AS opponent_opp_offensive_rebounds_avg_last_5,
  opponent.opp_offensive_rebounds_avg_last_10 AS opponent_opp_offensive_rebounds_avg_last_10,
  opponent.opp_defensive_rebounds_avg_last_1 AS opponent_opp_defensive_rebounds_avg_last_1,
  opponent.opp_defensive_rebounds_avg_last_5 AS opponent_opp_defensive_rebounds_avg_last_5,
  opponent.opp_defensive_rebounds_avg_last_10 AS opponent_opp_defensive_rebounds_avg_last_10,
  opponent.opp_dreb_pct_avg_last_1 AS	opponent_opp_dreb_pct_avg_last_1,
  opponent.opp_dreb_pct_avg_last_5 AS	opponent_opp_dreb_pct_avg_last_5,
  opponent.opp_dreb_pct_avg_last_10 AS	opponent_opp_dreb_pct_avg_last_10,
  opponent.opp_oreb_pct_avg_last_1 AS	opponent_opp_oreb_pct_avg_last_1,
  opponent.opp_oreb_pct_avg_last_5 AS	opponent_opp_oreb_pct_avg_last_5,
  opponent.opp_oreb_pct_avg_last_10 AS	opponent_opp_oreb_pct_avg_last_10,
  opponent.opp_steals_avg_last_1 AS	opponent_opp_steals_avg_last_1,
  opponent.opp_steals_avg_last_5 AS	opponent_opp_steals_avg_last_5,
  opponent.opp_steals_avg_last_10 AS	opponent_opp_steals_avg_last_10,
  opponent.opp_blocks_avg_last_1 AS	opponent_opp_blocks_avg_last_1,
  opponent.opp_blocks_avg_last_5 AS	opponent_opp_blocks_avg_last_5,
  opponent.opp_blocks_avg_last_10 AS	opponent_opp_blocks_avg_last_10,
  opponent.opp_assists_avg_last_1 AS	opponent_opp_assists_avg_last_1,
  opponent.opp_assists_avg_last_5 AS	opponent_opp_assists_avg_last_5,
  opponent.opp_assists_avg_last_10 AS	opponent_opp_assists_avg_last_10,
  opponent.opp_turnovers_avg_last_1 AS	opponent_opp_turnovers_avg_last_1,
  opponent.opp_turnovers_avg_last_5 AS	opponent_opp_turnovers_avg_last_5,
  opponent.opp_turnovers_avg_last_10 AS	opponent_opp_turnovers_avg_last_10,
  opponent.opp_team_turnovers_avg_last_1 AS	opponent_opp_team_turnovers_avg_last_1,
  opponent.opp_team_turnovers_avg_last_5 AS	opponent_opp_team_turnovers_avg_last_5,
  opponent.opp_team_turnovers_avg_last_10 AS	opponent_opp_team_turnovers_avg_last_10,
  opponent.opp_points_off_turnovers_avg_last_1 AS opponent_opp_points_off_turnovers_avg_last_1,
  opponent.opp_points_off_turnovers_avg_last_5 AS opponent_opp_points_off_turnovers_avg_last_5,
  opponent.opp_points_off_turnovers_avg_last_10 AS opponent_opp_points_off_turnovers_avg_last_10,
  opponent.opp_assists_turnover_ratio_avg_last_1 AS opponent_opp_assists_turnover_ratio_avg_last_1,
  opponent.opp_assists_turnover_ratio_avg_last_5 AS opponent_opp_assists_turnover_ratio_avg_last_5,
  opponent.opp_assists_turnover_ratio_avg_last_10 AS opponent_opp_assists_turnover_ratio_avg_last_10,
  opponent.opp_ast_fgm_pct_avg_last_1 AS	opponent_opp_ast_fgm_pct_avg_last_1,
  opponent.opp_ast_fgm_pct_avg_last_5 AS	opponent_opp_ast_fgm_pct_avg_last_5,
  opponent.opp_ast_fgm_pct_avg_last_10 AS	opponent_opp_ast_fgm_pct_avg_last_10,
  opponent.opp_personal_fouls_avg_last_1 AS	opponent_opp_personal_fouls_avg_last_1,
  opponent.opp_personal_fouls_avg_last_5 AS	opponent_opp_personal_fouls_avg_last_5,
  opponent.opp_personal_fouls_avg_last_10 AS	opponent_opp_personal_fouls_avg_last_10,
  opponent.opp_flagrant_fouls_avg_last_1 AS	opponent_opp_flagrant_fouls_avg_last_1,
  opponent.opp_flagrant_fouls_avg_last_5 AS	opponent_opp_flagrant_fouls_avg_last_5,
  opponent.opp_flagrant_fouls_avg_last_10 AS	opponent_opp_flagrant_fouls_avg_last_10,
  opponent.opp_player_tech_fouls_avg_last_1 AS	opponent_opp_player_tech_fouls_avg_last_1,
  opponent.opp_player_tech_fouls_avg_last_5 AS	opponent_opp_player_tech_fouls_avg_last_5,
  opponent.opp_player_tech_fouls_avg_last_10 AS opponent_opp_player_tech_fouls_avg_last_10,
  opponent.opp_team_tech_fouls_avg_last_1 AS	opponent_opp_team_tech_fouls_avg_last_1,
  opponent.opp_team_tech_fouls_avg_last_5 AS	opponent_opp_team_tech_fouls_avg_last_5,
  opponent.opp_team_tech_fouls_avg_last_10 AS	 opponent_opp_team_tech_fouls_avg_last_10,
  opponent.opp_coach_tech_fouls_avg_last_1 AS 	opponent_opp_coach_tech_fouls_avg_last_1,
  opponent.opp_coach_tech_fouls_avg_last_5 AS	 opponent_opp_coach_tech_fouls_avg_last_5,
  opponent.opp_coach_tech_fouls_avg_last_10 AS	opponent_opp_coach_tech_fouls_avg_last_10,
  opponent.opp_foulouts_avg_last_1 AS	opponent_opp_foulouts_avg_last_1,
  opponent.opp_foulouts_avg_last_5 AS	opponent_opp_foulouts_avg_last_5,
  opponent.opp_foulouts_avg_last_10 AS	opponent_opp_foulouts_avg_last_10,
  opponent.opp_score_delta_avg_last_1 AS	opponent_opp_score_delta_avg_last_1,
  opponent.opp_score_delta_avg_last_5 AS	opponent_opp_score_delta_avg_last_5,
  opponent.opp_score_delta_avg_last_10 AS	opponent_opp_score_delta_avg_last_10,
  opponent.opp_possessions_avg_last_1 AS	opponent_opp_possessions_avg_last_1,
  opponent.opp_possessions_avg_last_5 AS	opponent_opp_possessions_avg_last_5,
  opponent.opp_possessions_avg_last_10 AS	opponent_opp_possessions_avg_last_10,
  opponent.points_std_last_5 AS	opponent_points_std_last_5,
  opponent.points_std_last_10 AS	opponent_points_std_last_10,
  opponent.fast_break_pts_std_last_5 AS	opponent_fast_break_pts_std_last_5,
  opponent.fast_break_pts_std_last_10 AS	opponent_fast_break_pts_std_last_10,
  opponent.second_chance_pts_std_last_5 AS	opponent_second_chance_pts_std_last_5,
  opponent.second_chance_pts_std_last_10 AS	opponent_second_chance_pts_std_last_10,
  opponent.field_goals_made_std_last_5 AS	opponent_field_goals_made_std_last_5,
  opponent.field_goals_made_std_last_10 AS	opponent_field_goals_made_std_last_10,
  opponent.field_goals_att_std_last_5 AS	opponent_field_goals_att_std_last_5,
  opponent.field_goals_att_std_last_10 AS	opponent_field_goals_att_std_last_10,
  opponent.field_goals_pct_std_last_5 AS	opponent_field_goals_pct_std_last_5,
  opponent.field_goals_pct_std_last_10 AS	opponent_field_goals_pct_std_last_10,
  opponent.three_points_made_std_last_5 AS	opponent_three_points_made_std_last_5,
  opponent.three_points_made_std_last_10 AS	opponent_three_points_made_std_last_10,
  opponent.three_points_att_std_last_5 AS	opponent_three_points_att_std_last_5,
  opponent.three_points_att_std_last_10 AS	opponent_three_points_att_std_last_10,
  opponent.three_points_pct_std_last_5 AS	opponent_three_points_pct_std_last_5,
  opponent.three_points_pct_std_last_10 AS	opponent_three_points_pct_std_last_10,
  opponent.two_points_made_std_last_5 AS	opponent_two_points_made_std_last_5,
  opponent.two_points_made_std_last_10 AS	opponent_two_points_made_std_last_10,
  opponent.two_points_att_std_last_5 AS	opponent_two_points_att_std_last_5,
  opponent.two_points_att_std_last_10 AS	opponent_two_points_att_std_last_10,
  opponent.two_points_pct_std_last_5 AS	opponent_two_points_pct_std_last_5,
  opponent.two_points_pct_std_last_10 AS	opponent_two_points_pct_std_last_10,
  opponent.free_throws_made_std_last_5 AS	opponent_free_throws_made_std_last_5,
  opponent.free_throws_made_std_last_10 AS	opponent_free_throws_made_std_last_10,
  opponent.free_throws_att_std_last_5 AS	opponent_free_throws_att_std_last_5,
  opponent.free_throws_att_std_last_10 AS	opponent_free_throws_att_std_last_10,
  opponent.free_throws_pct_std_last_5 AS	opponent_free_throws_pct_std_last_5,
  opponent.free_throws_pct_std_last_10 AS	opponent_free_throws_pct_std_last_10,
  opponent.ts_pct_std_last_5 AS	opponent_ts_pct_std_last_5,
  opponent.ts_pct_std_last_10 AS	opponent_ts_pct_std_last_10,
  opponent.efg_pct_std_last_5 AS	opponent_efg_pct_std_last_5,
  opponent.efg_pct_std_last_10 AS	opponent_efg_pct_std_last_10,
  opponent.rebounds_std_last_5 AS	opponent_rebounds_std_last_5,
  opponent.rebounds_std_last_10 AS	opponent_rebounds_std_last_10,
  opponent.offensive_rebounds_std_last_5 AS	opponent_offensive_rebounds_std_last_5,
  opponent.offensive_rebounds_std_last_10 AS	opponent_offensive_rebounds_std_last_10,
  opponent.defensive_rebounds_std_last_5 AS	opponent_defensive_rebounds_std_last_5,
  opponent.defensive_rebounds_std_last_10 AS	opponent_defensive_rebounds_std_last_10,
  opponent.dreb_pct_std_last_5 AS	opponent_dreb_pct_std_last_5,
  opponent.dreb_pct_std_last_10 AS	opponent_dreb_pct_std_last_10,
  opponent.oreb_pct_std_last_5 AS	opponent_oreb_pct_std_last_5,
  opponent.oreb_pct_std_last_10 AS	opponent_oreb_pct_std_last_10,
  opponent.steals_std_last_5 AS	opponent_steals_std_last_5,
  opponent.steals_std_last_10 AS	opponent_steals_std_last_10,
  opponent.blocks_std_last_5 AS	opponent_blocks_std_last_5,
  opponent.blocks_std_last_10 AS	opponent_blocks_std_last_10,
  opponent.assists_std_last_5 AS	opponent_assists_std_last_5,
  opponent.assists_std_last_10 AS	opponent_assists_std_last_10,
  opponent.turnovers_std_last_5 AS	opponent_turnovers_std_last_5,
  opponent.turnovers_std_last_10 AS	opponent_turnovers_std_last_10,
  opponent.team_turnovers_std_last_5 AS	opponent_team_turnovers_std_last_5,
  opponent.team_turnovers_std_last_10 AS	opponent_team_turnovers_std_last_10,
  opponent.points_off_turnovers_std_last_5 AS 	opponent_points_off_turnovers_std_last_5,
  opponent.points_off_turnovers_std_last_10 AS	opponent_points_off_turnovers_std_last_10,
  opponent.assists_turnover_ratio_std_last_5 AS opponent_assists_turnover_ratio_std_last_5,
  opponent.assists_turnover_ratio_std_last_10 AS opponent_assists_turnover_ratio_std_last_10,
  opponent.ast_fgm_pct_std_last_5 AS	opponent_ast_fgm_pct_std_last_5,
  opponent.ast_fgm_pct_std_last_10 AS	opponent_ast_fgm_pct_std_last_10,
  opponent.personal_fouls_std_last_5 AS	opponent_personal_fouls_std_last_5,
  opponent.personal_fouls_std_last_10 AS	opponent_personal_fouls_std_last_10,
  opponent.flagrant_fouls_std_last_5 AS	opponent_flagrant_fouls_std_last_5,
  opponent.flagrant_fouls_std_last_10 AS	opponent_flagrant_fouls_std_last_10,
  opponent.player_tech_fouls_std_last_5 AS	opponent_player_tech_fouls_std_last_5,
  opponent.player_tech_fouls_std_last_10 AS	opponent_player_tech_fouls_std_last_10,
  opponent.team_tech_fouls_std_last_5 AS	opponent_team_tech_fouls_std_last_5,
  opponent.team_tech_fouls_std_last_10 AS	opponent_team_tech_fouls_std_last_10,
  opponent.coach_tech_fouls_std_last_5 AS	opponent_coach_tech_fouls_std_last_5,
  opponent.coach_tech_fouls_std_last_10 AS	opponent_coach_tech_fouls_std_last_10,
  opponent.foulouts_std_last_5 AS	opponent_foulouts_std_last_5,
  opponent.foulouts_std_last_10 AS	opponent_foulouts_std_last_10,
  opponent.score_delta_std_last_5 AS	opponent_score_delta_std_last_5,
  opponent.score_delta_std_last_10 AS	opponent_score_delta_std_last_10,
  opponent.possessions_std_last_5 AS	opponent_possessions_std_last_5,
  opponent.possessions_std_last_10 AS	opponent_possessions_std_last_10,
  opponent.opp_points_std_last_5 AS	opponent_opp_points_std_last_5,
  opponent.opp_points_std_last_10 AS	opponent_opp_points_std_last_10,
  opponent.opp_fast_break_pts_std_last_5 AS	opponent_opp_fast_break_pts_std_last_5,
  opponent.opp_fast_break_pts_std_last_10 AS	opponent_opp_fast_break_pts_std_last_10,
  opponent.opp_second_chance_pts_std_last_5 AS	opponent_opp_second_chance_pts_std_last_5,
  opponent.opp_second_chance_pts_std_last_10 AS opponent_opp_second_chance_pts_std_last_10,
  opponent.opp_field_goals_made_std_last_5 AS	 opponent_opp_field_goals_made_std_last_5,
  opponent.opp_field_goals_made_std_last_10 AS	opponent_opp_field_goals_made_std_last_10,
  opponent.opp_field_goals_att_std_last_5 AS	opponent_opp_field_goals_att_std_last_5,
  opponent.opp_field_goals_att_std_last_10 AS	 opponent_opp_field_goals_att_std_last_10,
  opponent.opp_field_goals_pct_std_last_5 AS	opponent_opp_field_goals_pct_std_last_5,
  opponent.opp_field_goals_pct_std_last_10 AS	 opponent_opp_field_goals_pct_std_last_10,
  opponent.opp_three_points_made_std_last_5 AS	opponent_opp_three_points_made_std_last_5,
  opponent.opp_three_points_made_std_last_10 AS opponent_opp_three_points_made_std_last_10,
  opponent.opp_three_points_att_std_last_5 AS	 opponent_opp_three_points_att_std_last_5,
  opponent.opp_three_points_att_std_last_10 AS	opponent_opp_three_points_att_std_last_10,
  opponent.opp_three_points_pct_std_last_5 AS	 opponent_opp_three_points_pct_std_last_5,
  opponent.opp_three_points_pct_std_last_10 AS	opponent_opp_three_points_pct_std_last_10,
  opponent.opp_two_points_made_std_last_5 AS	opponent_opp_two_points_made_std_last_5,
  opponent.opp_two_points_made_std_last_10 AS	 opponent_opp_two_points_made_std_last_10,
  opponent.opp_two_points_att_std_last_5 AS	opponent_opp_two_points_att_std_last_5,
  opponent.opp_two_points_att_std_last_10 AS	opponent_opp_two_points_att_std_last_10,
  opponent.opp_two_points_pct_std_last_5 AS	opponent_opp_two_points_pct_std_last_5,
  opponent.opp_two_points_pct_std_last_10 AS	opponent_opp_two_points_pct_std_last_10,
  opponent.opp_free_throws_made_std_last_5 AS	 opponent_opp_free_throws_made_std_last_5,
  opponent.opp_free_throws_made_std_last_10 AS	opponent_opp_free_throws_made_std_last_10,
  opponent.opp_free_throws_att_std_last_5 AS	opponent_opp_free_throws_att_std_last_5,
  opponent.opp_free_throws_att_std_last_10 AS	 opponent_opp_free_throws_att_std_last_10,
  opponent.opp_free_throws_pct_std_last_5 AS	opponent_opp_free_throws_pct_std_last_5,
  opponent.opp_free_throws_pct_std_last_10 AS	 opponent_opp_free_throws_pct_std_last_10,
  opponent.opp_ts_pct_std_last_5 AS	opponent_opp_ts_pct_std_last_5,
  opponent.opp_ts_pct_std_last_10 AS	opponent_opp_ts_pct_std_last_10,
  opponent.opp_efg_pct_std_last_5 AS	opponent_opp_efg_pct_std_last_5,
  opponent.opp_efg_pct_std_last_10 AS	opponent_opp_efg_pct_std_last_10,
  opponent.opp_rebounds_std_last_5 AS	opponent_opp_rebounds_std_last_5,
  opponent.opp_rebounds_std_last_10 AS	opponent_opp_rebounds_std_last_10,
  opponent.opp_offensive_rebounds_std_last_5 AS opponent_opp_offensive_rebounds_std_last_5,
  opponent.opp_offensive_rebounds_std_last_10 AS opponent_opp_offensive_rebounds_std_last_10,
  opponent.opp_defensive_rebounds_std_last_5 AS opponent_opp_defensive_rebounds_std_last_5,
  opponent.opp_defensive_rebounds_std_last_10 AS opponent_opp_defensive_rebounds_std_last_10,
  opponent.opp_dreb_pct_std_last_5 AS	opponent_opp_dreb_pct_std_last_5,
  opponent.opp_dreb_pct_std_last_10 AS	opponent_opp_dreb_pct_std_last_10,
  opponent.opp_oreb_pct_std_last_5 AS	opponent_opp_oreb_pct_std_last_5,
  opponent.opp_oreb_pct_std_last_10 AS	opponent_opp_oreb_pct_std_last_10,
  opponent.opp_steals_std_last_5 AS	opponent_opp_steals_std_last_5,
  opponent.opp_steals_std_last_10 AS	opponent_opp_steals_std_last_10,
  opponent.opp_blocks_std_last_5 AS	opponent_opp_blocks_std_last_5,
  opponent.opp_blocks_std_last_10 AS	opponent_opp_blocks_std_last_10,
  opponent.opp_assists_std_last_5 AS	opponent_opp_assists_std_last_5,
  opponent.opp_assists_std_last_10 AS	opponent_opp_assists_std_last_10,
  opponent.opp_turnovers_std_last_5 AS	opponent_opp_turnovers_std_last_5,
  opponent.opp_turnovers_std_last_10 AS	opponent_opp_turnovers_std_last_10,
  opponent.opp_team_turnovers_std_last_5 AS	opponent_opp_team_turnovers_std_last_5,
  opponent.opp_team_turnovers_std_last_10 AS	opponent_opp_team_turnovers_std_last_10,
  opponent.opp_points_off_turnovers_std_last_5 AS opponent_opp_points_off_turnovers_std_last_5,
  opponent.opp_points_off_turnovers_std_last_10 AS opponent_opp_points_off_turnovers_std_last_10,
  opponent.opp_assists_turnover_ratio_std_last_5 AS opponent_opp_assists_turnover_ratio_std_last_5,
  opponent.opp_assists_turnover_ratio_std_last_10 AS	opponent_opp_assists_turnover_ratio_std_last_10,
  opponent.opp_ast_fgm_pct_std_last_5 AS	opponent_opp_ast_fgm_pct_std_last_5,
  opponent.opp_ast_fgm_pct_std_last_10 AS	opponent_opp_ast_fgm_pct_std_last_10,
  opponent.opp_personal_fouls_std_last_5 AS	opponent_opp_personal_fouls_std_last_5,
  opponent.opp_personal_fouls_std_last_10 AS	opponent_opp_personal_fouls_std_last_10,
  opponent.opp_flagrant_fouls_std_last_5 AS	opponent_opp_flagrant_fouls_std_last_5,
  opponent.opp_flagrant_fouls_std_last_10 AS	opponent_opp_flagrant_fouls_std_last_10,
  opponent.opp_player_tech_fouls_std_last_5 AS	opponent_opp_player_tech_fouls_std_last_5,
  opponent.opp_player_tech_fouls_std_last_10 AS opponent_opp_player_tech_fouls_std_last_10,
  opponent.opp_team_tech_fouls_std_last_5 AS	opponent_opp_team_tech_fouls_std_last_5,
  opponent.opp_team_tech_fouls_std_last_10 AS 	opponent_opp_team_tech_fouls_std_last_10,
  opponent.opp_coach_tech_fouls_std_last_5 AS	 opponent_opp_coach_tech_fouls_std_last_5,
  opponent.opp_coach_tech_fouls_std_last_10 AS	opponent_opp_coach_tech_fouls_std_last_10,
  opponent.opp_foulouts_std_last_5 AS	opponent_opp_foulouts_std_last_5,
  opponent.opp_foulouts_std_last_10 AS	opponent_opp_foulouts_std_last_10,
  opponent.opp_score_delta_std_last_5 AS	opponent_opp_score_delta_std_last_5,
  opponent.opp_score_delta_std_last_10 AS	opponent_opp_score_delta_std_last_10,
  opponent.opp_possessions_std_last_5 AS	opponent_opp_possessions_std_last_5,
  opponent.opp_possessions_std_last_10 AS	opponent_opp_possessions_std_last_10
FROM
  `{0}.cume_games` AS team
JOIN
  `{0}.cume_games` AS opponent
ON
  team.game_id = opponent.game_id AND team.team_id != opponent.team_id
WHERE
  team.home_team = true AND team.game_number > 10 AND opponent.game_number > 10
  AND ((team.scheduled_date >= DATE('2014-03-18') AND team.scheduled_date <= DATE('2014-04-07'))
    OR (team.scheduled_date >= DATE('2015-03-17') AND team.scheduled_date <= DATE('2015-04-06'))
    OR (team.scheduled_date >= DATE('2016-03-15') AND team.scheduled_date <= DATE('2016-04-04'))
    OR (team.scheduled_date >= DATE('2017-03-14') AND team.scheduled_date <= DATE('2017-04-03'))
    OR (team.scheduled_date >= DATE('2017-05-01')))
ORDER BY season, scheduled_date
