# Cloud Composer Samples

All code in this directory is samples or tooling related to [Cloud Composer](https://cloud.google.com/composer). 

* [`2022_airflow_summit`](/composer/2022_airflow_summit) - contains sample code prepared for [Airflow Summit 2022 workshop](https://airflowsummit.org/sessions/2022/cloud-composer-workshop/)
* [`airflow_1_samples`](/composer/airflow_1_samples) - contains DAGs compatible with Airflow 1 Composer environments. More usage examples can be found in the [Composer documentation](https://cloud.google.com/composer/docs) and [standalone samples](https://cloud.google.com/composer/docs/samples)
* [`blog`](/composer/blog) - contains sample code used in blog posts pertaining to Cloud Composer
* [`cicd_sample`](/composer/cicd_sample) - contains a [sample for using Cloud Build to test and sync DAGs](https://cloud.google.com/composer/docs/dag-cicd-integration-guide)
* [`dag_test_utils`](/composer/dag_test_utils) - is a package used internally by repo maintainers
* [`functions`](/composer/functions) - contains samples that use Cloud Functions to trigger DAGs
* [`rest`](/composer/rest) - contains samples used in the documentation that interact with the Cloud Composer REST API
* [`tools`](/composer/tools) - contains utilities for Cloud Composer users to manage their environments. Each utility has a corresponding README.
* [`workflows`](/composer/workflows) - contains DAGs compatible with Airflow 2 Composer environments. More usage examples can be found in the [Composer documentation](https://cloud.google.com/composer/docs) and [standalone samples](https://cloud.google.com/composer/docs/samples)
