[//]: # "This README.md file is auto-generated, all changes to this file will be lost."
[//]: # "To regenerate it, use `python -m synthtool`."

## Python Samples for Google Cloud Key Management Service

This directory contains samples for Google Cloud Key Management Service, which may be used as a reference for how to use this product. 
The Google Cloud KMS API is a service that allows you to keep encryption keys centrally in the cloud, for direct use by cloud services. More info about Cloud KMS can be found at https://cloud.google.com/kms/docs/
Samples, quickstarts, and other documentation are available at <a href="https://cloud.google.com/kms">cloud.google.com</a>.


### Quickstart

This quickstart shows you how to create and use encryption keys with Cloud Key Management Service.


<a href="https://console.cloud.google.com/cloudshell/open?git_repo=https://github.com/GoogleCloudPlatform/python-docs-samples&page=editor&open_in_editor=kms/snippets/quickstart.py"><img alt="Open in Cloud Shell" src="http://gstatic.com/cloudssh/images/open-btn.png"> 
</a>

To run this sample:

1. If this is your first time working with GCP products, you will need to set up [the Cloud SDK][cloud_sdk] or utilize [Google Cloud Shell][gcloud_shell]. This sample may [require authentication][authentication] and you will need to [enable billing][enable_billing].

1. Make a fork of this repo and clone the branch locally, then navigate to the sample directory you want to use.

1. Install the dependencies needed to run the samples.

        pip install -r requirements.txt

1. Run the sample using

        python quickstart.py



More information about the Cloud KMS quickstart is available at https://cloud.google.com/kms/docs/quickstart

## Test permissions

The service account running the tests needs to have the following roles:
 * roles/cloudkms.admin
 * roles/cloudkms.cryptoKeyEncrypterDecrypter
 * roles/cloudkms.cryptoOperator
 * roles/cloudkms.publicKeyViewer
 * roles/cloudkms.signerVerifier

## Additional Information

These samples use the [Google Cloud Client Library for Python][client_library_python].
You can read the documentation for more details on API usage and use GitHub
to <a href="https://github.com/GoogleCloudPlatform/python-docs-samples/kms/snippets">browse the source</a> and [report issues][issues].

### Contributing
View the [contributing guidelines][contrib_guide], the [Python style guide][py_style] for more information.

[authentication]: https://cloud.google.com/docs/authentication/getting-started
[enable_billing]:https://cloud.google.com/apis/docs/getting-started#enabling_billing
[client_library_python]: https://googlecloudplatform.github.io/google-cloud-python/
[issues]: https://github.com/GoogleCloudPlatform/google-cloud-python/issues
[contrib_guide]: https://github.com/googleapis/google-cloud-python/blob/main/CONTRIBUTING.rst
[py_style]: http://google.github.io/styleguide/pyguide.html
[cloud_sdk]: https://cloud.google.com/sdk/docs
[gcloud_shell]: https://cloud.google.com/shell/docs
[gcloud_shell]: https://cloud.google.com/shell/docs
