/*
    Copyright 2013 Rustici Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/
package com.rusticisoftware.tincan;

import static com.rusticisoftware.tincan.TestUtils.*;
import java.net.URI;
import java.net.URL;

import org.junit.Test;

public class AttachmentTest {
    
    @Test
    public void serializeDeserialize() throws Exception {
        Attachment att = new Attachment();
        att.setContentType("text/plain");
        att.setDisplay(new LanguageMap());
        att.getDisplay().put("en-US", "Some attachment");
        att.setDescription(new LanguageMap());
        att.getDescription().put("en-US", "Some attachment description");
        att.setFileUrl(new URL("http://example.com/somefile"));
        att.setLength(27);
        att.setSha2("495395e777cd98da653df9615d09c0fd6bb2f8d4788394cd53c56a3bfdcd848a");
        att.setUsageType(new URI("http://example.com/attachment-usage/test"));
        
        assertSerializeDeserialize(att);
    }

}
