﻿## Aspose.Email Java for IntelliJ IDEA (Maven)
 
The project is **Intellij IDEA (JetBrains IDE) plugin** allows developer to create, read and manipulate Outlook MSG, PST, EML, EMLX and MHT messages using API -**Aspose.Email for Java** that enables you the processing of email messages from within your Java code without the need of using Microsoft Outlook.

The plugins is for those who wants to utilize / use **Aspose.Email for Java API** in their java projects.

The plugin contains two wizards:

1.  **Aspose-Email Maven Project** Wizard - To create **Aspose.Email for Java API** Maven project
2.  **Aspose.Email Examples** - To create / download **Aspose.Email for Java API** Examples Source Codes (Which is meant to demonstrate the usages of the API)

**Wizards Detail:**

1.  **Aspose.Email Maven Project** wizard, after installing the plugin, can be run from **File->New Project->Aspose.Email Maven Project** option. You will have to follow the wizard steps asking for the project information i.e **Project Name, Artifact ID** for your maven project or whether you want to download the Examples Source Codes (for later addition into the project).
2.  **Aspose.Email Examples** wizard lets you create /copy downloaded Source Code Examples into your project. All the examples withn the selected category will be copied/ created inside "**com.aspose.email.examples**" package and also the corresponding directory structure for the package will be created within "src/main/resources" folder which is needed to run the examples.

## What is Aspose.Email Java API?

Managing and manipulating emails that come in through Microsoft Outlook doesn’t have to be difficult. It doesn’t even have to involve Outlook. **Aspose.Email for Java** lets you focus on the business logic by hiding the complexities of the Microsoft Outlook file formats implementation. It gives you the tools you need to create, read and manipulate **Outlook MSG, PST, EML and MHT** files from within a Java application.

**Aspose.Email for Java** includes classes that allow you to create as well as read message files, enabling complete processing of message contents. **You can manipulate a number of message formats such as MSG, EML, EMLX, and MHT without the need of using Microsoft Outlook**. You can not only modify the message contents, but also manipulate (add/remove) message attachments. It provides you sufficient ability to customize message headers and also empowers you to completely control a message by exposing its Mapi properties.

Aspose.Email API also provides the ability to manipulate message storage files i.e. Personal Storage Files (PST) and Offline Storage Files (OST). You can create PST, add messages to it, extract information from various PST folders, and remove items from the PST with just a few lines of code. Its powerful API gives you complete access to the contents of a PST for manipulation.

For more info about the **Aspose.Email for Java API**, [please check the api documentation - click here](https://docs.aspose.com/display/emailjava/Getting+Started)

## Plugin Documentation

For the complete documentation of this Intellij IDEA plugin, [please go through this wiki - click here](https://docs.aspose.com/display/emailjava/Aspose.Email+Java+for+IntelliJ+IDEA+-+Maven)
