﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Windows.Forms.Analyzers;

internal partial record ApplicationConfig
{
    // Copied from https://github.com/dotnet/runtime/blob/00ee1c18715723e62484c9bc8a14f517455fc3b3/src/libraries/System.Drawing.Common/src/System/Drawing/FontStyle.cs
    [Flags]
    public enum FontStyle
    {
        /// <summary>
        ///  Normal text.
        /// </summary>
        Regular = 0,

        /// <summary>
        ///  Bold text.
        /// </summary>
        Bold = 1,

        /// <summary>
        ///  Italic text.
        /// </summary>
        Italic = 2,

        /// <summary>
        ///  Underlined text.
        /// </summary>
        Underline = 4,

        /// <summary>
        ///  Text with a line through the middle.
        /// </summary>
        Strikeout = 8,
    }
}
