// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#nullable disable

using System.ComponentModel;
using System.Drawing.Design;
using Moq;

namespace System.Windows.Forms.Design.Tests;

public class DataGridViewColumnDataPropertyNameEditorTests
{
    [Fact]
    public void DataGridViewColumnDataPropertyNameEditor_GetEditStyle()
    {
        new DataGridViewColumnDataPropertyNameEditor().GetEditStyle().Should().Be(UITypeEditorEditStyle.DropDown);
    }

    [Fact]
    public void DataGridViewColumnDataPropertyNameEditor_IsDropDownResizable()
    {
        new DataGridViewColumnDataPropertyNameEditor().IsDropDownResizable.Should().Be(true);
    }

    [Fact]
    public void DataGridViewColumnDataPropertyNameEditor_EditValue()
    {
        DataGridViewColumnDataPropertyNameEditor dataGridViewColumnEditor = new();
        object value = "123";
        dataGridViewColumnEditor.EditValue(null, null, value).Should().Be(value);

        Mock<ITypeDescriptorContext> mockTypeDescriptorContext = new(MockBehavior.Strict);
        dataGridViewColumnEditor.EditValue(mockTypeDescriptorContext.Object, null, value).Should().Be(value);

        Mock<IServiceProvider> mockServiceProvider = new(MockBehavior.Strict);
        dataGridViewColumnEditor.EditValue(null, mockServiceProvider.Object, value).Should().Be(value);

        mockTypeDescriptorContext.Setup(x => x.Instance).Returns(null);
        dataGridViewColumnEditor.EditValue(null, mockServiceProvider.Object, value).Should().Be(value);
    }
}
