﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#nullable disable

namespace System.Windows.Forms.Tests;

public class ToolStripDropDownMenuTests
{
    [WinFormsFact]
    public void ToolStripDropDownMenu_Constructor()
    {
        using ToolStripDropDownMenu menu = new();

        Assert.NotNull(menu);
    }

    [WinFormsFact]
    public void ToolStripDropDownMenu_ConstructorOwnerItemBool()
    {
        using ToolStripButton owner = new();
        bool isAutoGenerated = true;

        using ToolStripDropDownMenu menu = new(owner, isAutoGenerated);

        Assert.NotNull(menu);
        Assert.Equal(owner, menu.OwnerItem);
        Assert.True(menu.IsAutoGenerated);
    }
}
