@ECHO OFF
SETLOCAL

:: This command launches a Visual Studio Code with environment variables required to use a local version of the .NET Core SDK.

FOR /f "delims=" %%a IN ('where.exe code') DO @SET vscode=%%a& GOTO break
:break

IF ["%vscode%"] == [""] (
    echo [ERROR] Visual Studio Code is not installed or can't be found.
    exit /b 1
)

:: This tells .NET Core to use the same dotnet.exe that build scripts use
SET DOTNET_ROOT=%~dp0.dotnet
SET DOTNET_ROOT(x86)=%~dp0.dotnet\x86

:: Put our local dotnet.exe on PATH first so Visual Studio knows which one to use
SET PATH=%DOTNET_ROOT%;%PATH%

IF NOT EXIST "%DOTNET_ROOT%\dotnet.exe" (
    echo [ERROR] .NET has not yet been installed. Run `%~dp0restore.cmd` to install tools
    exit /b 1
)

"%vscode%" "."