
# Fun Programming

In this repository you can find:

- Programs written for the [Fun Programming](https://funprogramming.org) video
  tutorials: [fun-programming](https://github.com/hamoid/Fun-Programming/tree/master/processing/fun-programming)
- My creative coding experiments: [processing/ideas](https://github.com/hamoid/Fun-Programming/tree/master/processing/ideas).
  These are not finished work but tests I do while developing a project or experiments done just for fun and out of curiosity.
  Index below. You can view some results at https://hamoid.com and at http://hamoid.tumblr.com/archive

Most programs here are written using [Processing](http://www.processing.org/).
Some with [SuperCollider](https://supercollider.github.io/).
They are great for creating static / animated / interactive graphics and sound synthesis.

My current tools include [OPENRNDR](https://openrndr.discourse.group/t/doodles-wall-c/51/3) and [GLSL](https://hamoid.com/post/in-the-mood-for-shaders/).

| ⠏ | ⠑ | ⠁ | ⠉ | ⠑ |
| --- | --- | --- | --- | --- |
| [uhmans<br><img src="processing/ideas/2006/04/uhmans/.thumb.jpg" title=" The oldest Processing sketch in my collection, from 22.04.2006.  It represents humans colectives. They feel good when there is enough distance. When they are too close there is conflict.  One of the first times I used object oriented code. I remember it feeling quite strange :) I was probably using https://github.com/processing/processing/releases/tag/processing-0112   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2006/04/uhmans/) <br><sub>animation, concept</sub> | [bezier Fish<br><img src="processing/ideas/2011/05/bezierFish/.thumb.jpg" title=" A program originally written in ActionScript (Flash) approximately in year 2000. This used to be my homepage for a while. Ported to Processing in 2011. One of my first sketches.  It draws animated bezier curves in which start, end and control points follow different bezier curves themselves.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/05/bezierFish/) <br><sub>line</sub> | [noise line<br><img src="processing/ideas/2011/08/noise_line/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/08/noise_line/) <br><sub>animation</sub> | [translate rotate<br><img src="processing/ideas/2011/08/translate_rotate/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/08/translate_rotate/)  | [noise is centered<br><img src="processing/ideas/2011/09/noise_is_centered/.thumb.jpg" title=" The blue line shows that noise spends most of the time at the center (near the value 0.5). Rarely, if ever, it will go to the top or to the bottom.  This is an attempt to fix that. We modify the noise value (n) in a way that the whole range of values is covered: from 0 to 1.  One drawback with this formula is that it's not continuous. It can disappear on the top and then appear on the bottom.  The red line shows the modified noise value.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/09/noise_is_centered/) <br><sub>test</sub>  |
| [sine acid<br><img src="processing/ideas/2011/09/sine_acid/.thumb.jpg" title=" Set the color of every pixel on the window based on multiple `sin()` operations applied to the position of the pixel.  This is the kind of programs I used to write in the 90s :-)  Animated. Uses time in the formulas to have an ever changing effect.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/09/sine_acid/)  | [sine rainbow<br><img src="processing/ideas/2011/09/sine_rainbow/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/09/sine_rainbow/)  | [sinecosine<br><img src="processing/ideas/2011/10/sinecosine/.thumb.jpg" title=" &quot;Spirograph&quot;, &quot;String art&quot; or &quot;pin and thread art&quot;?  Rotate two points around the center at different speeds. Connect the two points with a line of varying color.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/10/sinecosine/)  | [sinecosine2<br><img src="processing/ideas/2011/10/sinecosine2/.thumb.jpg" title=" &quot;Spirograph&quot;, &quot;String art&quot; or &quot;pin and thread art&quot;?  Rotate two points around the center at different speeds. Connect the two points with a line of varying color.  ``` mouse click = restart hold [space] for fade out [s] to save  ```    ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2011/10/sinecosine2/)  | [inf bezier<br><img src="processing/ideas/2012/02/inf_bezier/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/02/inf_bezier/) <br><sub>line</sub>  |
| [blob<br><img src="processing/ideas/2012/04/blob/.thumb.jpg" title=" In this sketch I test `curveVertex`  Notice that three Vertices are drawn twice to make it a closed shape.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/04/blob/) <br><sub>animation</sub> | [random vs noise<br><img src="processing/ideas/2012/04/random_vs_noise/.thumb.jpg" title=" This program studies what happens when you use `noise()` or `random()` to define the hue component of a color.  `random()` covers the whole spectrum and you get all kinds of hues.  `noise()` does not cover the whole spectrum. Reds, oranges and yellows are missing.  `snoise()`, a custom function, tries to improve this by stretching the `noise()` values. But red is still missing.  `anoise()` wraps values around `noise()` 10 times to avoid bias towards one color   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/04/random_vs_noise/) <br><sub>test</sub> | [spline<br><img src="processing/ideas/2012/04/spline/.thumb.jpg" title=" Attempt to create a keyframe animation system with smooth transitions.  This version correctly passes keyframe locations at the right time, but there is an abrupt speed change when passing keyframes if the duration of the last and the next segment greatly differs.  I tried calculating the segment density (hack, I know) and then adjusting the control point distances to try to counteract the sudden speed changes. Not good :)  Next attempt should use Catmull-Rom spline curves.  Ideas: create Timeline class that contains Segment objects, current segment, current Timeline-time, Segment-time.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/04/spline/) <br><sub>animation</sub> | [walking cube<br><img src="processing/ideas/2012/04/walking_cube/.thumb.jpg" title=" The goal of this sketch is to calculate the right vertical position of a cube (or a square) when it &quot;walks&quot; (rotates) forward and backwards on a hard surface.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/04/walking_cube/) <br><sub>animation, camera</sub> | [living Blob<br><img src="processing/ideas/2012/05/livingBlob/.thumb.jpg" title=" Variation from the sketch &quot;blob&quot; from April 2012.  It uses a texture. Unfortunately it lost its &quot;blobiness&quot; because `curveVertex()` does not implement uv coordinates for using textures, so I switched to `vertex()`.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/05/livingBlob/) <br><sub>animation, texture</sub>  |
| [dragworld<br><img src="processing/ideas/2012/06/dragworld/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2012/06/dragworld/) <br><sub>interactive</sub> | [Arduino178Children<br><img src="processing/ideas/2013/01/Arduino178Children/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/01/Arduino178Children/) <br><sub>arduino</sub> | [BWJoy<br><img src="processing/ideas/2013/02/BWJoy/.thumb.jpg" title=" Grayscale variation of my sketch called ColorJoy.  Draw vertical lines covering the whole screen. The brightness of each depends on time, `noise()` and calls to `sin()`.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/02/BWJoy/) <br><sub>animation</sub> | [Barycentric Triangle Mapping<br><img src="processing/ideas/2013/02/BarycentricTriangleMapping/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/02/BarycentricTriangleMapping/) <br><sub>geometry</sub> | [Color Joy<br><img src="processing/ideas/2013/02/ColorJoy/.thumb.jpg" title=" Vertical lines covering the whole screen. Their hues depend on the sine of `noise()` of time.  See it live at [hamoid.com](https://hamoid.com/code/2013-colorjoy/)   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/02/ColorJoy/) <br><sub>animation</sub>  |
| [Melt Writer<br><img src="processing/ideas/2013/02/MeltWriter/.thumb.jpg" title=" Interactive wet paint simulation experiment. Uses the pixel array. A more efficient approach would use shaders instead.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/02/MeltWriter/) <br><sub>interactive, paint</sub> | [Rotation Continuity<br><img src="processing/ideas/2013/02/RotationContinuity/.thumb.jpg" title=" Create animated patterns by drawing a very long line on the surface of a sphere.  A video of it in [YouTube](https://www.youtube.com/watch?v=AmTHjBQc37Y).   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/02/RotationContinuity/) <br><sub>animation, line</sub> | [words To Shapes<br><img src="processing/ideas/2013/06/wordsToShapes/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/06/wordsToShapes/) <br><sub>interactive, line</sub> | [upload Image<br><img src="processing/ideas/2013/07/uploadImage/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/07/uploadImage/) <br><sub>php</sub> | [Change Var By Name](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/08/ChangeVarByName/) <br><sub>reflection</sub>  |
| [p5tweets<br><img src="processing/ideas/2013/08/p5tweets/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/08/p5tweets/) <br><sub>challenge</sub> | [gif Anim One<br><img src="processing/ideas/2013/10/gifAnimOne/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/10/gifAnimOne/) <br><sub>loop</sub> | [anim Gif Mountains<br><img src="processing/ideas/2013/11/animGifMountains/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/11/animGifMountains/) <br><sub>loop</sub> | [fade With Shader<br><img src="processing/ideas/2013/11/fadeWithShader/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/11/fadeWithShader/) <br><sub>shader</sub> | [image Distorts Image<br><img src="processing/ideas/2013/11/imageDistortsImage/.thumb.jpg" title="  ``` Loads random images from two folders (please configure) to act as textures for painting strokes. The brush size modulates with time.  How I use it: I paint a stroke, if I don't like it, press 'u' to undo, try again. Get into the rhythm. Wait until the stroke paints thin or thick. Observe. Press [SPACE] to change paint colors. Embrace the unpredictable.  Key shortcuts: [DELETE] clears the screen 's'      saves image in TIF format 'u'      undo last stroke [SPACE]  load new random images  Mouse Left mouse button drag to paint a stroke Light mouse button drag to paint darker ```   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/11/imageDistortsImage/) <br><sub>interactive, paint</sub>  |
| [client](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/11/prettyDecentDisplay/client/)  | [server](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/11/prettyDecentDisplay/server/)  | [stm<br><img src="processing/ideas/2013/11/stm/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/11/stm/) <br><sub>dataviz</sub> | [gears<br><img src="processing/ideas/2013/12/gears/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/12/gears/) <br><sub>loop</sub> | [happyeoy<br><img src="processing/ideas/2013/12/happyeoy/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/12/happyeoy/) <br><sub>loop</sub>  |
| [sine Bass Sequence](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/12/sineBassSequence/)  | [sine Bass Sequence](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/12/sineBassSequence/)  | [sparkling Text<br><img src="processing/ideas/2013/12/sparklingText/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/12/sparklingText/) <br><sub>loop, particles</sub> | [text Randomizer<br><img src="processing/ideas/2013/12/textRandomizer/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2013/12/textRandomizer/)  | [avoid<br><img src="processing/ideas/2014/01/avoid/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/01/avoid/) <br><sub>animation, line</sub>  |
| [drawing With Undo Redo<br><img src="processing/ideas/2014/01/drawingWithUndoRedo/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/01/drawingWithUndoRedo/) <br><sub>interactive</sub> | [undo<br><img src="processing/ideas/2014/01/undo/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/01/undo/) <br><sub>interactive</sub> | [text Cloud Rotating<br><img src="processing/ideas/2014/02/textCloudRotating/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/02/textCloudRotating/) <br><sub>animation</sub> | [voronoi<br><img src="processing/ideas/2014/02/voronoi/.thumb.jpg" title=" Testing the Voronoi class from Toxiclibs.  The program creates a voronoi triangle mesh on every animation frame based on 20 points moved by the noise() function.  Then it uses the triangles from that mesh to draw translucent lines and points without clearing the screen which results in a somewhat organic morphing shape.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/02/voronoi/) <br><sub>trails</sub> | [long Gif Anim Loop<br><img src="processing/ideas/2014/03/longGifAnimLoop/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/03/longGifAnimLoop/) <br><sub>loop</sub>  |
| [lossy jpg<br><img src="processing/ideas/2014/03/lossy_jpg/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/03/lossy_jpg/) <br><sub>test</sub> | [revolving<br><img src="processing/ideas/2014/03/revolving/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/03/revolving/) <br><sub>depth, loop</sub> | [noise Add<br><img src="processing/ideas/2014/04/noiseAdd/.thumb.jpg" title=" Draw pixels based on noise at different scales to have both small details and large areas of color. Contrast of  size.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/04/noiseAdd/)  | [rings Cleaner<br><img src="processing/ideas/2014/04/ringsCleaner/.thumb.jpg" title=" Simple rings painted with circles.  Trying to have objects that are simultaneously in front and behind others, as by default objects are either in front or behind.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/04/ringsCleaner/) <br><sub>depth</sub> | [rings Shadow<br><img src="processing/ideas/2014/04/ringsShadow/.thumb.jpg" title=" Rings, shadow attempt  Trying to have objects that are simultaneously in front and behind others, as by default objects are either in front or behind.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/04/ringsShadow/) <br><sub>depth</sub>  |
| [rings Which Is Closer<br><img src="processing/ideas/2014/04/ringsWhichIsCloser/.thumb.jpg" title=" Simple rings made out of rectangles.  Trying to have objects that are simultaneously in front and behind others, as by default objects are either in front or behind.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/04/ringsWhichIsCloser/) <br><sub>depth</sub> | [tank Wheels<br><img src="processing/ideas/2014/04/tankWheels/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/04/tankWheels/) <br><sub>loop</sub> | [Terrain<br><img src="processing/ideas/2014/05/Terrain/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/05/Terrain/)  | [rings Blend Mode<br><img src="processing/ideas/2014/05/ringsBlendMode/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/05/ringsBlendMode/) <br><sub>depth</sub> | [two Diff Reactions To OSCmsgs](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/05/twoDiffReactionsToOSCmsgs/)   |
| [pshape Vs Toxic<br><img src="processing/ideas/2014/06/pshapeVsToxic/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/06/pshapeVsToxic/) <br><sub>test, performance</sub> | [envelope<br><img src="processing/ideas/2014/07/envelope/.thumb.jpg" title=" Shows the use of an Envelope class. It's goal is to animate a value over time. One can specify any number of values and durations of the transitions between those values. Values are interpolated with easeInOutQuad. It's possible to specify the number of repetitions of the sequence.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/07/envelope/)  | [envelope Test<br><img src="processing/ideas/2014/07/envelopeTest/.thumb.jpg" title=" Shows the use of an Envelope class. It's goal is to animate a value over time. One can specify any number of values and durations of the transitions between those values. Values are interpolated with easeInOutQuad. It's possible to specify the number of repetitions of the sequence.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/07/envelopeTest/)  | [avoid garbage collection](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/08/avoid_garbage_collection/) <br><sub>test</sub> | [erase Black Pixels<br><img src="processing/ideas/2014/09/eraseBlackPixels/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/09/eraseBlackPixels/) <br><sub>test</sub>  |
| [erase Black Pixels Lookup<br><img src="processing/ideas/2014/09/eraseBlackPixelsLookup/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/09/eraseBlackPixelsLookup/) <br><sub>test</sub> | [key Pressed Var Vs Func](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/10/keyPressedVarVsFunc/) <br><sub>test</sub> | [oral Description Error<br><img src="processing/ideas/2014/10/oralDescriptionError/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/10/oralDescriptionError/)  | [oral Description Game<br><img src="processing/ideas/2014/10/oralDescriptionGame/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/10/oralDescriptionGame/) <br><sub>line, loop</sub> | [loop Of Random Items<br><img src="processing/ideas/2014/11/loopOfRandomItems/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/11/loopOfRandomItems/) <br><sub>loop</sub>  |
| [thousand Rects<br><img src="processing/ideas/2014/11/thousandRects/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2014/11/thousandRects/) <br><sub>trails</sub> | [boxes Are Light<br><img src="processing/ideas/2015/01/boxesAreLight/.thumb.jpg" title=" This program uses two libraries: Peasycam and https://github.com/nervoussystem/OBJExport  Usage:  - Click and drag the mouse to rotate the camera. Mousewheel to zoom it/out. - Press [space] to save the current camera orientation to a file called `camera.ser`. This file will be loaded when starting the program again. - Press [e] to export `boxesAreLight.obj` to disk - Press [r] to randomize the shape - Press [s] to save the view to `thumb.jpg`  The program in action:   The exported .obj file rendered with Blender   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/01/boxesAreLight/)  | [recursive Boxes<br><img src="processing/ideas/2015/01/recursiveBoxes/.thumb.jpg" title=" A tiny program that creates complexity via recursion. It exports an .obj file that I rendered using Blender.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/01/recursiveBoxes/) <br><sub>recursive</sub> | [stream To FFMPEG](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/01/streamToFFMPEG/)  | [CCGame Iterate001<br><img src="processing/ideas/2015/02/CCGame_Iterate001/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/02/CCGame_Iterate001/)   |
| [scan Line Flood<br><img src="processing/ideas/2015/02/scanLineFlood/.thumb.jpg" title=" A naive approach for filling closed shapes pixel by pixel.  Interactive. Click on the screen to fill an area.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/02/scanLineFlood/) <br><sub>interactive, test</sub> | [gradient<br><img src="processing/ideas/2015/03/gradient/.thumb.jpg" title=" Creating a simple gradient texture by coloring pixels. To be used as a gradient in other sketches.  (I didn't know how to do this with shaders at the time)   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/03/gradient/)  | [gradient Polygon<br><img src="processing/ideas/2015/03/gradientPolygon/.thumb.jpg" title=" Making use of a generated gradient texture in polygons. I align the texture to the longest edge of the polygon.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/03/gradientPolygon/) <br><sub>texture</sub> | [ellipso rect<br><img src="processing/ideas/2015/06/ellipso_rect/.thumb.jpg" title=" Animated loop based on code by Jerome Herr at http://p5art.tumblr.com/post/120693457458/ellipsorect-code  I made it bouncy and added particles.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/ellipso_rect/) <br><sub>animation, loop, particles</sub> | [grid of combinations<br><img src="processing/ideas/2015/06/grid_of_combinations/.thumb.jpg" title=" A sketch I made for showing the students at FH Potsdam.  Draws a grid of overlapping rectangles, blurs it, draws it again. That achieves some kind of bloom effect. Uses a limited color palette.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/grid_of_combinations/) <br><sub>grid</sub>  |
| [grid of combinations rot<br><img src="processing/ideas/2015/06/grid_of_combinations_rot/.thumb.jpg" title=" A sketch I made for showing the students at FH Potsdam.  Draws a grid of overlapping rotated triangles, blurs it, draws it again. That achieves some kind of bloom effect. Uses a limited color palette.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/grid_of_combinations_rot/) <br><sub>grid</sub> | [impossiboligon<br><img src="processing/ideas/2015/06/impossiboligon/.thumb.jpg" title=" Produces an animated loop cycling through rotating extruded polygons of 3, 4, 5 and 100 sides.  The properties of the polygons are set manually (instead of mathematically) so they match visually. I cared more about getting it done than about the nobel prize.    ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/impossiboligon/) <br><sub>loop</sub> | [lacuna Noise Logo<br><img src="processing/ideas/2015/06/lacunaNoiseLogo/.thumb.jpg" title=" Animated cow texture using value noise. There was a time when we opened Lacuna Lab we wanted to have animated logos in the home page. This was an experiment that went nowhere :)  Maybe interesting to point out is the third argument used in noise. It could be only `frameCount * 0.01` but that produces an ugly rythmical pattern typical in the noise in Processing, so what I did was to offset that time by the distance to the center of the screen. This avoids all pixels pausing simultaneously and create some kind of unnoticeable pause-wave instead.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/lacunaNoiseLogo/) <br><sub>animation</sub> | [recursive Tree<br><img src="processing/ideas/2015/06/recursiveTree/.thumb.jpg" title=" Draws an animated loop of an aggresive generative tree.  Not meant for real time consumption but for producing an animated GIF file.  The [space] key randomizes the seed to produce different looking trees.    ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/recursiveTree/) <br><sub>loop, recursive</sub> | [recursive lines<br><img src="processing/ideas/2015/06/recursive_lines/.thumb.jpg" title=" I like creating depth by having parts of an image blurry and other parts sharp.  In this case, when the mouse is pressed, the screen is blurred by 1 pixel and covered with a translucent layer of orange, making previously drawn shapes become slightly &quot;lost in fog&quot;, blurred and blended with the background.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/recursive_lines/) <br><sub>recursive</sub>  |
| [the Look Of Noise<br><img src="processing/ideas/2015/06/theLookOfNoise/.thumb.jpg" title=" Draws closed shapes either with ADD or SUBTRACT blend modes. The shape drawn is a circle passed through noise(). Since circles are closed, whatever comes out of noise is also closed. By including time in the noise call the shape moves in the screen.  The `z` key zooms in and blurs. Use it for creating depth. The `a` key sets ADD mode, `o` sets SUBTRACT.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/theLookOfNoise/) <br><sub>animation, noise, trails</sub> | [the Look Of Noise Flat<br><img src="processing/ideas/2015/06/theLookOfNoiseFlat/.thumb.jpg" title=" Draws closed shapes by passing the points of a circle through the `noise()` function.  That value is used as the variable radius of circular shape. The radius decreases over time, so we can draw smaller and smaller shapes as time passes, with the goal of covering the screen, first with large shapes and at the end very small ones.  The colors are read from random photographs found in a folder.  Press `z` during the drawing to blur previous shapes, `[space]` to load a new image for color sampling.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/theLookOfNoiseFlat/) <br><sub>animation</sub> | [we<br><img src="processing/ideas/2015/06/we/.thumb.jpg" title=" Draw a grid by drawing a set of vertical and horizontal lines. Those lines are distorted by using noise. The lines are actually drawn with blend mode ADD in 3 passes, one for red, one for green and one for blue. Each of those passes is slightly offset in the noise space, producing chromatic aberration.  A black and white image is generated with the word &quot;we&quot;. Later the pixels of that image are sampled to decide how bright the R, G and B colors should be, making the word appear in the rendered grid.  Press the `[space]` key to try again with a different seed.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/06/we/) <br><sub>grid</sub> | [noise Contours<br><img src="processing/ideas/2015/09/noiseContours/.thumb.jpg" title=" Creates a noise based quantized image, sort of an elevation-map in black and white. Then applies openCV contours to that image to get vector outlines of the shapes. It sorts them by size to first draw the larger ones, then the smaller ones (otherwise small ones would be occluded by larger ones).  Uses the openCV library from https://github.com/cansik/opencv-processing/releases as the official one is not working (April 14th, 2020)    ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/09/noiseContours/) <br><sub>noise, opencv</sub> | [noise Dir Quantized<br><img src="processing/ideas/2015/09/noiseDirQuantized/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/09/noiseDirQuantized/) <br><sub>line, trails</sub>  |
| [radial hex<br><img src="processing/ideas/2015/09/radial_hex/.thumb.jpg" title=" Program that draws glowing curves quantized to 6 possible angles, producing hexagonal shapes.  Mouse click to set the center of rotation.  [space] to clear  's' to save  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/09/radial_hex/) <br><sub>interactive, line, trails</sub> | [particles Noise<br><img src="processing/ideas/2015/12/particlesNoise/.thumb.jpg" title=" Using the Nature of Code's Vehicle class, draw a number of particles leaving traces on the screen. They move flocking, avoiding each other.  The drawn lines change opacity, thickness and brightness.    ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2015/12/particlesNoise/) <br><sub>flocking, line, natureofcode, trails</sub> | [caustic<br><img src="processing/ideas/2016/02/caustic/.thumb.jpg" title=" Trying to simulate the light at the bottom of the swimming pool.  I treat the the `noise()` value of locations on the screen as their elevation (the elevation of the water moving up and down).  The difference in elevation of a location and the surrounding locations gives the inclination of the water at that point. This inclination refracts the light of ray in certain direction, increasing the brightness at that point.  Slow. Non real-time. A shader could easily do this in real time.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2016/02/caustic/) <br><sub>static, refraction, light</sub> | [Lewitt Drawing](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2016/05/LewittDrawing/)  | [Lewitt Drawing Server](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2016/05/LewittDrawingServer/)   |
| [non overlapping circles using arrays<br><img src="processing/ideas/2016/07/non_overlapping_circles_using_arrays/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2016/07/non_overlapping_circles_using_arrays/)  | [pipe Process Input<br><img src="processing/ideas/2016/07/pipeProcessInput/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2016/07/pipeProcessInput/) <br><sub>viz</sub> | [two circles line tangents<br><img src="processing/ideas/2016/07/two_circles_line_tangents/.thumb.jpg" title=" Interactive program showing the tangent lines that connect two circles.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2016/07/two_circles_line_tangents/)  | [copycat<br><img src="processing/ideas/2017/01/copycat/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/01/copycat/)  | [Midi Viz<br><img src="processing/ideas/2017/04/MidiViz/.thumb.jpg" title=" I wrote this program to play midi files and visualize the channels, notes and velocities.  There are thousands of files online in `.mid` format. I think it's quite an interesting source of data. We often try to get information out of sound using FFT, but that's a very limited approach which doesn't give us the chords and simultaneous notes being played.  Of course using MIDI has its own limitations. For instance, you don't know if the synths being played have short or long decay, so it can be hard to visualize decaying sounds with precision.  In any case, fun to play with I think.  If you create anything with it, I would be happy if you link it at https://forum.processing.org/two/discussion/comment/116764 for others to see.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/04/MidiViz/) <br><sub>midi, shader, viz</sub>  |
| [extract Audio With Ffmpeg<br><img src="processing/ideas/2017/05/extractAudioWithFfmpeg/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/05/extractAudioWithFfmpeg/)  | [hsluv<br><img src="processing/ideas/2017/05/hsluv/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/05/hsluv/) <br><sub>color</sub> | [kaleidoscope<br><img src="processing/ideas/2017/05/kaleidoscope/.thumb.jpg" title=" Shader based polar-coordinates effect applied to video playback.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/05/kaleidoscope/)  | [plot3Dfor Jerome<br><img src="processing/ideas/2017/05/plot3DforJerome/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/05/plot3DforJerome/) <br><sub>static</sub> | [plot3Dorganic<br><img src="processing/ideas/2017/05/plot3Dorganic/.thumb.jpg" title=" A sketch that draws a huge number of lines of various lengths and colors all starting from the same position is space.  Press [space] to trigger a render, [s] to save the resulting image.  These images were all created with this program by slightly changing the formula.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/05/plot3Dorganic/) <br><sub>line, static</sub>  |
| [lineshader<br><img src="processing/ideas/2017/08/lineshader/.thumb.jpg" title=" Modified Line Shader giving it variable width.  Note that it only uses ellipse to draw circles. Comment out the line starting with `shader(` to observe the default rendering.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/08/lineshader/) <br><sub>line, shader</sub> | [lineshader2<br><img src="processing/ideas/2017/08/lineshader2/.thumb.jpg" title=" Drawing lines of variable stroke-weight with a shader.  The shader is mostly the original line shader from Processing with just two little changes: one to make the line width variable, and another to modulate the color so it doesn't look flat.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/08/lineshader2/) <br><sub>animation, line, shader</sub> | [shaded<br><img src="processing/ideas/2017/08/shaded/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/08/shaded/) <br><sub>shader</sub> | [copycat gears<br><img src="processing/ideas/2017/10/copycat_gears/.thumb.jpg" title=" During the Creative Code Jam (Berlin) sometimes we play the copy cat game. Teams describe to each other an animated loop. A describes a loop to B, and B describes a loop to A. Then we code based on the description. Finally we compare the original to the result. A great exercise in observation, description and coding.  [OPENRNDR port](https://github.com/hamoid/openrndr-template/blob/master/src/main/kotlin/apps/copycat_gears.kt)   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/10/copycat_gears/) <br><sub>loop</sub> | [bloom Games<br><img src="processing/ideas/2017/11/bloomGames/.thumb.jpg" title=" Experimenting with shader based post processing using Thomas Diewald's Pixelflow library.  Move the mouse horizontally to control. Start on the right side of the screen then move left.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/11/bloomGames/)   |
| [max Image Saturation<br><img src="processing/ideas/2017/11/maxImageSaturation/.thumb.jpg" title=" Shows images from a folder with maxed out saturation. Just to find out how they look like.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/11/maxImageSaturation/)  | [neighboors<br><img src="processing/ideas/2017/11/neighboors/.thumb.jpg" title=" Some kind of game of incomplete life attempt, version 1   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/11/neighboors/)  | [neighboors2<br><img src="processing/ideas/2017/11/neighboors2/.thumb.jpg" title=" Some kind of game of incomplete life attempt, version 2   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/11/neighboors2/)  | [super Slow Fade Out<br><img src="processing/ideas/2017/11/superSlowFadeOut/.thumb.jpg" title=" A method for fading out the image very slowly. The speed is configurable in pixels per frame. Slowest would be 1 pixel per frame.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/11/superSlowFadeOut/)  | [avoidxmas<br><img src="processing/ideas/2017/12/avoidxmas/.thumb.jpg" title=" Choose a random point in the screen and start drawing a line there. If you are going to collide with an existing line or with the border of the window, turn to avoid that. If there's no way to avoid collision, respawn somewhere else and try again.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/12/avoidxmas/) <br><sub>animation, line</sub>  |
| [avoidxmastree<br><img src="processing/ideas/2017/12/avoidxmastree/.thumb.jpg" title=" Draws a xmas tree by filling a masked space (`bg.png`) with squiggly width-varying lines. The lines grow trying to avoid colliding until they can no longer move forward. At that point it adds a red dot at the beginning of the line.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/12/avoidxmastree/)  | [lineshaderlux<br><img src="processing/ideas/2017/12/lineshaderlux/.thumb.jpg" title=" A bunch of circles moving across the screen. Rendered with a custom shader for variable stroke width and with two PixelFlow effects.  The circles move at non-constant speed, a bit like frogs crossing the road.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2017/12/lineshaderlux/)  | [shader Breaks Sphere<br><img src="processing/ideas/2018/02/shaderBreaksSphere/.thumb.jpg" title=" The sketch uses the sphere purely as data ignoring all matrices (therefore the camera doesn't work). The vertex shader calculates a new position of each vertex based on sines and cosines of the original vertex coordinates.  It also shows how to directly use gl_Position to place things in the window.  It makes use of a ShaderReloader class, based on code by Raphaël de Courville. That class shows an error overlay message when the shader does not compile.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/02/shaderBreaksSphere/) <br><sub>shader</sub> | [shader Scroll Textured<br><img src="processing/ideas/2018/02/shaderScrollTextured/.thumb.jpg" title=" A confusing program doing a lot of stuff :) To start press `[space]`.  There's video playing as a source of texture. It uses noise to draw that texture in symmetrical &quot;butterfly like&quot; shapes.  It uses a flow-style shader to smear the result based on hue.  Then the whole result is partially occluded and seen only through a mask full of words. That mask is loaded from disk, but there's an alternative one generated in real time (commented out). The mask scrolls up as the credits of a movie.  The `[enter]` key jumps to a random location in the movie and randomizes noise seed.  The `s` key is used for starting and ending video export. It calls a command line voice synthesizer to speak `start` and `stop`.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/02/shaderScrollTextured/) <br><sub>shader, video, mask</sub> | [shader Shadow2 svg<br><img src="processing/ideas/2018/02/shaderShadow2_svg/.thumb.jpg" title=" Loads an svg into a PShape, then draws that 255 times in various locations on the screen using a gray scale fill color.  That fill color represents depth and it's used by the shader to know where to draw drop shadows. The shader colorizes each shape using a cosine based palette generator.  This is not necessarily a good idea :) It's just an experiment.  Limited to 255 objects (as buffers in Processing are not floating point based).   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/02/shaderShadow2_svg/) <br><sub>shader</sub>  |
| [fft Frag Shader<br><img src="processing/ideas/2018/03/fftFragShader/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/03/fftFragShader/) <br><sub>shader, fft</sub> | [fft Vert Shader<br><img src="processing/ideas/2018/03/fftVertShader/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/03/fftVertShader/) <br><sub>shader</sub> | [matrix Multiplication<br><img src="processing/ideas/2018/03/matrixMultiplication/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/03/matrixMultiplication/) <br><sub>viz</sub> | [simple Tesselation<br><img src="processing/ideas/2018/03/simpleTesselation/.thumb.jpg" title=" A simple way to tesselate a convex polygon. If we have 7 points defining the contour, then we can create triangles using these vertices: 012, 023, 034, 045, 056.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/03/simpleTesselation/) <br><sub>tesselation</sub> | [viz Img Color Distrib<br><img src="processing/ideas/2018/03/vizImgColorDistrib/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/03/vizImgColorDistrib/) <br><sub>color</sub>  |
| [orthocubes<br><img src="processing/ideas/2018/04/orthocubes/.thumb.jpg" title=" Creates a cloud of cuboids positioned and scaled using `noise()`. The cuboids are shaded with a shader that produces stripes along one axis. The axis is specified as a integer `uniform` between 0 and 2 for each drawn cuboid. You can access a component of a vec3 in a shader by its index, so `pos[0] = pos.x`, `pos[1] = pos.y` and `pos[2] = pos.z`.  Hold down the mouse button to see the effect of `OPTIMIZED_STROKE`. For me the default state of that property in Processing is not the expected one, as `OPTIMIZED_STROKE` produces unwanted side effects when using vertex shaders. If something is not working with your vertex shader I suggest toggling that variable to `ENABLED` and `DISABLED` to see if it has an effect.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/04/orthocubes/) <br><sub>shader</sub> | [lines Flying<br><img src="processing/ideas/2018/05/linesFlying/.thumb.jpg" title=" Written while flying.  Usage: Click. Then click again. Until you get a curve.  It will try to add a curve that starts and ends in previous curves without intersecting them.  Examples painted with Gimp: [one](https://twitter.com/hamoid/status/999749957526663168), [two](https://twitter.com/hamoid/status/999405228729528320).   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/05/linesFlying/) <br><sub>curve, intersection</sub> | [pan Zoom Sketch<br><img src="processing/ideas/2018/08/panZoomSketch/.thumb.jpg" title="  A simple class that allows showing a larger PGraphics in a smaller viewport, pan and zoom using the mouse.  This sketch shows 6 such viewports running simultaneously.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/08/panZoomSketch/) <br><sub>interactive</sub> | [pixelate Shader<br><img src="processing/ideas/2018/08/pixelateShader/.thumb.jpg" title=" Very minimal shader to pixelate your rendering. Allows setting the resolution using a uniform.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/08/pixelateShader/) <br><sub>shader</sub> | [rot Cube Gradient<br><img src="processing/ideas/2018/09/rotCubeGradient/.thumb.jpg" title=" Painting with the color of lights instead of using fill colors.  The reason to do that is to achieve more depth by painting with gradients instead of flat colors.  Light positions rotate smoothly but with regular jumps to create colors patterns in the drawn cubes.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/09/rotCubeGradient/) <br><sub>trails</sub>  |
| [copycat Split Triangle<br><img src="processing/ideas/2018/10/copycatSplitTriangle/.thumb.jpg" title="">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/10/copycatSplitTriangle/) <br><sub>animation, loop</sub> | [measure Dropped Frames<br><img src="processing/ideas/2018/10/measureDroppedFrames/.thumb.jpg" title=" An attempt to measure dropped frames. At 60 frames per second we have 16.666 milliseconds to draw everything to our canvas. If it takes longer than that we will be late and the graphics will only make it to the next frame.  With something moving on the screen at constant speed it becomes obvious and disturbing if an animation frame is missing. It feels like a sudden jump.  What I measure in this program is how often draw() gets called, which is not the same as dropped frames. Even if often it takes more than 17 milliseconds for draw() to be called again, there's no visible jump in the screen.  The jumps become obvious when that delay goes about 20 milliseconds.  There seems to be a big drop in my system always at 45 seconds after starting the program.  In Java2D the frequency is much more irregular than in P2D / P3D.  Interacting with any other application while the program runs produces timing irregularities. I have not noticed this in openFrameworks. The animation often feels smoother in the C++ based framework.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/10/measureDroppedFrames/) <br><sub>animation, test, fps</sub> | [spinning Cube Rainbow<br><img src="processing/ideas/2018/10/spinningCubeRainbow/.thumb.jpg" title=" Slowly rotating 3D cubes painting on a black background. A black translucent line connecting the two cubes compensates by subtracting light from the result.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/10/spinningCubeRainbow/) <br><sub>trails</sub> | [transparency Test PShape<br><img src="processing/ideas/2018/10/transparencyTestPShape/.thumb.jpg" title=" Test transparency in P3D mode with the hints `DISABLE_DEPTH_TEST`, `DISABLE_DEPTH_SORT` and `DISABLE_DEPTH_MASK`.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/10/transparencyTestPShape/) <br><sub>interactive, transparency, hint, test</sub> | [Envelope Grid Test<br><img src="processing/ideas/2018/11/EnvelopeGridTest/.thumb.jpg" title=" A grid version of my envelope class. It is used for animating collections of items simultaneously but with different delays.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/11/EnvelopeGridTest/) <br><sub>animation</sub>  |
| [Flowers<br><img src="processing/ideas/2018/11/Flowers/.thumb.jpg" title=" Generate animated flowers when pressing the `space` key. Press `s` to save an image.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/11/Flowers/) <br><sub>animation</sub> | [line Normals<br><img src="processing/ideas/2018/11/lineNormals/.thumb.jpg" title=" Shows how to convert a line strip into a mesh version of the same line strip but with random thicknes per-vertex. Like switching from a thin pen to an ink-brush.  Here two animated versions in p5.js: [one](https://www.openprocessing.org/sketch/632717) and [two](https://www.openprocessing.org/sketch/675134)  And a version in [OPENRNDR](https://github.com/hamoid/openrndr-template/blob/master/src/main/kotlin/p5/p07_lineNormals.kt)   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/11/lineNormals/) <br><sub>geometry, line, normals, pshape, pvector</sub> | [ping Pong Shader<br><img src="processing/ideas/2018/11/pingPongShader/.thumb.jpg" title=" In this sketch I apply horizontal blur and vertical blur multiple times.  It uses something called ping pong buffers. Basically: I draw on buffer A, then draw a horizontally blurred version to buffer B, then draw that one blurred vertically back on buffer A, draw some more stuff on it and repeat.  I blur R, G and B channels slightly differently to produce some kind of chromatic aberration.  Having sharp and blurred objects creates depth.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2018/11/pingPongShader/) <br><sub>animation, blur, shader</sub> | [bidirectional Perlin Noise<br><img src="processing/ideas/2019/01/bidirectionalPerlinNoise/.thumb.jpg" title=" Noise field. A typical effect is sampling a noise field by using the current pixel coordinates then interpreting the obtained value as an angle to move to a nearby pixel, and keep repeating that operation. The resulting image resembles somewhat roots or branches: lines that converge.  In this case I repeat the process twice, the second time inverting the displacement sign. So for the starting point I obtain two lines instead of one, and they go in exactly opposing directions. The difference is that it looks less like branches or roots because one can not see the beginning of those brances or roots. It's like connecting the branches of two trees together, each branch connecting with a branch in the other tree.  Try changing the sigmoid value between 0.0 and 1.0 for different looks.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/01/bidirectionalPerlinNoise/) <br><sub>test</sub> | [bump In Circle<br><img src="processing/ideas/2019/01/bumpInCircle/.thumb.jpg" title=" Draws circles with a bump. The bump is located at an angle defined by the variable `high`. The width of the bump is defined by `overlap`, which is modulated over time to make it more dynamic, while using an offset so not all circles are wide or narrow at the same time, but in sequence instead.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/01/bumpInCircle/) <br><sub>animation</sub>  |
| [click To Erase<br><img src="processing/ideas/2019/01/clickToErase/.thumb.jpg" title=" A program that draws two layers and allows the user to interactively erase the top layer by dragging the mouse while holding the left mouse button down.  It shows an issue with [linear gamma color space](https://ninedegreesbelow.com/photography/test-for-linear-processing.html#painting)   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/01/clickToErase/) <br><sub>blend, gamma, interactive, trails</sub> | [circular Gradients<br><img src="processing/ideas/2019/04/circularGradients/.thumb.jpg" title=" Draw a grid of squares covering the window. The color of each square is chosen randomly from a list of colors. The squares are shaded with a circular gradient, implemented in a shader. Then a &quot;tornado&quot; effect is applied to the center of the window, deforming the squares.  There's an artifact when curving some lines that I later [solved](https://creativecodeberlin.github.io/Stammtisch/2019/05/03/ccs061.html) when porting this program to OPENRNDR.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/04/circularGradients/) <br><sub>shader</sub> | [following2D<br><img src="processing/ideas/2019/04/following2D/.thumb.jpg" title=" A simple class for an object to follow a 2D target and reduce speed when getting near. If the target changes location suddenly the moving object turns towards the new target smoothly.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/04/following2D/) <br><sub>animation, physics, target</sub> | [gradient With Vertex<br><img src="processing/ideas/2019/04/gradientWithVertex/.thumb.jpg" title=" Draw a grid of rectangles covering the screen and maintaining a margin between rectangles and the borders of the window.  The recangles are filled with a gradient and also have a gradient stroke. This is achieved by setting the fill and stroke colors before each call to `vertex()`.  A better approach to gradients is by using shaders, as this technique does not allow rotating the gradient and is heavily influenced by the number of vertices and their order.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/04/gradientWithVertex/) <br><sub>static, gradient, grid, margin</sub> | [variable Thickness Lines<br><img src="processing/ideas/2019/04/variableThicknessLines/.thumb.jpg" title=" Shader based line drawing that produces lines that go from zero strokeWeight to full strokeWeight and back to zero. The program allows reloading the shader by pressing '0', and loading other shaders (if they were present) by pressing other number keys.  Press `r` to randomize, `s` to save.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/04/variableThicknessLines/) <br><sub>line, shader</sub>  |
| [Thick Line Test<br><img src="processing/ideas/2019/06/ThickLineTest/.thumb.jpg" title=" A class for drawing pShape-based lines of variable thickness. The lines are made out of 4D points: x, y for position, z for depth and w for thickness. The program exports an .obj file when pressing the `s` key.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/06/ThickLineTest/) <br><sub>depth, line, obj, pshape, static</sub> | [crosses<br><img src="processing/ideas/2019/06/crosses/.thumb.jpg" title=" A program to generate the cover for the [Creative Code Stammtisch 62](https://creativecodeberlin.github.io/Stammtisch/2019/06/07/ccs062.html). Uses 3 point lights to create color gradients. Uses an exponential distribution so there are few large shapes and many small ones.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/06/crosses/) <br><sub>static</sub> | [Shader Texture Cube<br><img src="processing/ideas/2019/08/ShaderTextureCube/.thumb.jpg" title=" Simple shader-based generative texture applied to a rotating 3D cube.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/08/ShaderTextureCube/) <br><sub>shader</sub> | [bezier similarity<br><img src="processing/ideas/2019/09/bezier_similarity/.thumb.jpg" title=" A mildly interactive sketch. The mouseX position sets the length of the drawn lines. [space] clears the background.  Lines are drawn starting on a circle, the exact point advancing clockwise. For each line it searches for 3 other nearby points at 3 different distances. It does that by first checking the pixel color on a photo at the spawn location. Then it searches three concentric circles in that photo for the most similar color in that virtual circle.  The spawn point and the 3 found points for the basis for a bezier curve. Instead of drawing that bezier curve directly, it interpolates smoothly towards that bezier curve. It does so to avoid jitter and reduce random jumps.  By coming up with different algorithms for moving the spawn point one can produce different aesthetics.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/09/bezier_similarity/) <br><sub>line, bezier, interactive</sub> | [sin rainbow<br><img src="processing/ideas/2019/09/sin_rainbow/.thumb.jpg" title=" A basic example of how to get all color hues without using the HSB mode. The variable `t` sets the hue. Then R, G and B are calculated based on `t` by using the `sin()` function.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/09/sin_rainbow/) <br><sub>color</sub>  |
| [draw Donut<br><img src="processing/ideas/2019/11/drawDonut/.thumb.jpg" title=" A simple method to create a ring-shaped PShape.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/11/drawDonut/) <br><sub>pshape</sub> | [layer3D<br><img src="processing/ideas/2019/11/layer3D/.thumb.jpg" title=" Shows how to work with an animated 3D layer with transparent background which can be displayed multiple times.  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2019/11/layer3D/) <br><sub>pgraphics</sub> | [forum call method by name<br><img src="processing/ideas/2020/01/forum_call_method_by_name/.thumb.jpg" title=" In the Processing forum it was asked how to call a method by name. Here's one example using reflection.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2020/01/forum_call_method_by_name/) <br><sub>reflection</sub> | [irregular Line Between Two Points<br><img src="processing/ideas/2020/03/irregularLineBetweenTwoPoints/.thumb.jpg" title=" A method to draw an animated noise-bent line between two points.  Also shows how to create a square using polar coordinates. That is, how to get the radius of a square for any given angle.  float r = min(1/abs(cos(ang)), 1/abs(sin(ang)));  ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2020/03/irregularLineBetweenTwoPoints/) <br><sub>geometry, line</sub> | [ray Intersection<br><img src="processing/ideas/2020/04/rayIntersection/.thumb.jpg" title=" Geometry. Find out the intersection of two rays.  A ray has an origin (a location where it starts) and a direction. It goes infinitely in that direction.  Like a laser in perfect vacuum.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2020/04/rayIntersection/) <br><sub>geometry, interactive, intersection, ray</sub>  |
| [line Segment Circle Intersection<br><img src="processing/ideas/2020/05/lineSegmentCircleIntersection/.thumb.jpg" title=" A function to calculate the intersection(s) between a line segment and a circle.   ">](https://github.com/hamoid/Fun-Programming/blob/master/processing/ideas/2020/05/lineSegmentCircleIntersection/) <br><sub>line, geometry, circle, intersection, interactive</sub> 
