/*
 * Decompiled with CFR 0.152.
 */
package com.deitel.jhtp.jpa;

import com.deitel.jhtp.jpa.Addresses;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

public class AddressBookController {
    @FXML
    private ListView<Addresses> listView;
    @FXML
    private TextField firstNameTextField;
    @FXML
    private TextField lastNameTextField;
    @FXML
    private TextField emailTextField;
    @FXML
    private TextField phoneTextField;
    @FXML
    private TextField findByLastNameTextField;
    private final EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"AddressBookPU");
    private final EntityManager entityManager = this.entityManagerFactory.createEntityManager();
    private final ObservableList<Addresses> contactList = FXCollections.observableArrayList();

    public void initialize() {
        this.listView.setItems(this.contactList);
        this.listView.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> this.displayContact((Addresses)newValue));
        this.getAllEntries();
    }

    private void getAllEntries() {
        TypedQuery findAllAddresses = this.entityManager.createNamedQuery("Addresses.findAll", Addresses.class);
        this.contactList.setAll((Collection)findAllAddresses.getResultList());
        this.selectFirstEntry();
    }

    private void selectFirstEntry() {
        this.listView.getSelectionModel().selectFirst();
    }

    private void displayContact(Addresses contact) {
        if (contact != null) {
            this.firstNameTextField.setText(contact.getFirstname());
            this.lastNameTextField.setText(contact.getLastname());
            this.emailTextField.setText(contact.getEmail());
            this.phoneTextField.setText(contact.getPhonenumber());
        } else {
            this.firstNameTextField.clear();
            this.lastNameTextField.clear();
            this.emailTextField.clear();
            this.phoneTextField.clear();
        }
    }

    @FXML
    void addEntryButtonPressed(ActionEvent event) {
        Addresses address = new Addresses();
        address.setFirstname(this.firstNameTextField.getText());
        address.setLastname(this.lastNameTextField.getText());
        address.setPhonenumber(this.phoneTextField.getText());
        address.setEmail(this.emailTextField.getText());
        EntityTransaction transaction = this.entityManager.getTransaction();
        try {
            transaction.begin();
            this.entityManager.persist((Object)address);
            transaction.commit();
            this.displayAlert(Alert.AlertType.INFORMATION, "Entry Added", "New entry successfully added.");
        }
        catch (Exception e) {
            transaction.rollback();
            this.displayAlert(Alert.AlertType.ERROR, "Entry Not Added", "Unable to add entry: " + e);
        }
        this.getAllEntries();
    }

    @FXML
    void findButtonPressed(ActionEvent event) {
        TypedQuery findByLastname = this.entityManager.createNamedQuery("Addresses.findByLastname", Addresses.class);
        findByLastname.setParameter("lastname", (Object)(this.findByLastNameTextField.getText() + "%"));
        List people = findByLastname.getResultList();
        if (people.size() > 0) {
            this.contactList.setAll((Collection)people);
            this.selectFirstEntry();
        } else {
            this.displayAlert(Alert.AlertType.INFORMATION, "Lastname Not Found", "There are no entries with the specified last name.");
        }
    }

    @FXML
    void browseAllButtonPressed(ActionEvent event) {
        this.getAllEntries();
    }

    private void displayAlert(Alert.AlertType type, String title, String message) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setContentText(message);
        alert.showAndWait();
    }
}

