AddCSLuaFile()
DEFINE_BASECLASS( "base_wire_entity" )
ENT.PrintName       = "Wire Numpad Input"
ENT.WireDebugName = "Numpad Input"

if CLIENT then return end -- No more client

//As input.GetKeyName is Clientside only, the following list is generated by:
//lua_run_cl local a="{\"" for k=1, KEY_LAST do a=a..input.GetKeyName(k).."\",\"" end print(string.sub(a,0,-3).."}")
local keylist = {"0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","KP_INS","KP_END","KP_DOWNARROW","KP_PGDN","KP_LEFTARROW","KP_5","KP_RIGHTARROW","KP_HOME","KP_UPARROW","KP_PGUP","KP_SLASH","KP_MULTIPLY","KP_MINUS","KP_PLUS","KP_ENTER","KP_DEL","[","]","SEMICOLON","'","`",",",".","/","\\","-","=","ENTER","SPACE","BACKSPACE","TAB","CAPSLOCK","NUMLOCK","ESCAPE","SCROLLLOCK","INS","DEL","HOME","END","PGUP","PGDN","PAUSE","SHIFT","RSHIFT","ALT","RALT","CTRL","RCTRL","LWIN","RWIN","APP","UPARROW","LEFTARROW","DOWNARROW","RIGHTARROW","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","CAPSLOCKTOGGLE","NUMLOCKTOGGLE","SCROLLLOCKTOGGLE"}
local function keyname(keygroup)
	return keylist[keygroup] or ""
end

function ENT:Initialize()
	self:PhysicsInit( SOLID_VPHYSICS )
	self:SetMoveType( MOVETYPE_VPHYSICS )
	self:SetSolid( SOLID_VPHYSICS )

	// Used to keep track of numpad.OnUp/Down returns
	// Fixes bug where player cannot change numpad key (TheApathetic)
	self.OnUpImpulse = nil
	self.OnDownImpulse = nil

	self.Outputs = Wire_CreateOutputs(self, { "Out" })
end

function ENT:Setup(keygroup, toggle, value_off, value_on)
	self.keygroup = keygroup
	self.toggle = (toggle == 1 or toggle == true)
	self.value_off = value_off
	self.value_on = value_on
	self.Value = value_off

	if (self.OnUpImpulse) then
		numpad.Remove(self.OnUpImpulse)
		numpad.Remove(self.OnDownImpulse)
	end

	local pl = self:GetPlayer()
	self.OnDownImpulse = numpad.OnDown( pl, keygroup, "WireInput_On", self, 1 )
	self.OnUpImpulse = numpad.OnUp( pl, keygroup, "WireInput_Off", self, 1 )


	self:ShowOutput(self.value_off)
	Wire_TriggerOutput(self, "Out", self.value_off)
end

function ENT:InputActivate( mul )
	if ( self.toggle ) then
		return self:Switch( not self.On, mul )
	end

	return self:Switch( true, mul )
end

function ENT:InputDeactivate( mul )
	if ( self.toggle ) then return true end

	return self:Switch( false, mul )
end

function ENT:Switch( on, mul )
	if (not self:IsValid()) then return false end

	self.On = on

	if (on) then
		self:ShowOutput(self.value_on)
		self.Value = self.value_on
	else
		self:ShowOutput(self.value_off)
		self.Value = self.value_off
	end

	Wire_TriggerOutput(self, "Out", self.Value)

	return true
end

function ENT:ShowOutput(value)
	self:SetOverlayText( "("..keyname(self.keygroup)..")\n(" .. tostring(self.value_off) .. " - " .. tostring(self.value_on) .. ") = " .. tostring(value) )
end

local function On( pl, ent, mul )
	if (not ent:IsValid()) then return false end
	if not gamemode.Call("PlayerUse", pl, ent) then return end
	return ent:InputActivate( mul )
end

local function Off( pl, ent, mul )
	if (not ent:IsValid()) then return false end
	if not gamemode.Call("PlayerUse", pl, ent) then return end
	return ent:InputDeactivate( mul )
end

numpad.Register( "WireInput_On", On )
numpad.Register( "WireInput_Off", Off )

duplicator.RegisterEntityClass("gmod_wire_input", WireLib.MakeWireEnt, "Data", "keygroup", "toggle", "value_off", "value_on")
