# Dropzone Action Info
# Name: %service-name%
# Description: This action sends the dropped items to BetterZip to extract them with the preset %preset-name%. When clicked, BetterZip is activated.
# Handles: Files
# Creator: Robert Rezabek
# URL: https://macitbetter.com/
# Events: Clicked, Dragged
# KeyModifiers: Command, Option, Control, Shift
# SkipConfig: Yes
# RunsSandboxed: No
# Version: 1.0
# MinDropzoneVersion: 3.5

require 'cgi'

def dragged
	$dz.determinate(true)
	$dz.percent(0)
	
	isPathParam = ""
	if ENV['dragged_type'] == "files"
		isPathParam = "isPath YES"
	end

	files = ($items.map {|x| CGI.escape(x)} ).join (";")
	
	preset = "%preset-name%"
	system("open \"btrzp://extract/#{preset}?#{files}\"")

	$dz.url(false)
end

def clicked
	%x(open -a BetterZip.app >& /dev/null)
	$dz.url(false)
end

