// <copyright file="adocommand.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for CADOCommand class</summary>
#pragma once

#include "stdafx.h"
#include "adoerror.h"
#include "adoparameter.h"
#include "adoconnection.h"

class CADOCommand : public CADOError
{
private:
	_CommandPtr m_pCommand;		//	ADO Command interface
	_RecordsetPtr m_pRecords;	//	Return recordset pointer
	CString m_szCommand;		//	Command text
	int m_iRecordsAffected;		//	Number of records affected by operation
	long m_lOptions;			//	Options to use on execute

	void Initialize();

public:

	BOOL SetDBConnection(CADOConnection *pDB);
	BOOL SetCommand(CString& szCommand);
	_RecordsetPtr GetReturnedRecordset(){return m_pRecords;}

	void SetOptionToProcedure();
	void SetOptionToCmdText();
	void SetExecuteNoRecords();
	void ClearExecuteNoRecords();


	BOOL AddParameter(CADOParameter *pParam);
	BOOL Reset();
	BOOL Cancel();
	BOOL Execute(CString szCommandString=_T(""), CString szFilter=_T(""));

	CADOCommand(void);
	~CADOCommand(void);
};

/*
Execute Method

Parameters

RecordsAffected		Optional. A Long variable to which the provider returns the number of records that the operation affected. 
					The RecordsAffected parameter applies only for action queries or stored procedures. 
					RecordsAffected does not return the number of records returned by a result-returning query or stored procedure. 
					To obtain this information, use the RecordCount property. The Execute method will not return the correct 
					information when used with adAsyncExecute, simply because when a command is executed asynchronously, the number 
					of records affected may not yet be known at the time the method returns.

Parameters		    Optional. A Variant array of parameter values used in conjunction with the input string or stream specified in 
					CommandText or CommandStream. (Output parameters will not return correct values when passed in this argument.)

Options			    Optional. A Long value that indicates how the provider should evaluate the CommandText or the CommandStream 
					property of the Command object. Can be a bitmask value made using CommandTypeEnum and/or ExecuteOptionEnum values. 
					For example, you could use adCmdText and adExecuteNoRecords in combination if you want to have ADO evaluate the value 
					of the CommandText property as text, and indicate that the command should discard and not return any records that might be generated when the command text executes.

CommandTypeEnum Options

adCmdUnspecified	Does not specify the command type argument.

adCmdText			Evaluates CommandText as a textual definition of a command or stored procedure call.

adCmdTable			Evaluates CommandText as a table name whose columns are all returned by an internally generated SQL query.

adCmdStoredProc		Evaluates CommandText as a stored procedure name.

adCmdUnknown		Default. Indicates that the type of command in the CommandText property is not known.

adCmdFile			Evaluates CommandText as the file name of a persistently stored Recordset. Used with Recordset.Open or Requery only.

adCmdTableDirect	Evaluates CommandText as a table name whose columns are all returned. Used with Recordset.Open or Requery only. 
					To use the Seek method, the Recordset must be opened with adCmdTableDirect.
					This value cannot be combined with the ExecuteOptionEnum value adAsyncExecute.

ExecuteOptionEnum values

adAsyncExecute			Indicates that the command should execute asynchronously.
						This value cannot be combined with the CommandTypeEnum value adCmdTableDirect.

adAsyncFetch			Indicates that the remaining rows after the initial quantity specified in the CacheSize property should be retrieved asynchronously.

adAsyncFetchNonBlocking	Indicates that the main thread never blocks while retrieving. If the requested row has not been retrieved, the current row automatically moves to the end of the file.
						If you open a Recordset from a Stream containing a persistently stored Recordset, adAsyncFetchNonBlocking will not have an effect; the operation will be synchronous and blocking.
						adAsynchFetchNonBlocking has no effect when the adCmdTableDirect option is used to open the Recordset.

adExecuteNoRecords		Indicates that the command text is a command or stored procedure that does not return rows (for example, a command that only inserts data). 
						If any rows are retrieved, they are discarded and not returned.
						adExecuteNoRecords can only be passed as an optional parameter to the Command or Connection Execute method.

adExecuteStream			Indicates that the results of a command execution should be returned as a stream.
						adExecuteStream can only be passed as an optional parameter to the Command Execute method.

adExecuteRecord			Indicates that the CommandText is a command or stored procedure that returns a single row which should be returned as a Record object.

adOptionUnspecified		Indicates that the command is unspecified.


*/