// <copyright file="adoconnection.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for class CADOConnection</summary>

#pragma once
#include "stdafx.h"
#include "adoerror.h"

class CADOConnection : public CADOError
{
private:
	_ConnectionPtr	m_pConnection;
	BOOL	m_bOpen;	//	Flag to indicate whether connection is open or not
	long m_lNestingLevel;
	CString m_szConnectionString;
	CString m_szUser;
	CString m_szPassword;

	void Initialize();
	BOOL SetOrRemoveAttribute(BOOL bMode, long lAttribute);
	long m_lRecordsAffected;

public:
	
	_ConnectionPtr GetConnection(){return m_pConnection;}
	long GetNumberOfRecordsAffected() {return m_lRecordsAffected;}
	void SetUser(CString& szUser){m_szUser = szUser;}
	void SetPassword(CString& szPassword){m_szPassword=szPassword;}
	BOOL SetConnectionTimeout(long lTimeout);
	BOOL SetConnectionString(CString szConnectionString);

	BOOL AbortRetaining(BOOL bMode);
	BOOL CommitRetaining(BOOL bMode);
	long GetNestingLevel(){return m_lNestingLevel;}
	BOOL BeginTransaction();
	BOOL Commit();
	BOOL Rollback();

	BOOL IsClosed(){return !m_bOpen;}
	BOOL IsOpen() {return m_bOpen;}
	BOOL Open(CString szConnectionString, CString szUser=_T(""), CString szPassword=_T(""));
	BOOL Open();
	BOOL Close();
	BOOL Cancel();
	_RecordsetPtr CADOConnection::Execute(CString szCommandString);

	CADOConnection(CString szConnectionString);
	CADOConnection(void);
	~CADOConnection(void);
};
