// <copyright file="adoerror.cpp" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>CADOError class to manage exceptions that occur during ADO operations</summary>
#include "ADOError.h"

////////////////////////////////////////////////////////////////////////////////////////////////////////
CADOError::CADOError(void)
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
CADOError::~CADOError(void)
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
// The following function was from Microsoft support: http://support.microsoft.com/kb/169498
CString CADOError::LogCrackHR( HRESULT hr )
{
      LPVOID  lpMsgBuf;
      CString strTmp;

      ::FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER |
                       FORMAT_MESSAGE_FROM_SYSTEM,
                       NULL,
                       hr,
                       MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                       (LPTSTR) &lpMsgBuf,
                       0,
                       NULL );

        // STR_TMP is defined within LOG.CPP to provide safe format string
        // for both ANSI and UNICODE
        strTmp.Format( "%s", (char *) lpMsgBuf );


      // Free the buffer.
      ::LocalFree( lpMsgBuf );

	  SetLastError(strTmp);
      return strTmp;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
// The following function was from Microsoft support: http://support.microsoft.com/kb/169498
// Obtain information from the Errors Collection.
HRESULT CADOError::LogAdoErrorImport(_ConnectionPtr pConn)
{
   ErrorsPtr   pErrors = NULL;
   ErrorPtr    pError  = NULL;
   CString     strTmp;
   HRESULT     hr = (HRESULT) 0L;
   long        nCount;

   // Don't have an un-handled exception in the handler that
   // handles exceptions!
   try
   {
      pErrors = pConn->GetErrors();

      nCount = pErrors->GetCount();

      for( long i = 0; (!FAILED(hr)) && (i < nCount); i++ )
      {
         TRACE( "\t Dumping ADO Error %d of %d\r\n", i+1, nCount );

         hr = pErrors->get_Item((_variant_t)((long)i), &pError );

         _bstr_t bstrSource     ( pError->GetSource()      );
         _bstr_t bstrDescription( pError->GetDescription() );
         _bstr_t bstrHelpFile   ( pError->GetHelpFile()    );
         _bstr_t bstrSQLState   ( pError->GetSQLState()    );

         TRACE( "\t\t Number      = %ld", pError->GetNumber()       );
         TRACE( "\t\t Source      = %s\r\n",  (LPCTSTR) bstrSource      );
         TRACE( "\t\t Description = %s\r\n",  (LPCTSTR) bstrDescription );
         TRACE( "\t\t HelpFile    = %s",  (LPCTSTR) bstrHelpFile    );
         TRACE( "\t\t HelpContext = %ld\r\n", pError->GetHelpContext()  );
         TRACE( "\t\t SQLState    = %s",  (LPCTSTR) bstrSQLState    );
         TRACE( "\t\t HelpContext = %ld", pError->GetHelpContext()  );
         TRACE( "\t\t NativeError = %ld\r\n", pError->GetNativeError()  );
		 TRACE( "\r\n");
      }
   }
   catch( CException *e )
   {
      TRACE( "*** UNABLE TO LOG EXCEPTION ***" );
      e->Delete();
   }
   catch(...)
   {
      TRACE( "*** UNABLE TO LOG EXCEPTION ***" );
   }

   if( pErrors ) pErrors->Release();
   if( pError  ) pError->Release();

   return hr;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Report an exception that occured during a COM based call
void CADOError::ReportException(_com_error& e)
{
	m_szLastError = (char*)e.Description();
	m_hrLastError = e.Error();
}