// <copyright file="adoerror.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for CADOError class</summary>
#pragma once

#include "stdafx.h"

class CADOError
{
private:
	CString m_szLastError;	//	String containing last error
	HRESULT m_hrLastError;	//	Last HRESULT error
protected:

	CString LogCrackHR( HRESULT hr );
	HRESULT LogAdoErrorImport(_ConnectionPtr pConn);
	void SetLastError(CString& szError){m_szLastError = szError;}

public:

	void ReportException(_com_error& e);
	CString GetLastError(){return m_szLastError;}
	HRESULT GetLastHRError(){return m_hrLastError;}

	CADOError(void);
	~CADOError(void);
};
