// <copyright file="adomanager.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for CADOManager class</summary>
#pragma once

#include "stdafx.h"
#include "adoconnection.h"
#include "adocommand.h"
#include "adoparameter.h"
#include "adorecordset.h"

enum enumQueryCommands
{
	SQL_USERQUERY=0,
	SQL_DELETE,
	SQL_INSERT,
	SQL_SELECT,
	SQL_UPDATE
};

//	Enumeration for the types of queries that the Manager can perform
enum enumQueryTypes
{
	QueryType_Table = 0,
	QueryType_Procedure,
	QueryType_SQLQuery
};

//	Enumerations for the different operations to perform on a table
enum enumOperations
{
	Operation_Delete = 0,
	Operation_Insert,
	Operation_Select,
	Operation_Update,
};

enum enumParameters
{
	Parameter_int = 0,
	Parameter_string,
	Parameter_datetime
};

#define PARAMETER_INT_SIZE 4
#define PARAMETER_DATETIME_SIZE 8

class CADOManager
{
private:

	CADOConnection *m_pConnection;	//	Pointer to ADO Connection wrapper class
	CADOCommand    *m_pCommand;		//	Pointer to ADO Command wrapper class
	CADORecordset  *m_pRecordset;	//	Pointer to ADO Recordset wrapper class 

	int m_iQueryType;			//	Type of query that is being run
	int m_iOperation;			//	Current database operation;
	int m_iLastError;			//	Last error that occured with ADO operation
	CString m_szLastError;		//	Last error that was generated from an ADO operation
	CString m_szQuery;			//	String containing the user defined query or procedure to use
	CString m_szTable;			//	Name of the table to run operations on
	int m_iReturnParameter;		//	Return parameter from procedure

	BOOL Initialize();		

	int  GetQueryType(){return m_iQueryType;}
	void SetQueryType(int iQueryType){m_iQueryType=iQueryType;}

	int  GetOperation(){return m_iOperation;}
	void SetOperation(int iOperation){m_iOperation=iOperation;}
	BOOL RunTableOperation(enumOperations ADOOperation,CString szFilter = _T(""));

	CString GetProcedureName();
	void GetRecordValues();
protected:

	//	Virtual functions for setting up parameters on a query
	virtual void SetUserParameters(){}
	virtual void SetDELETEParameters(){}
	virtual void SetINSERTParameters(){}
	virtual void SetSELECTParameters(){}
	virtual void SetUPDATEParameters(){}

	//	Virtual functions for getting the values in the recordset from a query
	virtual void GetUserValues(){}
	virtual void GetSELECTValues(){}

	BOOL GetValue(CString szColumnName,int& iValue);
	BOOL GetValue(CString szColumnName,CString& szValue);
	BOOL GetValue(CString szColumnName,FILETIME& ftValue);

	void AddInputParameter(CString szParameterName, int iValue);
	void AddInputParameter(CString szParameterName, CString szValue);
	void AddInputParameter(CString szParameterName, FILETIME ftValue);

	void RunQuery(CString szFilter = _T(""));

public:

	CString GetLastErrorString(){return m_szLastError;}

	void SetTable(CString szTable)
	{
		m_szTable = szTable;
		m_iQueryType = QueryType_Table;
	}

	CString GetTable(){return m_szTable;}
	CString GetQuery(){return m_szQuery;}

	void SetConnection(CADOConnection *pdbc){m_pConnection = pdbc;}

	int GetReturnParameter(){return m_iReturnParameter;}
	int GetRecordCount()
	{
		if(m_pRecordset)
		{
			return m_pRecordset->GetRecordCount();
		}

		return -1;
	}

	//	Main operations to perform on a table in the database
	BOOL ADO_USERPROC(CString szProc,CString szFilter = _T(""));
	BOOL ADO_USERQUERY(CString szQuery,CString szFilter = _T(""));
	BOOL ADO_DELETE();
	BOOL ADO_INSERT();
	BOOL ADO_SELECT(CString szFilter = _T(""));
	BOOL ADO_UPDATE();

	BOOL GetNextRecord();

	CADOManager(CADOConnection *pDB);
	CADOManager();
	~CADOManager();
};
