// <copyright file="adoparameter.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for CADOParameter class</summary>
#pragma once

#include "stdafx.h"
#include "adoerror.h"

class CADOParameter : CADOError
{
private:

	_ParameterPtr m_pParameter;
	VARIANT m_vtValue;

	void Initialize();

	BOOL SetValue(VARIANT& vtValue);
	BOOL SetType(DataTypeEnum enumType);
	BOOL SetDirection(ParameterDirectionEnum enumDirection);

	BOOL SetTypeToArray(){return SetType(adArray);}
	BOOL SetTypeToBigInt(){return SetType(adBigInt);}	
	BOOL SetTypeToBinary(){return SetType(adBinary);}	
	BOOL SetTypeToBoolean(){return SetType(adBoolean);}
	BOOL SetTypeToBSTR(){return SetType(adBSTR);}		
	BOOL SetTypeToChapter(){return SetType(adChapter);}	
	BOOL SetTypeToChar(){return SetType(adChar);}		
	BOOL SetTypeToCurrency(){return SetType(adCurrency);}	
	BOOL SetTypeToDate(){return SetType(adDate);}		
	BOOL SetTypeToDBDate(){return SetType(adDBDate);}	
	BOOL SetTypeToDBTime(){return SetType(adDBTime);}	
	BOOL SetTypeToDBTimeStamp(){return SetType(adDBTimeStamp);}
	BOOL SetTypeToDecimal(){return SetType(adDecimal);}	
	BOOL SetTypeToDouble(){return SetType(adDouble);}	
	BOOL SetTypeToEmpty(){return SetType(adEmpty);}		
	BOOL SetTypeToError(){return SetType(adError);}		
	BOOL SetTypeToFileTime(){return SetType(adFileTime);}	
	BOOL SetTypeToGUID(){return SetType(adGUID);}		
	BOOL SetTypeToIDispatch(){return SetType(adIDispatch);}	
	BOOL SetTypeToInteger(){return SetType(adInteger);}	
	BOOL SetTypeToIUnknown(){return SetType(adIUnknown);}	
	BOOL SetTypeToLongVarBinary(){return SetType(adLongVarBinary);}
	BOOL SetTypeToLongVarChar(){return SetType(adLongVarChar);}
	BOOL SetTypeToLongVarWChar(){return SetType(adLongVarWChar);}
	BOOL SetTypeToNumeric(){return SetType(adNumeric);}
	BOOL SetTypeToPropVariant(){return SetType(adPropVariant);}
	BOOL SetTypeToSingle(){return SetType(adSingle);}
	BOOL SetTypeToSmallInt(){return SetType(adSmallInt);}
	BOOL SetTypeToTinyInt(){return SetType(adTinyInt);}
	BOOL SetTypeToUnsignedBigInt(){return SetType(adUnsignedBigInt);}
	BOOL SetTypeToUnsignedInt(){return SetType(adUnsignedInt);}
	BOOL SetTypeToUnsignedTinyInt(){return SetType(adUnsignedTinyInt);}
	BOOL SetTypeToUserDefined(){return SetType(adUserDefined);}
	BOOL SetTypeToVarBinary(){return SetType(adVarBinary);}
	BOOL SetTypeToVarChar(){return SetType(adVarChar);}
	BOOL SetTypeToVariant(){return SetType(adVariant);}
	BOOL SetTypeToVarNumeric(){return SetType(adVarNumeric);}
	BOOL SetTypeToVarWChar(){return SetType(adVarWChar);}
	BOOL SetTypeToWChar(){return SetType(adWChar);}

public:

	_ParameterPtr GetParameter(){return m_pParameter;}

	BOOL SetNumericScale(unsigned char ucNumericScale);
	BOOL SetPrecision(unsigned char ucPrecision);
	BOOL SetSize(int iSize);
	BOOL SetName(CString szName);

	BOOL SetDirToInput(){return SetDirection(adParamInput);}		
	BOOL SetDirToOutput(){return SetDirection(adParamInputOutput);}
	BOOL SetDirInputOutput(){return SetDirection(adParamOutput);}		
	BOOL SetDirToReturnValue(){return SetDirection(adParamReturnValue);}
	BOOL SetDirToUnknown(){return SetDirection(adParamUnknown);}		


	BOOL SetBoolean(BOOL bValue);
	BOOL SetValue(int iValue);
	BOOL SetValue(BSTR& bstrValue);
	BOOL SetValue(char *cValue,int iSize);
	BOOL SetValue(CString szValue);
	BOOL SetValue(FILETIME ftValue);

	CADOParameter(CString szName,ParameterDirectionEnum enumDirection,int iValue);
	CADOParameter(CString szName,ParameterDirectionEnum enumDirection,CString szValue);
	CADOParameter(CString szName,ParameterDirectionEnum enumDirection,FILETIME ftValue);
	CADOParameter(void);
	~CADOParameter(void);
};


	/*
DataTypeEnum
AdArray			A flag value, always combined with another data type constant, that indicates an array of the other data type. Does not apply to ADOX.
adBigInt		Indicates an eight-byte signed integer (DBTYPE_I8).
adBinary		Indicates a binary value (DBTYPE_BYTES).
adBoolean		Indicates a Boolean value (DBTYPE_BOOL).
adBSTR			Indicates a null-terminated character string (Unicode) (DBTYPE_BSTR).
adChapter		Indicates a four-byte chapter value that identifies rows in a child rowset (DBTYPE_HCHAPTER).
adChar			Indicates a string value (DBTYPE_STR).
adCurrency		Indicates a currency value (DBTYPE_CY). Currency is a fixed-point number with four digits to the right of the decimal point. It is stored in an eight-byte signed integer scaled by 10,000.
adDate			Indicates a date value (DBTYPE_DATE). A date is stored as a double, the whole part of which is the number of days since December 30, 1899, and the fractional part of which is the fraction of a day.
adDBDate		Indicates a date value (yyyymmdd) (DBTYPE_DBDATE).
adDBTime		Indicates a time value (hhmmss) (DBTYPE_DBTIME).
adDBTimeStamp	Indicates a date/time stamp (yyyymmddhhmmss plus a fraction in billionths) (DBTYPE_DBTIMESTAMP).
adDecimal		Indicates an exact numeric value with a fixed precision and scale (DBTYPE_DECIMAL).
adDouble		Indicates a double-precision floating-point value (DBTYPE_R8).
adEmpty			Specifies no value (DBTYPE_EMPTY).
adError			Indicates a 32-bit error code (DBTYPE_ERROR).
adFileTime		Indicates a 64-bit value representing the number of 100-nanosecond intervals since January 1, 1601 (DBTYPE_FILETIME).
adGUID			Indicates a globally unique identifier (GUID) (DBTYPE_GUID).
adIDispatch		Indicates a pointer to an IDispatch interface on a COM object (DBTYPE_IDISPATCH).
				Note: This data type is currently not supported by ADO. Usage may cause unpredictable results.
adInteger		Indicates a four-byte signed integer (DBTYPE_I4).
adIUnknown		Indicates a pointer to an IUnknown interface on a COM object (DBTYPE_IUNKNOWN).


ParameterDirectionEnum
adParamInput		Default. Indicates that the parameter represents an input parameter.
adParamInputOutput	Indicates that the parameter represents both an input and output parameter.
adParamOutput		Indicates that the parameter represents an output parameter.
adParamReturnValue	Indicates that the parameter represents a return value.
adParamUnknown		Indicates that the parameter direction is unknown.

Variant List
VT_EMPTY 
VT_EMPTY | VT_BYREF 
VT_UI1 
VT_UI1 | VT_BYREF 
VT_UI2 
VT_UI2 | VT_BYREF 
VT_UI4 
VT_UI4 | VT_BYREF 
VT_UI8 
VT_UI8 | VT_BYREF 
VT_UINT 
VT_UINT | VT_BYREF 
VT_INT 
VT_INT | VT_BYREF 
VT_I1 
VT_I1 | VT_BYREF 
VT_I2 
VT_I2 | VT_BYREF 
VT_I4 
VT_I4 | VT_BYREF 
VT_I8 
VT_I8 | VT_BYREF 
VT_R4 
VT_R4 | VT_BYREF 
VT_R8 
VT_R8 | VT_BYREF 
VT_CY 
VT_CY | VT_BYREF 
VT_BSTR 
VT_BSTR | VT_BYREF 
VT_DECIMAL 
VT_DECIMAL | VT_BYREF 
VT_NULL 
VT_NULL | VT_BYREF 
VT_ERROR 
VT_ERROR | VT_BYREF 
VT_BOOL 
VT_BOOL | VT_BYREF 
VT_DATE 
VT_DATE | VT_BYREF 
VT_DISPATCH 
VT_DISPATCH | VT_BYREF 
VT_VARIANT 
VT_VARIANT | VT_BYREF 
VT_UNKNOWN 
VT_UNKNOWN | VT_BYREF 

*/

