// <copyright file="adorecordset.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for CADORecordset class</summary>
#pragma once

#include "stdafx.h"
#include "adoerror.h"
#include "adocommand.h"

class CADORecordset : public CADOError
{
private:
	_RecordsetPtr m_pRecordset;
	BOOL SetCursorMode(CursorTypeEnum enumCursorType);

public:

	//	Cursor type settings
	BOOL SetCursorToDynamic();
	BOOL SetCursorToKeyset();
	BOOL SetCursorToStatic();
	BOOL SetCursorToForwardOnly();
	BOOL SetCursorToUnspecified();

	// Recordset navigation functions
	BOOL MoveFirst();
	BOOL MoveLast();
	BOOL MoveNext();
	BOOL MovePrev();
	BOOL MoveTo(int iRecordsToMove);

	//	Checking for beginning/end of recordset
	BOOL IsBOF();
	BOOL IsEOF();
	BOOL IsNoRecords();

	//	Records functions
	BOOL SetFilter(CString szString);
	long GetRecordCount();
	BOOL Close();

	// Fields functions
	BOOL GetValue(LPCSTR lpName, int& iValue);
	BOOL GetValue(LPCSTR pszName, CString& szValue);

	CADORecordset(_RecordsetPtr& pRecordset);
	CADORecordset(void);
	~CADORecordset(void);
};
/*
CursorType
    *      Dynamic cursor			Allows you to view additions, changes, and deletions by other users; 
									allows all types of movement through the Recordset that doesn't rely 
									on bookmarks; and allows bookmarks if the provider supports them.
    *      Keyset cursor			Behaves like a dynamic cursor, except that it prevents you from seeing 
									records that other users add, and prevents access to records that other 
									users delete. Data changes by other users will still be visible. 
									It always supports bookmarks and therefore allows all types of movement 
									through the Recordset.
    *      Static cursor			Provides a static copy of a set of records for you to use to find data 
									or generate reports; always allows bookmarks and therefore allows all 
									types of movement through the Recordset. Additions, changes, or deletions 
									by other users will not be visible. This is the only type of cursor allowed 
									when you open a client-side Recordset object.
    *      Forward-only cursor		Allows you to only scroll forward through the Recordset. Additions, 
									changes, or deletions by other users will not be visible. This improves 
									performance in situations where you need to make only a single pass 
									through a Recordset.




*/

