// <copyright file="adotestdlg.cpp" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Main dialog for ado test project</summary>
// ADOTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ADOTest.h"
#include "ADOTestDlg.h"
#include "tblpeople.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About
extern CADOConnection *pADOConnection;

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CADOTestDlg dialog




CADOTestDlg::CADOTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CADOTestDlg::IDD, pParent)
	, m_iOperation(0)
	, m_szStatus(_T(""))
	, m_iidRecord(0)
	, m_iPersonAge(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CADOTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_ADOCONNECTSTRING, m_szConnectionString);
	DDX_Text(pDX, IDC_SQLQUERY, m_szSQLQuery);
	DDX_Radio(pDX, IDC_DELETE, m_iOperation);
	DDX_Text(pDX, IDC_EDIT1, m_szStatus);
	DDX_Control(pDX, IDC_EDIT1, m_ebStatus);
	DDX_Text(pDX, IDC_RECORDID, m_iidRecord);
	DDX_Text(pDX, IDC_PERSONNAME, m_szPersonName);
	DDX_Text(pDX, IDC_PERSONAGE, m_iPersonAge);
}

BEGIN_MESSAGE_MAP(CADOTestDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON2, &CADOTestDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CADOTestDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON1, &CADOTestDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CADOTestDlg message handlers

BOOL CADOTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_iOperation = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CADOTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CADOTestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CADOTestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CADOTestDlg::AddStatusMsg(CString szMsg)
{
	m_szStatus += (szMsg + "\r\n");
    UpdateData(0);
	m_ebStatus.Invalidate();
	m_ebStatus.UpdateWindow();
}

//	Create a connection to the SQL server
void CADOTestDlg::OnBnClickedButton2()
{
	UpdateData(1);
	if(pADOConnection)
	{
		if(pADOConnection->IsOpen())
		{
			pADOConnection->Close();
		}

		pADOConnection->SetConnectionString(m_szConnectionString);
		if(pADOConnection->Open())
		{
			if(pADOConnection->IsOpen())
			{
				AddStatusMsg("Connection established to SQL Server");
			}
		}
		else
		{
			AddStatusMsg("Connection attempt failed");
			AddStatusMsg(pADOConnection->GetLastError());
		}
	}
}

void CADOTestDlg::OnBnClickedButton3()
{
	CTblPeople tblPeople(pADOConnection);

	UpdateData(1);

	switch(m_iOperation)
	{
		case Operation_Delete:
			tblPeople.mp_iidRecord = m_iidRecord;
			if(tblPeople.ADO_DELETE())
			{
				AddStatusMsg("Success: DELETE operation");
			}
			else
			{
				AddStatusMsg("Could not run DELETE operation");
				AddStatusMsg(tblPeople.GetLastErrorString());
			}
		break;
		case Operation_Insert:
			tblPeople.m_iPersonAge = m_iPersonAge;
			tblPeople.m_szPersonName = m_szPersonName;
			if(tblPeople.ADO_INSERT())
			{
				AddStatusMsg("Success: INSERT operation");
			}
			else
			{
				AddStatusMsg("Could not run INSERT operation");
				AddStatusMsg(tblPeople.GetLastErrorString());
			}
        break;
		case Operation_Select:
			tblPeople.mp_iidRecord = m_iidRecord;	
			if(tblPeople.ADO_SELECT())
			{
				int iRecords;
				CString szRecord;

				AddStatusMsg("Success: SELECT operation");
				AddStatusMsg("Table output:");
				AddStatusMsg("RecordID,Person Name,Person Age");
				iRecords = 0;
				while(tblPeople.GetNextRecord()&&iRecords <= 10)
				{
					szRecord.Format(_T("%d,%s,%d"),tblPeople.mp_iidRecord,tblPeople.m_szPersonName,tblPeople.m_iPersonAge);
					AddStatusMsg(szRecord);
					iRecords++;
				}
			}
			else
			{
				AddStatusMsg("Could not run SELECT operation");
				AddStatusMsg(tblPeople.GetLastErrorString());
			}
        break;
		case Operation_Update:
			tblPeople.mp_iidRecord = m_iidRecord;	
			tblPeople.m_iPersonAge = m_iPersonAge;
			tblPeople.m_szPersonName = m_szPersonName;
			if(tblPeople.ADO_UPDATE())
			{
				AddStatusMsg("Success: UPDATE operation");
			}
			else
			{
				AddStatusMsg("Could not run UPDATE operation");
				AddStatusMsg(tblPeople.GetLastErrorString());
			}
        break;
	}
}

//	Run user query
void CADOTestDlg::OnBnClickedButton1()
{
	CADOManager adom;

	adom.SetConnection(pADOConnection);
	UpdateData(1);
	if(adom.ADO_USERQUERY(m_szSQLQuery))
	{
		AddStatusMsg("Success: USERQUERY operation");
		if(adom.GetRecordCount())
		{
			CString szRecord;
			szRecord.Format(_T("There are %d records returned from user query"),adom.GetRecordCount());
		}
	}
	else
	{
		AddStatusMsg("Could not run User Query operation");
		AddStatusMsg(adom.GetLastErrorString());
	}
}
