// <copyright file="adotestdlg.h" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>Header file for ado test dialog</summary>
// ADOTestDlg.h : header file
//

#pragma once
#include "afxwin.h"


// CADOTestDlg dialog
class CADOTestDlg : public CDialog
{
private:
		void AddStatusMsg(CString szMsg);

// Construction
public:
	CADOTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_ADOTEST_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()


public:
	afx_msg void OnBnClickedButton2();
	// ADO Connection string text box
	CString m_szConnectionString;
	// SQL Query Text box
	CString m_szSQLQuery;
	// Index of Table operation
	int m_iOperation;
	// Status of database operation
	CString m_szStatus;
	// Status of database operation edit box control
	CEdit m_ebStatus;
	afx_msg void OnBnClickedButton3();
	// Record ID 
	int m_iidRecord;
	CString m_szPersonName;
	int m_iPersonAge;
	afx_msg void OnBnClickedButton1();
};
