// <copyright file="TblPeople.cpp" company="Mancier Connections">
// Copyright (c) 2009 All Right Reserved
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// </copyright>
// <author>Patrick Mancier</author>
// <email>teknerd001@gmail.com</email>
// <date>2009-03-21</date>
// <summary>This class is an inhertied class of CADOManager and is used to operate on the People table in database</summary>
#include "TblPeople.h"

////////////////////////////////////////////////////////////////////////////////////////////////////////////
CTblPeople::CTblPeople(void):CADOManager()
{
	Initialize();
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
CTblPeople::CTblPeople(CADOConnection *pdbc):CADOManager(pdbc)
{
	Initialize();
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
CTblPeople::~CTblPeople(void)
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CTblPeople::Initialize()
{
	mp_iidRecord = 0;
	m_szPersonName = _T("");
	m_iPersonAge = 0;

	SetTable("People");
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CTblPeople::SetDELETEParameters()
{
	if(mp_iidRecord)
	{
		AddInputParameter("idRecord",mp_iidRecord);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CTblPeople::SetINSERTParameters()
{
	AddInputParameter("PersonName",m_szPersonName);
	AddInputParameter("PersonAge",m_iPersonAge);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CTblPeople::SetSELECTParameters()
{
	if(mp_iidRecord)
	{
		AddInputParameter("idRecord",mp_iidRecord);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CTblPeople::SetUPDATEParameters()
{
	AddInputParameter("idRecord",mp_iidRecord);
	AddInputParameter("PersonName",m_szPersonName);
	AddInputParameter("PersonAge",m_iPersonAge);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CTblPeople::GetSELECTValues()
{
	GetValue("idRecord",mp_iidRecord);
	GetValue("PersonName",m_szPersonName);
	GetValue("PersonAge",m_iPersonAge);
}

