/* Generated by Scriptol */

const fs=require('fs');
const scriptol=require('scriptol');
// JS Link Checker
// (c) 2016-2025 www.scriptol.com
// Based on PHP FTP Synchronizer by Kim Haskell & Denis Sureau
// Free under the GNU GPL 3 License.
// Scriptol sources are compiled with the Scriptol-JavaScript compiler (www.scriptol.org).
// Read the manual for details of use.
eval(fs.readFileSync(__dirname + '/path.js')+'');
eval(fs.readFileSync(__dirname + '/linkcheck.js')+'');
var QUIET=false;

var FilesArray=[];

var problem=0;

function usage()
{
   console.log();
   console.log("JS Link Checker 2.2 - (c) 2016-2025 Scriptol.com");
   console.log("------------------------------------------------");
   console.log("Syntax:");
   console.log("  node links.js [options & parameters] sourcedir");
   console.log("Parameters:");
   console.log("  -wwebsite:  to rebuild urls.");
   console.log("  source: a directory to check the content.");
   console.log("Options:");
   console.log("  -v verbose, display more infos.");
   console.log("  -q quiet, display nothing.");
   console.log("You will be prompted for each omitted but required parameter.");
   console.log("See manual on www.scriptol.com for more.");
   process.exit(0);
   return;
}

function parseDir(locdir)
{
   if(VERBOSE) {
      console.log("Entering "+locdir);
   }
   var content=fs.readdirSync(locdir);

   var src="";

   var bfile="";

   var rmt="";

   var name="";

   if(scriptol.empty(content)) {
      return;
   }
   for(name in content) {
      name=content[name];
      if(name.slice(0,11)==="javascript:") {
         continue;
      }
      if(name.charAt(0)==="/") {
         src=Path.merge(website,name);
      }      
      else {
         src=Path.merge(locdir,name);
      }
      if(scriptol.filetype(src)==="file") {
         if(name.charAt(0)===".") {
            if(!QUIET) {
               console.log(name+' '+"skipped");
            }
            problem+=1;
            continue;
         }
         FilesArray.push(src);
      }
   }
   for(name in content) {
      name=content[name];
      if(name.charAt(0)==='.') {
         continue;
      }
      src=Path.merge(locdir,name);
      if(scriptol.filetype(src)==="dir") {
         parseDir(src);
      }
   }
   return;
}

function processCommand(argnum,argv)
{
   var daystring="";

   var opt="";

   if(argnum<2) {
      usage();
   }
   for(var param in argv) {
      param=String(argv[param]);
      if(param.length>1) {
         opt=param.slice(0,2);
      }      
      else {
         usage();
      }
      if(opt==="-v") {
         VERBOSE=true;
         continue;
      }
      if(opt==="-q") {
         QUIET=true;
         continue;
      }
      if(opt==="-~") {
         DEBUG=true;
         continue;
      }
      if(opt==="-w") {
         website=param.slice(2);
         if(website==="") {
            scriptol.die("-w must be followed by the site url.");
         }
         continue;
      }
      if(param.charAt(0)==="-") {
         console.log("Unknown command "+param);
         usage();
      }
      if(source==="") {
         source=param;
         continue;
      }
      console.log("Unknown command "+param);
      usage();
   }
   if(source==="") {
            source=scriptol.input("Directory to check: ");
   }
   if(source==="") {
      process.exit(0);
   }
   if(website==="") {
            website=scriptol.input("Website URL: ");
   }
   if(website==="") {
      process.exit(0);
   }
   return;
}

function saybye(err,data)
{
   if(err) {
      console.log(err);
      return;
   }
   console.log("Done!");
   return;
}

function main(argc,argv)
{
   var x=argv.slice(1);

   processCommand(argc,x.slice());
   if(!hasProtocol(website)) {
      website="https://"+website;
   }
   if(!QUIET) {
      if(VERBOSE===true) {
         console.log("Verbose mode enabled");
      }
      if(DEBUG===true) {
         console.log("Debug mode enabled");
      }
      console.log("Source directory: "+source);
   }
   console.log("Checking links in "+source+" for "+website);
   parseDir(source);
   differedCheck(FilesArray.slice());
   return 0;
}

main(process.argv.length-1,process.argv.slice(1));


/* End */
