# JS Link Checker
# (c) 2016-2025 www.scriptol.com 
# Based on PHP FTP Synchronizer by Kim Haskell & Denis Sureau
# Free under the GNU GPL 3 License.

# Scriptol sources are compiled with the Scriptol-JavaScript compiler (www.scriptol.org).

# Read the manual for details of use.

include "path.sol"
include "linkcheck.sol"
extern bool VERBOSE

bool QUIET = false     // True to display nothing
array FilesArray = []
int problem

void usage()
	print
	print "JS Link Checker 2.2 - (c) 2016-2025 Scriptol.com"
	print "------------------------------------------------"
	print "Syntax:"
	print "  node links.js [options & parameters] sourcedir"
	print "Parameters:"
	print "  -wwebsite:  to rebuild urls."
	print "  source: a directory to check the content."
	print "Options:"
	print "  -v verbose, display more infos."
	print "  -q quiet, display nothing."	
	print "You will be prompted for each omitted but required parameter."
	print "See manual on www.scriptol.com for more."
	exit(0)
return


// synchronize

void parseDir(text locdir)

	if VERBOSE ? print "Entering $locdir"
	
    array content = scandir(locdir)
    text src, bfile, rmt, name

    if content.empty() return

    // processing files
	
    for name in content
        if name[ .. 10] = "javascript:" continue
        if name[0] = "/"
           src = Path.merge(website, name) 
        else    
           src = Path.merge(locdir, name)
        /if  

        if filetype(src) = "file"
            // .htaccess and such files are ignored
            if name[0] = "."     
                if not QUIET print name, "skipped"
                problem + 1
                continue 
            /if
			
            FilesArray.push(src)
	    /if
   /for

    // processing subdirs
	
   for name in content
       if name[0] = '.' continue
       src = Path.merge(locdir, name)	
       if filetype(src) = "dir"
         parseDir(src)
       /if
   /for	

return


// Parsing command line parameters
// Stored into an array to overcome problems with PHP global variables

void processCommand(int argnum, array argv)

    text daystring = ""
	text opt = ""

	if argnum <  2 ? usage()


	for text param in argv

		if param.length() > 1
			opt = param[..1]
		else
			usage()
		/if	
		
		if opt = "-v" 
			VERBOSE = true
			continue
		/if
        
		if opt = "-q" 
			QUIET = true
			continue
		/if	

		if opt = "-~" 
			DEBUG = true
			continue
		/if


		if opt = "-w"
			website = param[ 2 .. ]
			if website = nil let die("-w must be followed by the site url.")			
			continue
		/if


		if param[0] = "-" 
        print "Unknown command $param"  
        usage()
    /if   
		
		if source = nil
			source = param
			continue
		/if	
		
		print "Unknown command $param"
    
    usage()
		
	/for

	if source = nil input "Directory to check: ",  source
	if source = nil ? exit(0)
	
	if website = nil input "Website URL: ",  website
	if website = nil ? exit(0)


return


void saybye(text err, text data) 
    if err
        print err
        return
    /if    
    print "Done!"
return


int main(int argc, array argv)

	array x = argv[ 1 .. ]
	processCommand(argc, x)

    // Building the base URL for link check

    if not hasProtocol(website)
        website = "https://" + website
    /if  
    
    if not QUIET
        if VERBOSE = true print "Verbose mode enabled"
        if DEBUG = true print "Debug mode enabled"
        print "Source directory: $source"
    /if

	print "Checking links in $source for $website"
	
	parseDir(source)	
    differedCheck(FilesArray)

return 0

main($argc, $argv)
