<?php
include_once("path.php");
include_once("url.php");
include_once("tools.php");
$LASTMOD=true;
$LASTMODSHORT=false;
$PRIORITY=true;
$FREQUENCY=true;
$DEFAULT_FREQUENCY="monthly";
$DEFAULT_PRIORITY="0.2";
// Min size for a file to be indexed
$MINFILESIZE=1000;
// Files and dirs to ignore
$exclusions=array("header.php","footer.php","sidebar.php","top.php","bottom.php","sitemap.xml","sitemap.html","wp-config.php");
$excludedDirs=array("/wp-admin","/wp-content","/wp-includes","/*");
// Extensions to index
$extensions=array("htm","html","php","php3","php4","php5","asp","shtml","dhtml","jsp","xhtml","sol");
$dateFormat="";
$version="Simple Map 2.0 (c) 2006-2016  www.scriptol.com";
$logfile=array();
function display($t)
{
   global $GRAPHICAL;
   if($GRAPHICAL===true)
   {
      global $logfile;
      array_push($logfile,$t."\n");
   }
   else
   {
      echo $t, "\n";
   }
   return;
}

// read an ".ini" file, parse lines and return a dict of options
function readIni($inipath)
{
   $ini=array();
   $inipath=Path::changeExt($inipath,"ini");
   if(!file_exists($inipath))
   {
      return;
   }
   $ini=file($inipath);
   if((count($ini)===0))
   {
      display($inipath." file not loaded");
      return;
   }
   foreach($ini as $option)
   {
      $option=trim($option);
      $i=strpos($option,"=");
      if($i===false)
      {
         $i=strpos($option,":");
         if($i===false)
         {
            continue;
         }
      }
      $k=trim(substr($option,0,$i));
      $v=trim(substr($option,$i+1));
      
      if($k==="sitemap")
      {
         global $mapname;
         $mapname=$v;
      }
      else
      {
         if($k==="logfile")
         {
            global $logname;
            $logname=$v;
         }
      else
      {
         if($k==="frequency")
         {
            global $DEFAULT_FREQUENCY;
            $DEFAULT_FREQUENCY=$v;
         }
      else
      {
         if($k==="graphical")
         {
            global $GRAPHICAL;
            $GRAPHICAL=(in_array($v,array("yes","1","true","ok")));
         }
      }}}
   }
   return;
}

// Check for supported extension
function validExtension($fname)
{
   $node="";
   $ext="";
   $_I1=Path::splitExt($fname);
   $node=reset($_I1);
   $ext=next($_I1);
   global $extensions;
   if(in_array(strtolower($ext),$extensions))
   {
      return true;
   }
   return false;
}

function usage()
{
   echo "\n";
   global $version;
   echo $version, "\n";
   echo "--------- Generates an XML or HTML site map.", "\n";
   echo "Usage:", "\n";
   echo "    smap [options] url [local-path]", "\n";
   echo "or  smap [options] remote-path", "\n";
   echo " url:         in the form: http://www.mysite.com", "\n";
   echo " local-path:  optional, in the form: c:\\myrepository\\", "\n";
   echo "Options:", "\n";
   echo " -v   verbose, display what happens.", "\n";
   echo " -d   debug, output on screen instead.", "\n";
   echo " -m   set the lastmod tag with file date only.", "\n";
   echo " -t   generate a text sitemap file.", "\n";
   echo " -h   generate an HTML sitemap file.", "\n";
   echo "Output:", "\n";
   echo " sitemap.xml or the name in smap.ini, at the root of the local repository.", "\n";
   echo " or sitemap.html, sitemap.txt.", "\n";
   echo "\n";
   exit(1);
   return;
}

function options($num,$args)
{
   $fileindex=0;
   $smapdir="";
   global $GRAPHICAL;
   $GRAPHICAL=false;
   global $VERBOSE;
   $VERBOSE=false;
   global $DEBUG;
   $DEBUG=false;

   global $mapType;
   $mapType=0;
   $fileindex=1;

   while($fileindex<$num)
   {
      do
      {
         $option=$args[$fileindex];
         $opt=$option{0};
         if(($opt!='-')&&($opt!='/'))
         {
            break 2;
         }
         $_I1=substr($option,1);
         $_L3=strlen($_I1);
         for($__3 = 0; $__3 < $_L3; $__3++)
         {
            $opt=$_I1{$__3};
            
            $_I2=strtolower($opt);
            if($_I2==="g")
            {
               $GRAPHICAL=true;
            }
            else
            {
               if($_I2==="v")
               {
                  $VERBOSE=true;
               }
            else
            {
               if($_I2==="d")
               {
                  $DEBUG=true;
               }
            else
            {
               if($_I2==="m")
               {
                  global $LASTMODSHORT;
                  $LASTMODSHORT=true;
               }
            else
            {
               if($_I2==="t")
               {
                  $mapType=1;
                  global $mapname;
                  $mapname=Path::changeExt($mapname,".txt");
                  global $FREQUENCY;
                  $FREQUENCY=false;
                  global $PRIORITY;
                  $PRIORITY=false;
                  global $LASTMOD;
                  $LASTMOD=false;
                  global $LASTMODSHORT;
                  $LASTMODSHORT=false;
               }
            else
            {
               if($_I2==="h")
               {
                  $mapType=2;
                  global $mapname;
                  $mapname=Path::changeExt($mapname,".html");
                  global $FREQUENCY;
                  $FREQUENCY=false;
                  global $PRIORITY;
                  $PRIORITY=false;
                  global $LASTMOD;
                  $LASTMOD=false;
                  global $LASTMODSHORT;
                  $LASTMODSHORT=false;
               }
            else
            {
               echo $option, " ", "bad option", "\n";
               usage();
            }
            }}}}}
         }
         $fileindex+=1;
      } while(false);
   }
   readIni($args[0]);
   global $LASTMODSHORT;
   if($LASTMODSHORT)
   {
      global $dateFormat;
      $dateFormat="Y-m-d";
   }
   else
   {
      global $dateFormat;
      $dateFormat="Y-m-d\\TH:i:sP";
   }
   // two parameters remaining?  url + local path

   global $siteURL;
   $siteURL=$args[$fileindex];
   if(!hasProtocol($siteURL))
   {
      $siteURL="http://".$siteURL;
   }
   $fileindex+=1;

   if($fileindex<$num)
   {
      global $localRoot;
      $localRoot=$args[$fileindex];
   }
   else
   {
      global $localRoot;
      $localRoot=getcwd();
   }
   global $logname;
   $_I2=Path::splitFile($args[0]);
   $smapdir=reset($_I2);
   $logname=next($_I2);
   $logname=Path::merge($smapdir,"smap.log");

   global $localRoot;
   if(!Path::exists($localRoot))
   {
      display($localRoot." not found");
      exit();
   }
   return;
}

?>
