
include "path.sol"
include "url.sol"
include "tools.sol"

extern bool GRAPHICAL


/* CHANGE OPTIONS HERE */

bool LASTMOD = true
bool LASTMODSHORT = false
bool PRIORITY = true
bool FREQUENCY = true
text DEFAULT_FREQUENCY = "monthly"
text DEFAULT_PRIORITY = "0.2"
# Min size for a file to be indexed
int  MINFILESIZE = 1000                             
# Files and dirs to ignore
array exclusions = [ "header.php", "footer.php", "sidebar.php", "top.php", "bottom.php", "sitemap.xml", "sitemap.html", "wp-config.php" ]    
array excludedDirs = [ "/wp-admin", "/wp-content", "/wp-includes", "/*" ]
# Extensions to index
array extensions = ["htm", "html", "php", "php3", "php4", "php5", "asp",
    "shtml", "dhtml", "jsp", "xhtml", "sol"]

/* END OF OPTIONS */

text dateFormat

enum  OUT_XML, OUT_TEXT, OUT_HTML 


text version = "Simple Map 2.0 (c) 2006-2016  www.scriptol.com"


array logfile = []


void display(text t)
	if GRAPHICAL = true
		logfile.push(t + "\n")
	else	
		print t		
	/if	
return

# read an ".ini" file, parse lines and return a dict of options

void readIni(text inipath)

  array ini
  inipath = Path.changeExt(inipath, "ini")
  if not file_exists(inipath) return
  ini.load(inipath)
  if(ini.size() = 0)
    display(inipath + " file not loaded")
    return
  /if

  for text option in ini
    option = option.trim()        // remove trailing spaces and eol
    int i = option.find("=")      // parse a line
    if i = nil  
		i = option.find(":")
		if i = nil	continue          // no valid couple key=value
	/if	
    text k = option[--i].trim()   // key
    text v = option[i+1..].trim() // value
    if k
	= "sitemap":		mapname = v
    = "logfile":		logname = v
	= "frequency":	    DEFAULT_FREQUENCY = v
	= "graphical":	    GRAPHICAL = (v in [ "yes", "1", "true", "ok" ])
    /if
  /for

return

# Check for supported extension 

bool validExtension(text fname)
	text node
	text ext
	node, ext = Path.splitExt(fname)
	if ext.lower()  in extensions return true
return false

void usage()
	print
	print version
	print "--------- Generates an XML or HTML site map."
    print "Usage:"
    print "    smap [options] url [local-path]" 
    print "or  smap [options] remote-path"
    print " url:         in the form: http://www.mysite.com"
    print " local-path:  optional, in the form: c:\\myrepository\\"
    print "Options:"
    print " -v   verbose, display what happens."
    print " -d   debug, output on screen instead."
    print " -m   set the lastmod tag with file date only."
    print " -t   generate a text sitemap file."
    print " -h   generate an HTML sitemap file."	
    print "Output:"
    print " sitemap.xml or the name in smap.ini, at the root of the local repository."
    print " or sitemap.html, sitemap.txt."
    print
	
	exit(1)
	
return

void options(int num, array args)

	int fileindex
	text smapdir

	GRAPHICAL = false
	VERBOSE = false
	DEBUG = false

	mapType = OUT_XML
	fileindex = 1
	

	while fileindex < num 
		text option = args[fileindex]
		text opt = option[0]
		
		if (opt <> '-') and (opt <> '/') break
		
		for opt in option[ 1 .. ]
			if opt.lower()
			= "g" : GRAPHICAL = true
			= "v" : VERBOSE = true 
			= "d" : DEBUG = true
			= "m" : LASTMODSHORT = true
			= "t": 	mapType = OUT_TEXT		// output a text file (default xml)
					mapname = Path.changeExt(mapname, ".txt")
					FREQUENCY = false
					PRIORITY = false
					LASTMOD = false
					LASTMODSHORT = false
			= "h": 	mapType = OUT_HTML		// output a text file (default xml)
					mapname = Path.changeExt(mapname, ".html")
					FREQUENCY = false
					PRIORITY = false
					LASTMOD = false
					LASTMODSHORT = false
			else 
				print option, "bad option"
				usage()
			/if
		/for
		fileindex + 1
	/while
	
	readIni(args[0])
	
    if LASTMODSHORT
       dateFormat = "Y-m-d" 
    else
       dateFormat =  "Y-m-d\\TH:i:sP"
    /if       


	# two parameters remaining?  url + local path

	siteURL = args[fileindex]
	if not hasProtocol(siteURL)
		siteURL = "http://" + siteURL
	/if	
	
	fileindex + 1
	
	if fileindex < num
	    localRoot =  args[fileindex]
	else
	    localRoot = getcwd()
	/if    
	
	smapdir, logname = Path.splitFile(args[0])
	logname = Path.merge(smapdir, "smap.log")

	if not Path.exists(localRoot)
		display(localRoot + " not found")
		exit()
	/if
	
return
