/*
  IndexedDB in Electron 
  (c) 2017 Denis Sureau
  Free, open source under the MIT license.
*/

const http = require("http"),
    path = require("path"),
    url = require("url"),
    fs = require("fs");

const {app, BrowserWindow} = require('electron');

let win

function createWindow () {
    win = new BrowserWindow({
        width: 1024, height: 600, 
        "show":false,
        title:"Indexd DB in Electron",
        webPreferences : {
            nodeIntegration:true
        }
    });
    win.setMenu(null)
    process.resourcesPath = __dirname
    console.log("Working directory : " + process.resourcesPath)
    win.loadURL(path.join(__dirname, 'edb.html'))
    win.show()
    //win.webContents.openDevTools()
  win.on('closed', () => {
    win = null
  })
}

//process.on('uncaughtException', function (error) { })

console.log("Starting Electron...")
app.on('ready', createWindow)

app.on('window-all-closed', () => {
  console.log("Windows closed, exit.")
  app.quit()
  process.exit(1)
})

app.on('activate', () => {
  if (win === null) {
    createWindow()
  }
})

