/*
    Import a Script into IndexedDB
    .
    (c) 2018 Scriptol.com - MIT License
*/

function addScript(dname, sname, scriptTitle, code) {
	return new Promise(function(resolve) {
    	var r = window.indexedDB.open(dname)
		r.onupgradeneeded = function() {
		    var idb = r.result
		    var store = idb.createObjectStore(sname)
		}
		r.onsuccess = function() {
			var idb = r.result
	        let tactn = idb.transaction(sname, "readwrite")
    	    var store = tactn.objectStore(sname)
        	store.put(code, scriptTitle)
			resolve(idb)
	    }
    	r.onerror = function (e) {
			alert("Enable to access IndexedDB, " + e.target.errorCode)
	    }    
	})
}

async function loadFile(fname, title) {
	var response = await fetch(fname)
	var code = await response.text()
	var idb = await addScript("Library", "LibStore", title, code)
    return idb
}


function getCode(dname, sname, scriptTitle) {
	return new Promise(function(resolve) {
		var r = indexedDB.open(dname)
   		r.onsuccess = function(e) {
			var idb = r.result
	    	let tactn = idb.transaction(sname, "readonly")
		    let store = tactn.objectStore(sname)
    		let code = store.get(scriptTitle)
		    code.onsuccess = function() {
    		    resolve(code.result)
	    	}
			tactn.oncomplete = function() {
    	    	idb.close()
	    	}
		}
	})
}
