<?php

/**
	A.R.A Class
	RSS Builder
	(c) 2007 Denis Sureau
	http://www.scriptol.com/rss/
	
	API for creating RSS 2.0 feeds
	Licence GNU GPL 2.
*/


// Create a feed
// Returns the XML document

class ara
{
	public $doc;
	public $rss;
	public $channel;

	function ARAMakeTag($tagname, $str)
	{
		$tag= $this->doc->createElement($tagname);
		$data= $this->doc->createTextNode($str);
		$tag->appendChild($data);
	
		return $tag;
	}

	public function ARAFeed($title, $link, $desc, $date)
	{
		$this->doc = new DOMDocument("1.0", "UTF-8");
		$this->doc->formatOutput = true;
	
		$this->rss = $this->doc->createElement("rss");
		$this->rss->setAttribute("version", "2.0");
		$this->doc->appendChild($this->rss);
	
		$this->channel = $this->doc->createElement("channel");
		$this->rss->appendChild($this->channel);
	
		$this->channel->appendChild($this->ARAMakeTag("title", $title));
		$this->channel->appendChild($this->ARAMakeTag("link", $link));
		$this->channel->appendChild($this->ARAMakeTag("description", $desc));
		$this->channel->appendChild($this->ARAMakeTag("pubDate", $date));
	
	}

	public function ARAItem( $title, $link, $desc, $date)
	{
		$item = $this->doc->createElement("item");
	
		$item->appendChild($this->ARAMakeTag("title", $title));	
		$item->appendChild($this->ARAMakeTag("link", $link));	
		$item->appendChild($this->ARAMakeTag("description", $desc));	
		$item->appendChild($this->ARAMakeTag("pubDate", $date));	
	
		$this->channel->appendChild($item);
	}
	
	public function save($fname)
	{
		$this->doc->save($fname);
	}
	
	public function saveXML()
	{
		return $this->doc->saveXML();
	}

}

/*
$myfeed = new ara();

$myfeed->ARAFeed("Best of Scriptol", "http://www.scriptol.com", "PHP and Scriptol");
$myfeed->ARAItem("The Compiler", "http://www.scriptol.com/index.php", "Compiling Scriptol to PHP");

echo $myfeed->saveXML();
$myfeed->save("scriptol-test.xml");
*/

?>
