

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <ctype.h>
#include <dir.h>
#include <fcntl.h>
#include <string.h>
#include <mem.h>

#include "../gui/head.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/vga.h"
#include "../gui/message.h"
#include "../gui/lift.h"
#include "../gui/souris.h"
#include "../gui/dirtools.h"
#include "../gui/fileman.h"
#include "../gui/drive.h"
#include "../gui/super.h"
#include "../gui/gets18.h"
#include "../gui/windos.h"
#include "../gui/beeper.h"
#include "../gui/winfrmt.h"
#include "../gui/alt.h"

#include "listini.h"
#include "listkeys.h"
#include "listdir.h"
#include "listsort.h"
#include "winview.h"
#include "cddest.h"
#include "listgui.h"


#define DST_TOP 8
#define DST_LEFT 42
#define DST_WIDTH 34
#define DST_HEIGHT 20
#define DST_RIGHT 76
#define DST_REPH 20

char DST_BACK;
char DST_PEN;
#define DST_HEAD 4
#define OK 1

int DST_DIRSTART;

int DST_DIRMAX;
int DST_FILEMAX;
int DST_FILEMAX2;

int numnew, DST_NUMOLD;
char DST_MOREFLAG;

char DST_BUF[DST_SIZE][13];
long DST_REPSIZE[DST_SIZE];
char DST_filetype[DST_SIZE];
unsigned char DST_D[DST_SIZE];
unsigned char DST_M[DST_SIZE];
unsigned char DST_Y[DST_SIZE];
char DST_DTAG[DST_SIZE];
char DST_lockit[DST_SIZE];



char IFLAG;

int test_line(int left, int top, int right, int bottom)
{
    int x;
    int y;

    x = mx >> 3;
    y = my >> 4;

    if(x >= left)
        if(y >= top)
            if(x <= right)
                if(y <= bottom)
                    return(1);

    return(0);
}


int lockunlocktag_dest(int mode)
{
    int i;
    int res;

    res = 0;

    for(i = DST_DIRMAX; i < DST_FILEMAX; i++)
        if(DST_DTAG[i])
        {
            res = res | lockmode(DST_BUF[i], mode);
        }
    return(res);
}


int lock_dest(int mode, int num)
{
    int i;

    if(tagged_dest())
        i = lockunlocktag_dest(mode);
    else
        i = lockunlock(mode, DST_BUF[num]);
    return(i);
}


void switch_DOUBLE()
{
    DOUBLE = 1 - DOUBLE & 1;
    setbig(14, DOUBLE);
}

void swap_in_dir()
{
    char temp[81];
    char current[81];

    getcwd((char *) current, 81);
    strcpy((char *) temp, (char *) DESTINATION);
    strcpy((char *) DESTINATION, (char *) current);
    cdd((char *) temp);
}

/*
void swap_in_dest(char *oldir)
{
 char temp[81];
 
 strcpy((char *) temp, (char *) DESTINATION);
 strcpy((char *) DESTINATION, (char *) oldir);
 cdd((char *) DESTINATION);
 strcpy((char *) oldir, (char *) temp);
}
*/

int dest_root(int num)
{
    if(num < DST_DIRMAX)
        if(!strcmp(DST_BUF[num], ".."))
        {
            beep();
            return(1);
        }
    return(0);
}


int tagged_dest()
{
    int i;

    i = DST_DIRMAX;
next:
    if(i < DST_FILEMAX)
    {
        if(DST_DTAG[i])
            return(1);
        else
        {
            i++;
            goto next;
        }
    }

    return(0);
}


int delete_dest(int num)
{
    int i;
    int ok;
    char *adr;

    i = disk_verify(getdisk(), VERIFY_WRITE);
    if(i != OK)
    {
        box("Not deleted...");
        return(0);
    }

    if(DST_filetype[num] == TYPE_DIR)
    {
        deltree(DST_BUF[num]);
        return(1);
    }

    if(MESS_DEL)
    {
        if(tagged_dest())
            adr = TAG_STRING;
        else
            adr = (char *) DST_BUF[num];
        if(!ask_to_delete(adr))
            goto nul;
    }

    if(tagged_dest())
    {
        ok = 1;
        for(i = DST_DIRMAX; i < DST_FILEMAX; i++)
        {
            if(DST_DTAG[i])
            {
                if(unlink(DST_BUF[i]) == -1)
                    ok = 0;
            }
        }

        if(!ok)
        {
            BOXBACK = 4;
            box("Some files are locked");
            return(27);
        }
        return(1);
    }


    if(!unlink(DST_BUF[num]))
        return(1);
    message_locked(DST_BUF[num]);

nul:
    return(0);
}


int delete_rtn(int num, char buffer[][13])
{
    int i;
    char txt[81];

    if(!available(num))
        return(0);
    BOXYES = 1;
    strcpy(txt, buffer[num]);
    strupr(txt);
    if(answer(box("Delete %s (y/n)?", txt)) != 13)
        return(0);
    if(num < DST_DIRMAX)
        i = rmdir(buffer[num]);
    else
        i = unlink(buffer[num]);
    if(i == -1)
    {
        BOXBACK = 12;
        box("Enable to delete %s", buffer[num]);
        return(0);
    }
    return(1);
}

/* Lire un cran de fichiers, dir, etc... */

int get_dest()
{
    int j;
    int num;
    struct ffblk repbloc;
    struct ftime *ft;
    char diskvar[3];

    diskvar[0] = 'c';
    diskvar[1] = ':';
    diskvar[2] = 0;

    num = 0;
    DST_MOREFLAG = ' ';

diskloop:
    if(num >= DISKMAX)
        goto dirnow;
    *diskvar = num + 65;
    DST_filetype[num] = TYPE_DISK;
    strcpy(DST_BUF[num], diskvar);
    num++;
    goto diskloop;

dirnow:
    if(findfirst("*.*", &repbloc, 255))
        goto filenow;

dirloop:
    if(num >= DST_SIZE)
    {
        DST_MOREFLAG = ' ';
        goto filenow;
    }
    if(repbloc.ff_attrib & FA_DIREC)
    {
        j = TYPE_DIR;
        if(repbloc.ff_name[0] == '.')
        {
            if(repbloc.ff_name[1] != '.')
                goto dirskip;
            j = TYPE_ROOT;
        }

        strcpy(DST_BUF[num], strlwr(repbloc.ff_name));
        DST_filetype[num] = (char) j;
        num++;
    }

dirskip:
    if(findnext(&repbloc) == 0)
        goto dirloop;

filenow:
    DST_DIRMAX = num;
    if(findfirst("*.*", &repbloc, 255))
        goto finish;

fileloop:
    if(num >= DST_SIZE)
    {
        DST_MOREFLAG = '+';
        goto finish;
    }
    if((repbloc.ff_attrib & 28) == 0)
    {
        DST_REPSIZE[num] = repbloc.ff_fsize;
        DST_filetype[num] = TYPE_FILE;
        strcpy(DST_BUF[num], strlwr(repbloc.ff_name));
        ft = (struct ftime *) &repbloc.ff_ftime;
        DST_D[num] = (unsigned char) ft->ft_day;
        DST_M[num] = (unsigned char) (ft->ft_month) - 1;
        DST_Y[num] = (unsigned char) ft->ft_year;
        DST_lockit[num] = ' ' + 10 * (repbloc.ff_attrib & 1);
        num++;
    }

    if(findnext(&repbloc) == 0)
        goto fileloop;

finish:
    DST_FILEMAX = num;
    if(SORT)
    {
        SECOND_DIRECTORY = 1;
        dirsort(DST_BUF[DISKMAX], DST_DIRMAX - DISKMAX, DISKMAX);
        SECOND_DIRECTORY = 1;
        dirsort(DST_BUF[DST_DIRMAX], DST_FILEMAX - DST_DIRMAX, DST_DIRMAX);
    }

    return(num);
}




void DST_print(int line, int i)
{
    char STRBUF[80];
    int y;
    int year;

    y = DST_TOP + line + 1;

    if(i < DST_FILEMAX)
    {
        if(DST_filetype[i])
        {
            put_dir_disk(DST_LEFT - 1, y, i, DST_BUF[i], DST_filetype[i], DIRBACK);
            return;
        }

        year =  (int) DST_Y[i] + 80;
        if(year > 99)
            year -= 100;
        sprintf((char *) STRBUF, "%-12s%10lu%c %2d %3s %02d",
                DST_BUF[i],
                DST_REPSIZE[i],
                DST_lockit[i],
                (int) DST_D[i], month[DST_M[i]], year
               );


        if(DST_DTAG[i])
        {
            if(!IFLAG)
            {
                BACKCOL = TAGCOL;
                PENCOL  = 15;
            }
            else
            {
                BACKCOL = 14;
                PENCOL  = 0;
            }
        }
        else
        {
            if(IFLAG)
            {
                BACKCOL = DST_PEN;
                PENCOL  = DST_BACK;
            }
            else
            {
                BACKCOL = DST_BACK;
                PENCOL  = DST_PEN;
            }
        }

        write18(DST_LEFT, y, STRBUF);
        return;
    }

    /* Fin d'cran */

    BACKCOL = DST_BACK;
    writef18(DST_LEFT, y, "%35s","");
    return;
}


void DST_inventry
(int num, int mode)
{
    int line;
    int blocsize;

    line = num - DST_DIRSTART;
    IFLAG = mode;

    mhide();

    if(num < DST_DIRMAX)
    {
        if(num < DISKMAX)
            blocsize = 22;
        else
            blocsize = 13;
        xbloc(DST_LEFT - 1, 464 - ((DST_TOP + line) << 4), blocsize, 16);
    }
    else
        DST_print(line, num);

    IFLAG = 0;
}



void DST_dispdir()
{
    char currdir[81];

    strcpy((char *) currdir, DESTINATION);
    currdir[39] = 0;
    BACKCOL = DST_BACK;
    PENCOL  = DST_PEN;
    writef18(DST_LEFT, DST_TOP - 2, "%-39s", currdir);
}


void DST_freedisp()
{
    writef18(DST_LEFT, DST_TOP - 1, "Target: %10lu free bytes   ", DISKFREE);
}


void DST_window(void)
{
    B_WIN = DST_BACK;
    winset(DST_LEFT, DST_TOP - 3, 79, DST_TOP + DST_REPH - 1);
}

void set_tag(int color)
{
    memset((char *) DST_DTAG + DST_DIRMAX, (char) color, DST_FILEMAX - DST_DIRMAX);
}

int DST_directory(int flag)
{
    int ch;
    int DST_FILEMAX2;
    int a, b,  y, i;
    int num, numold;
    int FMAX;
    int mc, ml;
    char oldir[81];
    char var[81];
    signed int ret = -1;
    int MODIFIED;


    if(!DOUBLE)
        return(0);

    getcwd(oldir, 81);

    cdd(DESTINATION);

    DST_BACK =  DIRBACK;
    DST_PEN  =  DIRPEN;
    MODIFIED = 0;

debut:
    mhide();
    WINMOVE_FLAG = 1;
    wincolor(DST_BACK, DST_HEAD, DST_PEN);
    DST_window();

    LIFTTMARGIN = 50;
    LIFTRMARGIN = 8;
    LIFTBMARGIN = 4;
    B_LIFT      = DST_BACK;
    putlift(1);

restart:
    PENCOL = 0;
    DST_window();
    num    = 0;
    DST_DIRSTART = 0;
    gotoxy(1,7);
    mhide();

    PENCOL = DST_PEN;

diskloop:
    freedisk(getdisk());

dirloop:
    DST_window();
    DST_FILEMAX = get_dest();

    mhide();
    getcwd(DESTINATION, 81);
    DST_dispdir();
    DST_freedisp();
    set_tag(0);

redisp:
    DST_window();
    DST_FILEMAX2 = DST_FILEMAX - 1;
    DST_DIRSTART = min(DST_DIRSTART, DST_FILEMAX - DST_REPH);
    DST_DIRSTART = max(0, DST_DIRSTART);
    num = max(num, DST_DIRSTART);

refresh:
    mhide();
    i = DST_DIRSTART;
    y = 0;

ploop:
    DST_print(y, i);
    i++;
    if(++y < DST_REPH)
        goto ploop;

    if(!flag)
        goto retour;

    FMAX = DST_DIRSTART + DST_REPH - 1;

encore:
    DST_window();
    num = min(num, DST_FILEMAX2);
    numberlift(num, DST_FILEMAX);

oloop:
    DST_inventry
    (num, 1);
    numold = num;

oloop2:
    if(MOUSE)
    {
        mshow();
        while(!kbhit())
        {
oloop1:
            click = mclick();
            mc = mx >> 3;
            ml = my >> 4;
            ch = '\0';
            if(click)
            {

                if(test_line(1, DST_TOP - 3, 39, 27))
                {
                    ch = KEY_LEFT;
                    goto orsk;
                }

                if(wininside())
                {
                    mrelease(1);
                    if(test_line(DST_LEFT, DST_TOP - 3, 78, DST_TOP - 3))
                    {
                        ch = ALT_P;
                        goto orsk;
                    }

                    ch = wmouselift(&num, DST_FILEMAX);
                    if(ch > 256)
                        goto orsk;
                    if(ch != -1)
                    {
                        if(num < DST_DIRSTART)
                        {
                            DST_DIRSTART = num;
                            goto redisp;
                        }
                        if(num > FMAX)
                        {
                            DST_DIRSTART = min(DST_FILEMAX-(FMAX-DST_DIRSTART),DST_DIRSTART+(num-FMAX));
                            goto redisp;
                        }
                        if(num == numold)
                            goto oloop2;
                        DST_inventry
                        (numold, 0);
                        goto oloop;
                    }

                    a = mc - WL;
                    b = ml - (WU + 1);
                    if(a > 1)
                        if(b > 1)
                            if(a < (WW - 3))
                                if(b < (WH - 3))
                                {
                                    a = (b - 2) + DST_DIRSTART;
                                    if((a < DST_DIRSTART) ||
                                            (a > FMAX) ||
                                            (a >= DST_FILEMAX))
                                        goto oloop2;
                                    num = a;
                                    if(num == numold)
                                    {
                                        ch = ENTER;
                                        goto orsk;
                                    }
                                    DST_inventry
                                    (numold, 0);
                                    goto encore;
                                }
                }

                goto oloop1;
            }
        }
    }
rech:
    ch = get1000();

orskrel:
    mrelease(1);
orsk:
    mhide();

    DST_inventry
    (numold, 0);

parse:
    switch(ch)
    {
    case KEY_UP:
        if(num > 0)
        {
            if(--num >= DST_DIRSTART)
                break;
            else
                if(DST_DIRSTART > 0)
                {
                    DST_DIRSTART--;
                    goto redisp;
                }
        }
        break;

    case CTRL_X:
        set_tag(0);
        goto refresh;
    case 'X':
        set_tag(TAGCOL);
        goto refresh;
    case ' ':
    case 'x':
        if(num < DST_DIRMAX)
            break;
        DST_DTAG[num] = TAGCOL - DST_DTAG[num];
        DST_inventry
        (numold, 0);

        /* on descend ensuite */

    case KEY_DOWN:
        if(num < DST_FILEMAX2)
        {
            if(++num > FMAX)
            {
                DST_DIRSTART++;
                goto redisp;
            }
        }
        break;
    case PAGE_UP:
        if(num > DST_DIRSTART)
            num = DST_DIRSTART;
        else
            if(num > 0)
            {
                DST_DIRSTART = max( DST_DIRSTART - DST_REPH, 0);
                num = DST_DIRSTART;
                goto redisp;
            }
        break;

    case PAGE_DOWN:
        if(num == FMAX)
            if(FMAX < DST_FILEMAX)
            {
                DST_DIRSTART += DST_REPH;
                FMAX = min(DST_FILEMAX2, DST_DIRSTART + DST_REPH - 1);
                num = FMAX;
                goto redisp;
            }
        num = FMAX;
        break;

    case HOME:
        DST_DIRSTART = 0;
        num = DISKMAX;
        goto redisp;
    case END:
        num = DST_FILEMAX2;
        if(FMAX < DST_FILEMAX2)
        {
            DST_DIRSTART = DST_FILEMAX - DST_REPH;
            goto redisp;
        }
        goto encore;

    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
        setdisk(ch - 'A');
        goto diskloop;

    case 'v':
    case CTRL_V:
        if(num < DST_DIRMAX)
            break;
        lock_dest(ch == 'v', num);
        get_dest();
        goto refresh;

    case 'n':
        if(num < DISKMAX)
            break;
        /* if(dest_root(num)) break;*/
        rename_entry
        (num, &DST_BUF[0]);
        get_dest();
        MODIFIED = 1;
        goto refresh;

    case DELETE:
        if(num < DISKMAX)
            break;
        if(dest_root(num))
            break;
        if(delete_dest(num))
        {
            MODIFIED = 1;
            goto diskloop;
        }
        break;

    case 'k':
        make_directory(var);
        MODIFIED = 1;
        goto dirloop;

    case ALT_K:
        if(make_directory(var))
        {
            cdd(var);
            MODIFIED = 1;
            goto dirloop;
        }
        break;

    case ALT_P:
        strcpy(var, DESTINATION);
        if(input_bar(var))
        {
            cdd(var);
            strcpy(DESTINATION, var);
            goto dirloop;
        }
        break;
        /*
         case ALT_TAB: swap_in_dest(oldir);
        	       goto dirloop;
        */
        /* case F2:    switch_DOUBLE();*/
    case TAB:
    case KEY_RIGHT:
    case 'q':
    case ALT_F4:
    case ESCAPE:
        ret = MODIFIED;
        goto retour;
    case ENTER:
        if(num < DISKMAX)
        {
            ch = buttondisk(num);
            goto parse;
        }
        if(DST_filetype[num] & 1)
        {
            chdir(DST_BUF[num]);
            goto dirloop;
        }
    default:
        beep();
        break;
    }
    goto encore;

retour:
    cdd(oldir);
    dir_lift();
    return(ret);
}

